/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.mapr.apis.SlfLogger;
import com.mapr.db.MetaTable;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.TabletInfo;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.DBRetryException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.exceptions.OpNotPermittedException;
import com.mapr.db.exceptions.TableClosedException;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.impl.MetaTableImpl;
import com.mapr.db.impl.RowKeyDocumentStream;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.impl.TabletInfoImpl;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.util.ByteBufs;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.MapRResultScanner;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.TableProperties;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;

public abstract class BaseJsonTable
implements Table,
SlfLogger {
    public static final String GET_DELETES_STR = "maprdb.table.impl.get_deletes";
    public static final String EXCLUDE_EMBEDDEDFAMILY_STR = "maprdb.table.impl.exclude_embeddedfamily";
    public static final String DECOMPRESS_STR = "maprdb.table.impl.decompress";
    public static final String READ_ALL_CFS_STR = "maprdb.table.impl.read_all_cfs";
    public static final String PRESERVE_TS_STR = "maprdb.table.impl.preserve_timestamps";
    protected static final long DEFAULT_BLOCK_SIZE = 8192L;
    protected MapRHTable maprTable = null;
    protected boolean closed = true;
    protected TableDescriptorImpl tableDesc;
    protected LinkedHashMap<String, KeyValue> tableOptionsMap;
    protected LinkedHashMap<TablePrivateOption, Object> tablePrivateOptionsMap;
    protected BiMap<FieldPath, Integer> unSortedIdPathMap;
    protected BiMap<FieldPath, Integer> idPathMap;
    protected BiMap<FieldPath, Integer> sortedByPathMap;
    protected BiMap<Integer, String> idToCFNameMap;
    protected List<Map.Entry<FieldPath, Integer>> sortedById;
    protected boolean insOrderInTable;
    protected String jsonString;
    private LinkedList<MetaTable> openMetaTables = Lists.newLinkedList();

    public BaseJsonTable(Configuration config) {
        if (config.getInt("fs.mapr.threads", 0) == 0) {
            config.setInt("fs.mapr.threads", 64);
        }
    }

    @Override
    public synchronized void close() throws DBException {
        try {
            if (!this.closed) {
                this.maprTable.close();
                this._doClose();
                for (MetaTable metaTable : this.openMetaTables) {
                    metaTable.close();
                }
                this.closed = true;
            }
        }
        catch (IOException ioe) {
            ExceptionHandler.handle(ioe, "close()");
        }
    }

    public synchronized void closeNoFlush() throws DBException {
        try {
            if (!this.closed) {
                this.maprTable.closeNoFlush();
                this._doClose();
                for (MetaTable metaTable : this.openMetaTables) {
                    metaTable.close();
                }
                this.closed = true;
            }
        }
        catch (IOException ioe) {
            ExceptionHandler.handle(ioe, "close()");
        }
    }

    protected abstract void _doClose();

    protected void initCommon(List<Dbserver.ColumnFamilyAttr> inCfAttrs) throws IOException {
        assert (this.maprTable != null);
        assert (!this.closed);
        Path tablePath = this.maprTable.getTablePath();
        TableProperties tblprop = this.maprTable.getInode().getTableProperties();
        if (!tblprop.getAttr().getJson()) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new OpNotPermittedException(tablePath + ": OJAI APIs are currently not supported with binary tables!");
        }
        Configuration config = this.maprTable.getConf();
        List cfAttrs = inCfAttrs;
        if (cfAttrs == null) {
            cfAttrs = this.maprTable.getMapRFS().listColumnFamily(tablePath, false, true);
        }
        this.tableOptionsMap = new LinkedHashMap();
        this.tablePrivateOptionsMap = new LinkedHashMap();
        this.tableOptionsMap.put("EXCLUDEID", DBValueBuilderImpl.KeyValueBuilder.initFrom(false));
        this.tableOptionsMap.put("BUFFERWRITE", DBValueBuilderImpl.KeyValueBuilder.initFrom(config.getBoolean("BUFFERWRITE", true)));
        this.insOrderInTable = tblprop.getAttr().getInsertionOrder();
        this.tableOptionsMap.put("KEEPINSERTIONORDER", DBValueBuilderImpl.KeyValueBuilder.initFrom(this.insOrderInTable));
        this.tablePrivateOptionsMap.put(TablePrivateOption.PRESERVE_TIMESTAMP, config.getBoolean(PRESERVE_TS_STR, false));
        this.tablePrivateOptionsMap.put(TablePrivateOption.GET_DELETES, config.getBoolean(GET_DELETES_STR, false));
        this.tablePrivateOptionsMap.put(TablePrivateOption.DECODE_TIMESTAMP, false);
        this.tablePrivateOptionsMap.put(TablePrivateOption.EXCLUDE_EMBEDDEDFAMILY, config.getBoolean(EXCLUDE_EMBEDDEDFAMILY_STR, false));
        this.tablePrivateOptionsMap.put(TablePrivateOption.DECOMPRESS, config.getBoolean(DECOMPRESS_STR, true));
        this.tablePrivateOptionsMap.put(TablePrivateOption.READ_ALL_CFS, config.getBoolean(READ_ALL_CFS_STR, true));
        MapRDBTableImplHelper.ComboMap ret = new MapRDBTableImplHelper.ComboMap();
        MapRDBTableImplHelper.getMaps(cfAttrs, ret);
        this.idToCFNameMap = ret.idToName;
        this.unSortedIdPathMap = ret.pathToId;
        this.sortedById = MapRDBTableImplHelper.sortByValueToList(this.unSortedIdPathMap);
        this.idPathMap = MapRDBTableImplHelper.sortByValue(this.unSortedIdPathMap);
        this.sortedByPathMap = MapRDBTableImplHelper.sortByPath(this.unSortedIdPathMap);
        this.tableDesc = new TableDescriptorImpl(tablePath, cfAttrs, tblprop);
        if (this.getLogger().isTraceEnabled() && this.idPathMap.size() > 1) {
            this.getLogger().trace("CF Path to Id Map unsorted: '{}'", this.unSortedIdPathMap);
            this.getLogger().trace("CF id List: '{}'", this.sortedById);
            this.getLogger().trace("CF Path to Id Map sorted by id: '{}'", this.idPathMap);
            this.getLogger().trace("CF Path to Id Map sorted by path: '{}'", this.sortedByPathMap);
            this.getLogger().trace("CF id to CF name Map: '{}'", this.idToCFNameMap);
        }
    }

    public MapRHTable maprTable() {
        return this.maprTable;
    }

    public BiMap<FieldPath, Integer> idPathMap() {
        return this.idPathMap;
    }

    List<Map.Entry<FieldPath, Integer>> sortedById() {
        return this.sortedById;
    }

    public Map<FieldPath, Integer> sortedByPath() {
        return this.sortedByPathMap;
    }

    public Map<Integer, String> idToCFNameMap() {
        return this.idToCFNameMap;
    }

    @Override
    public BaseJsonTable setOption(Table.TableOption option, boolean value) {
        switch (option) {
            case EXCLUDEID: {
                this.tableOptionsMap.put("EXCLUDEID", DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
                break;
            }
            case BUFFERWRITE: {
                this.tableOptionsMap.put("BUFFERWRITE", DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown table option " + (Object)((Object)option));
            }
        }
        return this;
    }

    public boolean isStream() {
        return this.tableDesc.isStream();
    }

    public boolean isExcludeId() {
        return this.tableOptionsMap.get("EXCLUDEID").getBoolean();
    }

    public boolean isKeepInsertionOrder() {
        return this.tableOptionsMap.get("KEEPINSERTIONORDER").getBoolean();
    }

    public boolean getDeletes() {
        return this.getPrivateOption(TablePrivateOption.GET_DELETES);
    }

    public boolean isBufferWrite() {
        return this.tableOptionsMap.get("BUFFERWRITE").getBoolean();
    }

    public boolean isPreserveTS() {
        return this.getPrivateOption(TablePrivateOption.PRESERVE_TIMESTAMP);
    }

    public boolean shouldDecompress() {
        return this.getPrivateOption(TablePrivateOption.DECOMPRESS);
    }

    public boolean decodeTimestamp() {
        return this.getPrivateOption(TablePrivateOption.DECODE_TIMESTAMP);
    }

    public void setExcludeEmbeddedFamily(boolean v) {
        this.setPrivateOption(TablePrivateOption.EXCLUDE_EMBEDDEDFAMILY, v);
    }

    public boolean excludeEmbeddedFamily() {
        return this.getPrivateOption(TablePrivateOption.EXCLUDE_EMBEDDEDFAMILY);
    }

    public void setReadAllCfs(boolean v) {
        this.setPrivateOption(TablePrivateOption.READ_ALL_CFS, v);
    }

    public boolean readAllCfs() {
        return this.getPrivateOption(TablePrivateOption.READ_ALL_CFS);
    }

    @Override
    public Value getOption(Table.TableOption option) {
        switch (option) {
            case EXCLUDEID: {
                return this.tableOptionsMap.get("EXCLUDEID");
            }
            case BUFFERWRITE: {
                return this.tableOptionsMap.get("BUFFERWRITE");
            }
        }
        throw new IllegalArgumentException("Unknown table option " + (Object)((Object)option));
    }

    public BaseJsonTable setPrivateOption(TablePrivateOption option, boolean value) {
        switch (option) {
            case PRESERVE_TIMESTAMP: 
            case GET_DELETES: 
            case DECODE_TIMESTAMP: 
            case EXCLUDE_EMBEDDEDFAMILY: 
            case DECOMPRESS: 
            case READ_ALL_CFS: {
                this.tablePrivateOptionsMap.put(option, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown table option " + (Object)((Object)option));
            }
        }
        return this;
    }

    public boolean getPrivateOption(TablePrivateOption option) {
        switch (option) {
            case PRESERVE_TIMESTAMP: 
            case GET_DELETES: 
            case DECODE_TIMESTAMP: 
            case EXCLUDE_EMBEDDEDFAMILY: 
            case DECOMPRESS: 
            case READ_ALL_CFS: {
                return (Boolean)this.tablePrivateOptionsMap.get((Object)option);
            }
        }
        throw new IllegalArgumentException("Unknown table option " + (Object)((Object)option));
    }

    @Override
    public String getName() {
        return this.getPath().getName();
    }

    @Override
    public Path getPath() {
        return this.tableDesc.getPath();
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        return this.tableDesc;
    }

    @Override
    public void flush() throws DBException {
        try {
            this.maprTable.flushCommits();
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "flush()");
        }
    }

    protected void checkClosed() throws DBException {
        if (this.closed) {
            throw new TableClosedException("Cannot perform the op on a closed table " + this.getPath());
        }
    }

    public QueryResult find(Query query) throws DBException {
        throw new UnsupportedOperationException("OJAI Queries are not supported by " + this.getClass().getSimpleName());
    }

    public DocumentStream findQuery(Query query) throws DBException {
        throw new UnsupportedOperationException("OJAI Queries are not supported by " + this.getClass().getSimpleName());
    }

    public DocumentStream findQuery(String queryJSON) throws DBException {
        throw new UnsupportedOperationException("OJAI Queries are not supported by " + this.getClass().getSimpleName());
    }

    @Override
    public Document findById(String id) throws DBException {
        return this._findById(IdCodec.encode(id), null, null);
    }

    @Override
    public Document findById(ByteBuffer id) throws DBException {
        return this._findById(IdCodec.encode(id), null, null);
    }

    @Override
    public Document findById(Value id) throws DBException {
        return this._findById(IdCodec.encode(id), null, null);
    }

    @Override
    public Document findById(String id, FieldPath ... fields) throws DBException {
        return this.findById(id, this.getStringPaths(fields));
    }

    @Override
    public Document findById(String id, String ... paths) throws DBException {
        return this._findById(IdCodec.encode(id), null, paths);
    }

    @Override
    public Document findById(ByteBuffer id, FieldPath ... fields) throws DBException {
        return this.findById(id, this.getStringPaths(fields));
    }

    @Override
    public Document findById(ByteBuffer id, String ... paths) throws DBException {
        return this._findById(IdCodec.encode(id), null, paths);
    }

    public Document findById(Value id, FieldPath ... fields) throws DBException {
        return this.findById(id, this.getStringPaths(fields));
    }

    public Document findById(Value id, String ... paths) throws DBException {
        return this._findById(IdCodec.encode(id), null, paths);
    }

    @Override
    public Document findById(String id, QueryCondition c) throws DBException {
        return this._findById(IdCodec.encode(id), c, new String[0]);
    }

    @Override
    public Document findById(ByteBuffer id, QueryCondition c) throws DBException {
        return this._findById(IdCodec.encode(id), c, new String[0]);
    }

    public Document findById(Value id, QueryCondition c) throws DBException {
        return this._findById(IdCodec.encode(id), c, new String[0]);
    }

    @Override
    public Document findById(String id, QueryCondition c, FieldPath ... fields) throws DBException {
        return this.findById(id, c, this.getStringPaths(fields));
    }

    @Override
    public Document findById(String id, QueryCondition c, String ... paths) throws DBException {
        return this._findById(IdCodec.encode(id), c, paths);
    }

    @Override
    public Document findById(ByteBuffer id, QueryCondition c, FieldPath ... fields) throws DBException {
        return this.findById(id, c, this.getStringPaths(fields));
    }

    @Override
    public Document findById(ByteBuffer id, QueryCondition c, String ... paths) throws DBException {
        return this._findById(IdCodec.encode(id), c, paths);
    }

    public Document findById(Value id, QueryCondition c, String ... paths) throws DBException {
        return this._findById(IdCodec.encode(id), c, paths);
    }

    public Document findById(Value id, QueryCondition c, FieldPath ... fields) throws DBException {
        return this.findById(id, c, this.getStringPaths(fields));
    }

    Document _findById(ByteBuffer id, QueryCondition c, String ... paths) throws DBException {
        this.checkClosed();
        Document d = null;
        while (true) {
            try {
                d = MapRDBTableImplHelper.doGet(this, id, c, this.isExcludeId(), paths);
            }
            catch (DBRetryException re) {
                this.updateSchema();
                continue;
            }
            break;
        }
        return d;
    }

    protected String[] getStringPaths(FieldPath ... fields) {
        if (fields == null) {
            return null;
        }
        String[] stringpaths = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            stringpaths[i] = fields[i].asPathString();
        }
        return stringpaths;
    }

    @Override
    public DocumentStream find() throws DBException {
        return this.find((QueryCondition)null, (String[])null);
    }

    @Override
    public DocumentStream find(String ... paths) throws DBException {
        return this.find((QueryCondition)null, paths);
    }

    @Override
    public DocumentStream find(FieldPath ... fields) throws DBException {
        return this.find((QueryCondition)null, this.getStringPaths(fields));
    }

    @Override
    public DocumentStream find(QueryCondition c) throws DBException {
        return this.find(c, (String[])null);
    }

    @Override
    public DocumentStream find(QueryCondition c, FieldPath ... fields) throws DBException {
        return this.find(c, this.getStringPaths(fields));
    }

    @Override
    public DocumentStream find(QueryCondition c, String ... paths) throws DBException {
        this.checkClosed();
        QueryResult d = null;
        while (true) {
            try {
                d = this._doScan(c, paths);
            }
            catch (DBRetryException re) {
                this.updateSchema();
                continue;
            }
            break;
        }
        return d;
    }

    protected abstract QueryResult _doScan(QueryCondition var1, String ... var2);

    protected abstract ConditionImpl _cloneCondition(QueryCondition var1);

    protected abstract ConditionImpl _cloneConditionOptimized(QueryCondition var1);

    private void updateSchema() throws DBException {
        List cfAttrs = null;
        try {
            cfAttrs = this.maprTable.getMapRFS().listColumnFamily(this.maprTable.getTablePath(), false);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "updateSchema()");
        }
        MapRDBTableImplHelper.ComboMap ret = new MapRDBTableImplHelper.ComboMap();
        MapRDBTableImplHelper.getMaps(cfAttrs, ret);
        this.idToCFNameMap = ret.idToName;
        this.unSortedIdPathMap = ret.pathToId;
        this.sortedById = MapRDBTableImplHelper.sortByValueToList(this.unSortedIdPathMap);
        this.idPathMap = MapRDBTableImplHelper.sortByValue(this.unSortedIdPathMap);
        this.sortedByPathMap = MapRDBTableImplHelper.sortByPath(this.unSortedIdPathMap);
    }

    @Override
    public TabletInfo getTabletInfo(String _id) throws DBException {
        return this.getTabletInfo(DBValueBuilderImpl.KeyValueBuilder.initFrom(_id));
    }

    @Override
    public TabletInfo getTabletInfo(ByteBuffer _id) throws DBException {
        return this.getTabletInfo(DBValueBuilderImpl.KeyValueBuilder.initFrom(_id));
    }

    public TabletInfo getTabletInfo(Value _id) throws DBException {
        try {
            MapRTabletScanner scanner = this.maprTable.getTabletScanner(Bytes.getBytes((ByteBuffer)IdCodec.encode(_id)));
            Dbserver.TabletDesc tablet = scanner.next();
            if (tablet != null) {
                return this.toTabletInfo(tablet, true);
            }
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "getTabletInfo()");
        }
        return null;
    }

    @Override
    public TabletInfo[] getTabletInfos() throws DBException {
        return this.getTabletInfos(false, false);
    }

    @Override
    public TabletInfo[] getTabletInfos(boolean needSpaceUsage, boolean prefetchTabletMap) throws DBException {
        ArrayList tabletInfos = Lists.newArrayList();
        try {
            List nextTabletSet;
            MapRTabletScanner scanner = this.maprTable.getTabletScanner(needSpaceUsage, prefetchTabletMap);
            while ((nextTabletSet = scanner.nextSet()) != null) {
                for (Dbserver.TabletDesc tablet : nextTabletSet) {
                    tabletInfos.add(this.toTabletInfo(tablet, needSpaceUsage));
                }
            }
            return tabletInfos.toArray(new TabletInfo[tabletInfos.size()]);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "getTabletInfos()");
        }
    }

    @Override
    public TabletInfo[] getTabletInfos(QueryCondition condition) throws DBException {
        return this.getTabletInfos(condition, false, false);
    }

    @Override
    public TabletInfo[] getTabletInfos(QueryCondition condition, boolean needSpaceUsage, boolean prefetchTabletMap) throws DBException {
        try {
            return this._getTabletInfos(condition, needSpaceUsage, prefetchTabletMap);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "getTabletInfos()");
        }
    }

    @Deprecated
    public TabletInfo[] getTabletInfos(byte[] startKey, byte[] endKey, boolean needSpaceUsage) throws DBException {
        ArrayList tabletInfos;
        block4: {
            tabletInfos = Lists.newArrayList();
            try {
                List nextTabletSet;
                MapRTabletScanner scanner = this.maprTable.getTabletScanner(startKey, endKey, needSpaceUsage, false);
                while ((nextTabletSet = scanner.nextSet()) != null) {
                    for (Dbserver.TabletDesc tablet : nextTabletSet) {
                        tabletInfos.add(this.toTabletInfo(tablet, needSpaceUsage));
                        if (tablet.getEndKey() != null && tablet.getEndKey().size() != 0 && Bytes.compareTo((byte[])tablet.getEndKey().toByteArray(), (byte[])endKey) <= 0) continue;
                        break block4;
                    }
                }
            }
            catch (IOException e) {
                throw ExceptionHandler.handle(e, "getTabletInfos() failed");
            }
        }
        return tabletInfos.toArray(new TabletInfo[tabletInfos.size()]);
    }

    protected abstract TabletInfo[] _getTabletInfos(@API.Nullable QueryCondition var1, boolean var2, boolean var3) throws IOException;

    public abstract List<ConditionNode.RowkeyRange> getRowkeyRanges(QueryCondition var1);

    public long getAverageRowSize() throws IOException {
        return this.maprTable.getAverageRowSize();
    }

    public Dbserver.TableBasicStats getScanRangeStats(@API.Nullable QueryCondition condition) throws IOException {
        byte[] startRow = MapRConstants.EMPTY_START_ROW;
        byte[] endRow = MapRConstants.EMPTY_END_ROW;
        List<ConditionNode.RowkeyRange> rowkeys = null;
        if (condition != null) {
            rowkeys = this.getRowkeyRanges(condition);
        }
        Dbserver.TableBasicStats scrStats = null;
        if (rowkeys != null && rowkeys.size() != 1) {
            throw new IOException("Condition " + (condition == null ? "EMPTY" : condition.toString()) + " does not result in a single rowkey range");
        }
        if (rowkeys != null && rowkeys.size() > 0) {
            ConditionNode.RowkeyRange rr = rowkeys.get(0);
            startRow = rr.getStartRow();
            endRow = rr.getStopRow();
        }
        scrStats = this.maprTable.getScanRangeStats(startRow, endRow);
        return scrStats;
    }

    protected TabletInfo toTabletInfo(Dbserver.TabletDesc tablet, boolean needSpaceUsage) throws IOException {
        return this.toTabletInfo(tablet, null, needSpaceUsage);
    }

    protected TabletInfo toTabletInfo(Dbserver.TabletDesc tablet, ConditionNode.RowkeyRange rr, boolean needSpaceUsage) throws IOException {
        Dbserver.TabletStatResponse tsr;
        int cid = tablet.getFid().getCid();
        String host = this.maprTable.getServerForCid(cid);
        String[] tokens = host.split(":");
        if (tokens == null || tokens.length != 2) {
            throw new IOException("Bad host information for cid=" + cid + ", host=" + host);
        }
        long estimatedSize = -1L;
        long estimatedNumRows = -1L;
        if (tablet.hasSpaceUsage()) {
            estimatedNumRows = tablet.getSpaceUsage().getNumRows();
            estimatedSize = tablet.getSpaceUsage().getNumLogicalBlocks() * 8192L;
        } else if (needSpaceUsage && (tsr = this.maprTable.getMapRFS().getTabletStat(this.tableDesc.getPath(), tablet.getFid())) != null && tsr.hasUsage()) {
            Dbserver.SpaceUsage su = tsr.getUsage();
            estimatedNumRows = su.getNumRows();
            estimatedSize = su.getNumLogicalBlocks() * 8192L;
        }
        byte[] startKey = tablet.getStartKey().toByteArray();
        byte[] stopKey = tablet.getEndKey().toByteArray();
        if (rr != null) {
            startKey = Bytes.maxOfStartRows((byte[])startKey, (byte[])rr.getStartRow());
            stopKey = Bytes.minOfStopRows((byte[])stopKey, (byte[])rr.getStopRow());
        }
        ConditionImpl c = this.getRangeCondition(startKey, stopKey);
        return new TabletInfoImpl(c, new String[]{tokens[0]}, estimatedSize, estimatedNumRows, tablet.getFid());
    }

    protected ConditionImpl getRangeConditionCommon(ConditionImpl c, byte[] startKey, byte[] stopKey) {
        boolean hasStopKey;
        boolean hasStartKey = !this.isNullValue(startKey);
        boolean bl = hasStopKey = !this.isNullValue(stopKey);
        if (hasStartKey && hasStopKey) {
            c.and();
        }
        if (hasStartKey) {
            c.is(Constants.ROWKEY_FIELD_PATH, QueryCondition.Op.GREATER_OR_EQUAL, ByteBufs.wrap(startKey));
        }
        if (hasStopKey) {
            c.is(Constants.ROWKEY_FIELD_PATH, QueryCondition.Op.LESS, ByteBufs.wrap(stopKey));
        }
        if (hasStartKey && hasStopKey) {
            c.close();
        }
        return c.build();
    }

    protected ConditionImpl getRangeCondition(byte[] startKey, byte[] stopKey) {
        ConditionImpl c = new ConditionImpl();
        return this.getRangeConditionCommon(c, startKey, stopKey);
    }

    private boolean isNullValue(byte[] startKey) {
        return startKey == null || startKey.length == 0;
    }

    @API.Internal
    public DocumentStream segmentKeyScan() throws DBException {
        return this.segmentKeyScan(MapRConstants.EMPTY_START_ROW, MapRConstants.EMPTY_END_ROW, -1);
    }

    @API.Internal
    public DocumentStream segmentKeyScan(int chunkSizeMBs) throws DBException {
        return this.segmentKeyScan(MapRConstants.EMPTY_START_ROW, MapRConstants.EMPTY_END_ROW, chunkSizeMBs);
    }

    @API.Internal
    public DocumentStream segmentKeyScan(byte[] startKey, byte[] endKey) throws DBException {
        return this.segmentKeyScan(startKey, endKey, -1);
    }

    @API.Internal
    public DocumentStream segmentKeyScan(byte[] startKey, byte[] stopKey, int chunkSizeMBs) throws DBException {
        this.checkClosed();
        MapRScan maprscan = new MapRScan();
        maprscan.batch = 0;
        maprscan.caching = 0;
        maprscan.startRow = startKey;
        maprscan.stopRow = stopKey;
        maprscan.filter = null;
        maprscan.rowConstraint = MapRDBTableImplHelper.toRowConstraint(this, null);
        Dbfilters.KeySamplingFilterProto ksFilter = chunkSizeMBs == -1 ? Dbfilters.KeySamplingFilterProto.newBuilder().build() : Dbfilters.KeySamplingFilterProto.newBuilder().setChunkSizeMBs(chunkSizeMBs).build();
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("3427db73").setSerializedState(ksFilter.toByteString()).build();
        byte[] serFilt = Bytes.getBytes((ByteBuffer)filterMsg.toByteString().asReadOnlyByteBuffer());
        maprscan.setFilter(serFilt);
        try {
            long id = this.maprTable.getInode().getScanner(maprscan);
            MapRResultScanner scanner = new MapRResultScanner(maprscan, this.maprTable, id);
            this.maprTable.addScanner(scanner);
            return new RowKeyDocumentStream(scanner);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "segmentKeyScan()");
        }
    }

    public abstract TableType getTableType();

    public abstract boolean isIndex();

    public Dbserver.SIndexInfo getIndexInfo() {
        throw new UnsupportedOperationException("Index info is not available for " + this.getClass().getSimpleName());
    }

    public List<IndexFieldDesc> getIndexedFieldList() {
        throw new UnsupportedOperationException("Index field list is not available for " + this.getClass().getSimpleName());
    }

    public void beginTrackingWrites() throws DBException {
        throw new UnsupportedOperationException("beginTrackingWrites() " + this.getClass().getSimpleName());
    }

    public void beginTrackingWrites(String previousContext) throws DBException {
        throw new UnsupportedOperationException("beginTrackingWrites() " + this.getClass().getSimpleName());
    }

    public void clearTrackedWrites() throws DBException {
        throw new UnsupportedOperationException("clearTrackedWrites() " + this.getClass().getSimpleName());
    }

    public String endTrackingWrites() throws DBException {
        throw new UnsupportedOperationException("endTrackingWrites() " + this.getClass().getSimpleName());
    }

    @Override
    public MetaTable getMetaTable() throws DBException {
        this.checkClosed();
        MetaTableImpl meta = new MetaTableImpl(this);
        this.openMetaTables.add(meta);
        return meta;
    }

    public String getFidStr() {
        return this.maprTable.getInode().getFidStr();
    }

    public String toString() {
        return this.asJsonString();
    }

    static enum BatchingType {
        INSERTORREPLACE,
        INSERT,
        REPLACE,
        DELETE;

    }

    public static enum TableType {
        TABLE_PRIMARY,
        TABLE_INDEX,
        TABLE_INDEX_HASHED;

    }

    public static enum TablePrivateOption {
        PRESERVE_TIMESTAMP,
        GET_DELETES,
        DECODE_TIMESTAMP,
        EXCLUDE_EMBEDDEDFAMILY,
        DECOMPRESS,
        READ_ALL_CFS;

    }
}

