/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.IOException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

class RelativeRedirectResponseWrapper
extends HttpServletResponseWrapper {
    private final HttpStatus redirectStatus;

    private RelativeRedirectResponseWrapper(HttpServletResponse response, HttpStatus redirectStatus) {
        super(response);
        Assert.notNull((Object)redirectStatus, "'redirectStatus' is required");
        this.redirectStatus = redirectStatus;
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.setStatus(this.redirectStatus.value());
        this.setHeader("Location", location);
    }

    public static HttpServletResponse wrapIfNecessary(HttpServletResponse response, HttpStatus redirectStatus) {
        return RelativeRedirectResponseWrapper.hasWrapper(response) ? response : new RelativeRedirectResponseWrapper(response, redirectStatus);
    }

    private static boolean hasWrapper(ServletResponse response) {
        if (response instanceof RelativeRedirectResponseWrapper) {
            return true;
        }
        while (response instanceof HttpServletResponseWrapper) {
            if (!((response = ((HttpServletResponseWrapper)response).getResponse()) instanceof RelativeRedirectResponseWrapper)) continue;
            return true;
        }
        return false;
    }
}

