/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.NoSuchElementException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

abstract class AbstractXMLEventReader
implements XMLEventReader {
    private boolean closed;

    AbstractXMLEventReader() {
    }

    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException ex) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported on " + ClassUtils.getShortName(this.getClass()));
    }

    @Override
    public String getElementText() throws XMLStreamException {
        XMLEvent event;
        this.checkIfClosed();
        if (!this.peek().isStartElement()) {
            throw new XMLStreamException("Not at START_ELEMENT");
        }
        StringBuilder builder = new StringBuilder();
        while (!(event = this.nextEvent()).isEndElement()) {
            if (!event.isCharacters()) {
                throw new XMLStreamException("Unexpected event [" + event + "] in getElementText()");
            }
            Characters characters = event.asCharacters();
            if (characters.isIgnorableWhiteSpace()) continue;
            builder.append(event.asCharacters().getData());
        }
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent event;
        this.checkIfClosed();
        block6: while (true) {
            event = this.nextEvent();
            switch (event.getEventType()) {
                case 1: 
                case 2: {
                    return event;
                }
                case 8: {
                    return null;
                }
                case 3: 
                case 5: 
                case 6: {
                    continue block6;
                }
                case 4: 
                case 12: {
                    if (!event.asCharacters().isWhiteSpace()) throw new XMLStreamException("Non-ignorable whitespace CDATA or CHARACTERS event in nextTag()");
                    continue block6;
                }
            }
            break;
        }
        throw new XMLStreamException("Received event [" + event + "], instead of START_ELEMENT or END_ELEMENT.");
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException("Property not supported: [" + name + "]");
    }

    @Override
    public void close() {
        this.closed = true;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void checkIfClosed() throws XMLStreamException {
        if (this.isClosed()) {
            throw new XMLStreamException("XMLEventReader has been closed");
        }
    }
}

