/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.savedrequest;

import java.net.URI;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.web.server.savedrequest.ServerRequestCache;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public class WebSessionServerRequestCache
implements ServerRequestCache {
    private static final String DEFAULT_SAVED_REQUEST_ATTR = "SPRING_SECURITY_SAVED_REQUEST";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String sessionAttrName = "SPRING_SECURITY_SAVED_REQUEST";
    private ServerWebExchangeMatcher saveRequestMatcher = ServerWebExchangeMatchers.pathMatchers(HttpMethod.GET, "/**");

    public void setSaveRequestMatcher(ServerWebExchangeMatcher saveRequestMatcher) {
        Assert.notNull((Object)saveRequestMatcher, "saveRequestMatcher cannot be null");
        this.saveRequestMatcher = saveRequestMatcher;
    }

    @Override
    public Mono<Void> saveRequest(ServerWebExchange exchange2) {
        return this.saveRequestMatcher.matches(exchange2).filter(m -> m.isMatch()).flatMap(m -> exchange2.getSession()).map(WebSession::getAttributes).doOnNext(attrs -> attrs.put(this.sessionAttrName, WebSessionServerRequestCache.pathInApplication(exchange2.getRequest()))).then();
    }

    @Override
    public Mono<URI> getRedirectUri(ServerWebExchange exchange2) {
        return exchange2.getSession().flatMap(session -> Mono.justOrEmpty(session.getAttribute(this.sessionAttrName))).map(URI::create);
    }

    @Override
    public Mono<ServerHttpRequest> removeMatchingRequest(ServerWebExchange exchange2) {
        return exchange2.getSession().map(WebSession::getAttributes).filter(attributes -> attributes.remove(this.sessionAttrName, WebSessionServerRequestCache.pathInApplication(exchange2.getRequest()))).map(attributes -> exchange2.getRequest());
    }

    private static String pathInApplication(ServerHttpRequest request) {
        return request.getPath().pathWithinApplication().value();
    }
}

