/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.jackson2;

import java.io.IOException;
import java.util.List;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.core.type.TypeReference;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.JsonDeserializer;
import oadd.com.fasterxml.jackson.databind.JsonNode;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.node.MissingNode;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

class PreAuthenticatedAuthenticationTokenDeserializer
extends JsonDeserializer<PreAuthenticatedAuthenticationToken> {
    PreAuthenticatedAuthenticationTokenDeserializer() {
    }

    @Override
    public PreAuthenticatedAuthenticationToken deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        PreAuthenticatedAuthenticationToken token = null;
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(jp);
        Boolean authenticated = this.readJsonNode(jsonNode, "authenticated").asBoolean();
        JsonNode principalNode = this.readJsonNode(jsonNode, "principal");
        Object principal = null;
        principal = principalNode.isObject() ? mapper.readValue(principalNode.traverse(mapper), Object.class) : principalNode.asText();
        String credentials = this.readJsonNode(jsonNode, "credentials").asText();
        List authorities = (List)mapper.readValue(this.readJsonNode(jsonNode, "authorities").traverse(mapper), new TypeReference<List<GrantedAuthority>>(){});
        token = authenticated != false ? new PreAuthenticatedAuthenticationToken(principal, credentials, authorities) : new PreAuthenticatedAuthenticationToken(principal, credentials);
        token.setDetails(this.readJsonNode(jsonNode, "details"));
        return token;
    }

    private JsonNode readJsonNode(JsonNode jsonNode, String field) {
        return jsonNode.has(field) ? jsonNode.get(field) : MissingNode.getInstance();
    }
}

