/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.web.authentication;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.kerberos.authentication.KerberosServiceRequestToken;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class ResponseHeaderSettingKerberosAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private static final String NEGOTIATE_PREFIX = "Negotiate ";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private String headerName = "WWW-Authenticate";
    private String headerPrefix = "Negotiate ";

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public void setHeaderPrefix(String headerPrefix) {
        this.headerPrefix = headerPrefix;
    }

    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        KerberosServiceRequestToken auth = (KerberosServiceRequestToken)authentication;
        if (auth.hasResponseToken()) {
            response.addHeader(this.headerName, this.headerPrefix + auth.getEncodedResponseToken());
        }
    }
}

