/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.authentication;

import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.kerberos.authentication.KerberosServiceRequestToken;
import org.springframework.security.kerberos.authentication.KerberosTicketValidation;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;
import org.springframework.util.Assert;

public class KerberosServiceAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(KerberosServiceAuthenticationProvider.class);
    private KerberosTicketValidator ticketValidator;
    private UserDetailsService userDetailsService;
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        KerberosServiceRequestToken auth = (KerberosServiceRequestToken)authentication;
        byte[] token = auth.getToken();
        LOG.debug((Object)"Try to validate Kerberos Token");
        KerberosTicketValidation ticketValidation = this.ticketValidator.validateTicket(token);
        LOG.debug((Object)("Succesfully validated " + ticketValidation.username()));
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(ticketValidation.username());
        this.userDetailsChecker.check(userDetails);
        this.additionalAuthenticationChecks(userDetails, auth);
        KerberosServiceRequestToken responseAuth = new KerberosServiceRequestToken(userDetails, ticketValidation, userDetails.getAuthorities(), token);
        responseAuth.setDetails(authentication.getDetails());
        return responseAuth;
    }

    public boolean supports(Class<? extends Object> auth) {
        return KerberosServiceRequestToken.class.isAssignableFrom(auth);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.ticketValidator, "ticketValidator must be specified");
        Assert.notNull((Object)this.userDetailsService, "userDetailsService must be specified");
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setTicketValidator(KerberosTicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, KerberosServiceRequestToken authentication) throws AuthenticationException {
    }
}

