/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import java.util.Collections;
import java.util.List;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import org.springframework.http.MediaType;
import org.springframework.http.codec.json.AbstractJackson2Encoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class Jackson2SmileEncoder
extends AbstractJackson2Encoder {
    private static final MimeType SMILE_MIME_TYPE = new MediaType("application", "x-jackson-smile");

    public Jackson2SmileEncoder() {
        this((ObjectMapper)Jackson2ObjectMapperBuilder.smile().build(), new MediaType("application", "x-jackson-smile"));
    }

    public Jackson2SmileEncoder(ObjectMapper mapper, MimeType ... mimeTypes) {
        super(mapper, mimeTypes);
        Assert.isAssignable(SmileFactory.class, mapper.getFactory().getClass());
        this.streamingMediaTypes.add(new MediaType("application", "stream+x-jackson-smile"));
    }

    @Override
    public List<MimeType> getEncodableMimeTypes() {
        return Collections.singletonList(SMILE_MIME_TYPE);
    }
}

