/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.IntPredicate;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public class StringDecoder
extends AbstractDataBufferDecoder<String> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final IntPredicate NEWLINE_DELIMITER = b -> b == 10 || b == 13;
    private final boolean splitOnNewline;

    private StringDecoder(boolean splitOnNewline, MimeType ... mimeTypes) {
        super(mimeTypes);
        this.splitOnNewline = splitOnNewline;
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return super.canDecode(elementType, mimeType) && String.class.equals(elementType.getRawClass());
    }

    @Override
    public Flux<String> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        Flux inputFlux = Flux.from(inputStream);
        if (this.splitOnNewline) {
            inputFlux = Flux.from(inputStream).flatMap(StringDecoder::splitOnNewline);
        }
        return super.decode((Publisher<DataBuffer>)inputFlux, elementType, mimeType, hints);
    }

    private static Flux<DataBuffer> splitOnNewline(DataBuffer dataBuffer) {
        int endIdx;
        ArrayList<DataBuffer> results = new ArrayList<DataBuffer>();
        int startIdx = 0;
        int limit = dataBuffer.readableByteCount();
        do {
            int length = (endIdx = dataBuffer.indexOf(NEWLINE_DELIMITER, startIdx)) != -1 ? endIdx - startIdx + 1 : limit - startIdx;
            DataBuffer token = dataBuffer.slice(startIdx, length);
            results.add(DataBufferUtils.retain(token));
        } while ((startIdx = endIdx + 1) < limit && endIdx != -1);
        DataBufferUtils.release(dataBuffer);
        return Flux.fromIterable(results);
    }

    @Override
    protected String decodeDataBuffer(DataBuffer dataBuffer, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        Charset charset = this.getCharset(mimeType);
        CharBuffer charBuffer = charset.decode(dataBuffer.asByteBuffer());
        DataBufferUtils.release(dataBuffer);
        return charBuffer.toString();
    }

    private Charset getCharset(@Nullable MimeType mimeType) {
        if (mimeType != null && mimeType.getCharset() != null) {
            return mimeType.getCharset();
        }
        return DEFAULT_CHARSET;
    }

    public static StringDecoder textPlainOnly(boolean splitOnNewline) {
        return new StringDecoder(splitOnNewline, new MimeType("text", "plain", DEFAULT_CHARSET));
    }

    public static StringDecoder allMimeTypes(boolean splitOnNewline) {
        return new StringDecoder(splitOnNewline, new MimeType("text", "plain", DEFAULT_CHARSET), MimeTypeUtils.ALL);
    }
}

