/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.metastore;

import java.util.List;
import oadd.org.apache.drill.metastore.CollectableColumnStatisticsKind;
import oadd.org.apache.drill.metastore.ColumnStatistics;

public enum ColumnStatisticsKind implements CollectableColumnStatisticsKind
{
    NULLS_COUNT("nullsCount"){

        @Override
        public Object mergeStatistics(List<? extends ColumnStatistics> statisticsList) {
            long nullsCount = 0L;
            for (ColumnStatistics columnStatistics : statisticsList) {
                Long statNullsCount = (Long)columnStatistics.getStatistic(this);
                if (statNullsCount == null || statNullsCount == -1L) {
                    return -1L;
                }
                nullsCount += statNullsCount.longValue();
            }
            return nullsCount;
        }

        @Override
        public boolean isExact() {
            return true;
        }
    }
    ,
    MIN_VALUE("minValue"){

        @Override
        public Object mergeStatistics(List<? extends ColumnStatistics> statisticsList) {
            Object minValue = null;
            for (ColumnStatistics columnStatistics : statisticsList) {
                Object statMinValue = columnStatistics.getValueStatistic(this);
                if (statMinValue == null || columnStatistics.getValueComparator().compare(minValue, statMinValue) <= 0 && minValue != null) continue;
                minValue = statMinValue;
            }
            return minValue;
        }

        @Override
        public boolean isValueStatistic() {
            return true;
        }

        @Override
        public boolean isExact() {
            return true;
        }
    }
    ,
    MAX_VALUE("maxValue"){

        @Override
        public Object mergeStatistics(List<? extends ColumnStatistics> statisticsList) {
            Object maxValue = null;
            for (ColumnStatistics columnStatistics : statisticsList) {
                Object statMaxValue = columnStatistics.getValueStatistic(this);
                if (statMaxValue == null || columnStatistics.getValueComparator().compare(maxValue, statMaxValue) >= 0) continue;
                maxValue = statMaxValue;
            }
            return maxValue;
        }

        @Override
        public boolean isValueStatistic() {
            return true;
        }

        @Override
        public boolean isExact() {
            return true;
        }
    }
    ,
    NON_NULL_COUNT("nonnullrowcount"){

        @Override
        public Double mergeStatistics(List<? extends ColumnStatistics> statisticsList) {
            double nonNullRowCount = 0.0;
            for (ColumnStatistics columnStatistics : statisticsList) {
                Double nnRowCount = (Double)columnStatistics.getStatistic(this);
                if (nnRowCount == null) continue;
                nonNullRowCount += nnRowCount.doubleValue();
            }
            return nonNullRowCount;
        }
    }
    ,
    ROWCOUNT("rowcount"){

        @Override
        public Double mergeStatistics(List<? extends ColumnStatistics> statisticsList) {
            double rowCount = 0.0;
            for (ColumnStatistics columnStatistics : statisticsList) {
                Double count = (Double)columnStatistics.getStatistic(this);
                if (count == null) continue;
                rowCount += count.doubleValue();
            }
            return rowCount;
        }
    }
    ,
    NDV("approx_count_distinct"){

        @Override
        public Object mergeStatistics(List<? extends ColumnStatistics> statisticsList) {
            throw new UnsupportedOperationException("Cannot merge statistics for NDV");
        }
    }
    ,
    AVG_WIDTH("avg_width"){

        @Override
        public Object mergeStatistics(List<? extends ColumnStatistics> statisticsList) {
            throw new UnsupportedOperationException("Cannot merge statistics for avg_width");
        }
    }
    ,
    HISTOGRAM("histogram"){

        @Override
        public Object mergeStatistics(List<? extends ColumnStatistics> statisticsList) {
            throw new UnsupportedOperationException("Cannot merge statistics for histogram");
        }
    };

    private final String statisticKey;

    private ColumnStatisticsKind(String statisticKey) {
        this.statisticKey = statisticKey;
    }

    @Override
    public String getName() {
        return this.statisticKey;
    }
}

