/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import java.util.LinkedHashMap;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.holders.ComplexHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedMapHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedValueHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.CallBack;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.SchemaChangeCallBack;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractRepeatedMapVector;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.MapVector;
import oadd.org.apache.drill.exec.vector.complex.impl.NullReader;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedMapReaderImpl;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class RepeatedMapVector
extends AbstractRepeatedMapVector {
    public static final TypeProtos.MajorType TYPE = Types.repeated(TypeProtos.MinorType.MAP);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private final RepeatedMapReaderImpl reader = new RepeatedMapReaderImpl(this);

    public RepeatedMapVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        super(field, allocator, callBack);
    }

    public RepeatedMapVector(MaterializedField field, UInt4Vector offsets, CallBack callBack) {
        super(field, offsets, callBack);
    }

    @Override
    public RepeatedMapReaderImpl getReader() {
        return this.reader;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new RepeatedMapTransferPair(this.getField().getName(), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new RepeatedMapTransferPair((RepeatedMapVector)to);
    }

    MapSingleCopier makeSingularCopier(MapVector to) {
        return new MapSingleCopier(this, to);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new RepeatedMapTransferPair(ref, allocator);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    RepeatedValueHolder getValueHolder() {
        return new RepeatedMapHolder();
    }

    public class Mutator
    extends AbstractRepeatedMapVector.Mutator {
    }

    public class Accessor
    extends AbstractRepeatedMapVector.Accessor {
        @Override
        public Object getObject(int index) {
            JsonStringArrayList<LinkedHashMap<String, Object>> list = new JsonStringArrayList<LinkedHashMap<String, Object>>();
            int end = RepeatedMapVector.this.offsets.getAccessor().get(index + 1);
            for (int i = RepeatedMapVector.this.offsets.getAccessor().get(index); i < end; ++i) {
                LinkedHashMap<String, Object> vv = Maps.newLinkedHashMap();
                for (MaterializedField field : RepeatedMapVector.this.getField().getChildren()) {
                    String fieldName;
                    Object value;
                    if (field.equals(BaseRepeatedValueVector.OFFSETS_FIELD) || (value = RepeatedMapVector.this.getChild(fieldName = field.getName()).getAccessor().getObject(i)) == null) continue;
                    vv.put(fieldName, value);
                }
                list.add(vv);
            }
            return list;
        }

        public void get(int index, ComplexHolder holder) {
            RepeatedMapReaderImpl reader = RepeatedMapVector.this.getReader();
            reader.setPosition(index);
            holder.reader = reader;
        }

        public void get(int index, int arrayIndex, ComplexHolder holder) {
            RepeatedMapHolder h = new RepeatedMapHolder();
            this.get(index, h);
            int offset = h.start + arrayIndex;
            if (offset >= h.end) {
                holder.reader = NullReader.INSTANCE;
            } else {
                RepeatedMapVector.this.reader.setSinglePosition(index, arrayIndex);
                holder.reader = RepeatedMapVector.this.reader;
            }
        }
    }

    private class RepeatedMapTransferPair
    extends AbstractRepeatedMapVector.AbstractRepeatedMapTransferPair<RepeatedMapVector> {
        RepeatedMapTransferPair(String path, BufferAllocator allocator) {
            super((AbstractRepeatedMapVector)RepeatedMapVector.this, (AbstractRepeatedMapVector)new RepeatedMapVector(MaterializedField.create(path, TYPE), allocator, (CallBack)new SchemaChangeCallBack()), false);
        }

        RepeatedMapTransferPair(RepeatedMapVector to) {
            super((AbstractRepeatedMapVector)RepeatedMapVector.this, (AbstractRepeatedMapVector)to);
        }

        RepeatedMapTransferPair(RepeatedMapVector to, boolean allocate) {
            super((AbstractRepeatedMapVector)RepeatedMapVector.this, (AbstractRepeatedMapVector)to, allocate);
        }
    }

    protected static class MapSingleCopier {
        private final TransferPair[] pairs;
        public final RepeatedMapVector from;

        public MapSingleCopier(RepeatedMapVector from, MapVector to) {
            this.from = from;
            this.pairs = new TransferPair[from.size()];
            int i = 0;
            for (String child : from.getChildFieldNames()) {
                int preSize = to.size();
                ValueVector vector = from.getChild(child);
                if (vector == null) continue;
                Object newVector = to.addOrGet(child, vector.getField().getType(), vector.getClass());
                if (to.size() != preSize) {
                    newVector.allocateNew();
                }
                this.pairs[i++] = vector.makeTransferPair((ValueVector)newVector);
            }
        }

        public void copySafe(int fromSubIndex, int toIndex) {
            for (TransferPair p : this.pairs) {
                p.copyValueSafe(fromSubIndex, toIndex);
            }
        }
    }
}

