/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.convert.ColumnConversionFactory;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractScalarWriterImpl;
import oadd.org.apache.drill.exec.vector.accessor.writer.BaseScalarWriter;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.joda.time.Period;

public class ScalarArrayWriter
extends AbstractArrayWriter.BaseArrayWriter {
    private final ScalarWriter elementWriter;

    public ScalarArrayWriter(ColumnMetadata schema, RepeatedValueVector vector, BaseScalarWriter baseElementWriter, ColumnConversionFactory conversionFactory) {
        super(schema, vector.getOffsetVector(), new AbstractScalarWriterImpl.ScalarObjectWriter(baseElementWriter, conversionFactory));
        this.elementWriter = this.elementObjWriter.scalar();
    }

    public static AbstractArrayWriter.ArrayObjectWriter build(ColumnMetadata schema, RepeatedValueVector repeatedVector, BaseScalarWriter baseElementWriter, ColumnConversionFactory conversionFactory) {
        return new AbstractArrayWriter.ArrayObjectWriter(new ScalarArrayWriter(schema, repeatedVector, baseElementWriter, conversionFactory));
    }

    @Override
    public void bindIndex(ColumnWriterIndex index) {
        this.elementIndex = new ScalarElementWriterIndex();
        super.bindIndex(index);
        this.elementObjWriter.events().bindIndex(this.elementIndex);
    }

    @Override
    public void save() {
    }

    @Override
    public void setObject(Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return;
        }
        String objClass = array.getClass().getName();
        if (!objClass.startsWith("[")) {
            throw new IllegalArgumentException(String.format("Argument must be an array. Column `%s`, value = %s", this.schema().name(), array.toString()));
        }
        char second = objClass.charAt(1);
        block0 : switch (second) {
            case '[': {
                char third = objClass.charAt(2);
                switch (third) {
                    case 'B': {
                        this.setBytesArray((byte[][])array);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(String.format("Unknown Java array type: %s, for column `%s`", objClass, this.schema().name()));
            }
            case 'B': {
                this.setByteArray((byte[])array);
                break;
            }
            case 'S': {
                this.setShortArray((short[])array);
                break;
            }
            case 'I': {
                this.setIntArray((int[])array);
                break;
            }
            case 'J': {
                this.setLongArray((long[])array);
                break;
            }
            case 'F': {
                this.setFloatArray((float[])array);
                break;
            }
            case 'D': {
                this.setDoubleArray((double[])array);
                break;
            }
            case 'Z': {
                this.setBooleanArray((boolean[])array);
                break;
            }
            case 'L': {
                int posn = objClass.indexOf(59);
                String memberClassName = objClass.substring(2, posn);
                if (memberClassName.equals(String.class.getName())) {
                    this.setStringArray((String[])array);
                    break;
                }
                if (memberClassName.equals(Period.class.getName())) {
                    this.setPeriodArray((Period[])array);
                    break;
                }
                if (memberClassName.equals(BigDecimal.class.getName())) {
                    this.setBigDecimalArray((BigDecimal[])array);
                    break;
                }
                if (memberClassName.equals(Integer.class.getName())) {
                    this.setIntObjectArray((Integer[])array);
                    break;
                }
                if (memberClassName.equals(Long.class.getName())) {
                    this.setLongObjectArray((Long[])array);
                    break;
                }
                if (memberClassName.equals(Double.class.getName())) {
                    this.setDoubleObjectArray((Double[])array);
                    break;
                }
                throw new IllegalArgumentException("Unknown Java array type: " + memberClassName);
            }
            default: {
                throw new IllegalArgumentException("Unknown Java array type: " + objClass);
            }
        }
    }

    public void setBooleanArray(boolean[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setInt(value[i] ? 1 : 0);
        }
    }

    public void setBytesArray(byte[][] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setBytes(value[i], value[i].length);
        }
    }

    public void setByteArray(byte[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setInt(value[i]);
        }
    }

    public void setShortArray(short[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setInt(value[i]);
        }
    }

    public void setIntArray(int[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setInt(value[i]);
        }
    }

    public void setIntObjectArray(Integer[] value) {
        for (int i = 0; i < value.length; ++i) {
            Integer element = value[i];
            if (element == null) {
                this.elementWriter.setNull();
                continue;
            }
            this.elementWriter.setInt(element);
        }
    }

    public void setLongArray(long[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setLong(value[i]);
        }
    }

    public void setLongObjectArray(Long[] value) {
        for (int i = 0; i < value.length; ++i) {
            Long element = value[i];
            if (element == null) {
                this.elementWriter.setNull();
                continue;
            }
            this.elementWriter.setLong(element);
        }
    }

    public void setFloatArray(float[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setDouble(value[i]);
        }
    }

    public void setDoubleArray(double[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setDouble(value[i]);
        }
    }

    public void setDoubleObjectArray(Double[] value) {
        for (int i = 0; i < value.length; ++i) {
            Double element = value[i];
            if (element == null) {
                this.elementWriter.setNull();
                continue;
            }
            this.elementWriter.setDouble(element);
        }
    }

    public void setStringArray(String[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setString(value[i]);
        }
    }

    public void setPeriodArray(Period[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setPeriod(value[i]);
        }
    }

    public void setBigDecimalArray(BigDecimal[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setDecimal(value[i]);
        }
    }

    public class ScalarElementWriterIndex
    extends AbstractArrayWriter.ArrayElementWriterIndex {
        @Override
        public final void nextElement() {
            this.next();
        }
    }
}

