/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.convert;

import java.lang.reflect.Constructor;
import java.util.Map;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.convert.AbstractWriteConverter;
import oadd.org.apache.drill.exec.vector.accessor.convert.ColumnConversionFactory;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertBooleanToString;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertDateToString;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertDoubleToString;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertIntToString;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertIntervalToString;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertLongToString;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertStringToBoolean;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertStringToDate;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertStringToDecimal;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertStringToDouble;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertStringToInt;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertStringToInterval;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertStringToLong;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertStringToTime;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertStringToTimeStamp;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertTimeStampToString;
import oadd.org.apache.drill.exec.vector.accessor.convert.ConvertTimeToString;

public class StandardConversions {
    public static ColumnConversionFactory factory(Class<? extends AbstractWriteConverter> converterClass) {
        return new SimpleWriterConverterFactory(converterClass, null);
    }

    public static ColumnConversionFactory factory(Class<? extends AbstractWriteConverter> converterClass, Map<String, String> properties) {
        return new SimpleWriterConverterFactory(converterClass, properties);
    }

    public static AbstractWriteConverter newInstance(Class<? extends AbstractWriteConverter> conversionClass, ScalarWriter baseWriter, Map<String, String> properties) {
        try {
            Constructor<? extends AbstractWriteConverter> ctor = conversionClass.getDeclaredConstructor(ScalarWriter.class, Map.class);
            return ctor.newInstance(baseWriter, properties);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return StandardConversions.newInstance(conversionClass, baseWriter);
        }
    }

    public static AbstractWriteConverter newInstance(Class<? extends AbstractWriteConverter> conversionClass, ScalarWriter baseWriter) {
        try {
            Constructor<? extends AbstractWriteConverter> ctor = conversionClass.getDeclaredConstructor(ScalarWriter.class);
            return ctor.newInstance(baseWriter);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static ConversionDefn analyze(ColumnMetadata inputSchema, ColumnMetadata outputSchema) {
        if (inputSchema.type().equals(outputSchema.type())) {
            return new ConversionDefn(ConversionType.NONE);
        }
        switch (inputSchema.type()) {
            case VARCHAR: {
                return new ConversionDefn(StandardConversions.convertFromVarchar(outputSchema));
            }
            case BIT: {
                switch (outputSchema.type()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INT: {
                        return ConversionDefn.IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertBooleanToString.class);
                    }
                }
                break;
            }
            case TINYINT: {
                switch (outputSchema.type()) {
                    case SMALLINT: 
                    case INT: 
                    case BIGINT: 
                    case FLOAT4: 
                    case FLOAT8: 
                    case VARDECIMAL: {
                        return ConversionDefn.IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertIntToString.class);
                    }
                }
                break;
            }
            case SMALLINT: {
                switch (outputSchema.type()) {
                    case TINYINT: {
                        return ConversionDefn.IMPLICIT_UNSAFE;
                    }
                    case INT: 
                    case BIGINT: 
                    case FLOAT4: 
                    case FLOAT8: 
                    case VARDECIMAL: {
                        return ConversionDefn.IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertIntToString.class);
                    }
                }
                break;
            }
            case INT: {
                switch (outputSchema.type()) {
                    case TINYINT: 
                    case SMALLINT: {
                        return ConversionDefn.IMPLICIT_UNSAFE;
                    }
                    case BIGINT: 
                    case FLOAT4: 
                    case FLOAT8: 
                    case VARDECIMAL: 
                    case TIME: {
                        return ConversionDefn.IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertIntToString.class);
                    }
                }
                break;
            }
            case BIGINT: {
                switch (outputSchema.type()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INT: {
                        return ConversionDefn.IMPLICIT_UNSAFE;
                    }
                    case FLOAT4: 
                    case FLOAT8: 
                    case VARDECIMAL: 
                    case DATE: 
                    case TIMESTAMP: {
                        return ConversionDefn.IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertLongToString.class);
                    }
                }
                break;
            }
            case FLOAT4: {
                switch (outputSchema.type()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INT: 
                    case BIGINT: {
                        return ConversionDefn.IMPLICIT_UNSAFE;
                    }
                    case FLOAT8: 
                    case VARDECIMAL: {
                        return ConversionDefn.IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertDoubleToString.class);
                    }
                }
                break;
            }
            case FLOAT8: {
                switch (outputSchema.type()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INT: 
                    case BIGINT: 
                    case FLOAT4: {
                        return ConversionDefn.IMPLICIT_UNSAFE;
                    }
                    case VARDECIMAL: {
                        return ConversionDefn.IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertDoubleToString.class);
                    }
                }
                break;
            }
            case DATE: {
                switch (outputSchema.type()) {
                    case BIGINT: {
                        return ConversionDefn.IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertDateToString.class);
                    }
                }
                break;
            }
            case TIME: {
                switch (outputSchema.type()) {
                    case INT: {
                        return ConversionDefn.IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertTimeToString.class);
                    }
                }
                break;
            }
            case TIMESTAMP: {
                switch (outputSchema.type()) {
                    case BIGINT: {
                        return ConversionDefn.IMPLICIT;
                    }
                    case VARCHAR: {
                        return new ConversionDefn(ConvertTimeStampToString.class);
                    }
                }
                break;
            }
            case INTERVAL: 
            case INTERVALYEAR: 
            case INTERVALDAY: {
                switch (outputSchema.type()) {
                    case VARCHAR: {
                        return new ConversionDefn(ConvertIntervalToString.class);
                    }
                }
                break;
            }
        }
        return ConversionDefn.EXPLICIT;
    }

    public static Class<? extends AbstractWriteConverter> convertFromVarchar(ColumnMetadata outputDefn) {
        switch (outputDefn.type()) {
            case BIT: {
                return ConvertStringToBoolean.class;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case UINT1: 
            case UINT2: {
                return ConvertStringToInt.class;
            }
            case BIGINT: {
                return ConvertStringToLong.class;
            }
            case FLOAT4: 
            case FLOAT8: {
                return ConvertStringToDouble.class;
            }
            case DATE: {
                return ConvertStringToDate.class;
            }
            case TIME: {
                return ConvertStringToTime.class;
            }
            case TIMESTAMP: {
                return ConvertStringToTimeStamp.class;
            }
            case INTERVAL: 
            case INTERVALYEAR: 
            case INTERVALDAY: {
                return ConvertStringToInterval.class;
            }
            case VARDECIMAL: {
                return ConvertStringToDecimal.class;
            }
        }
        return null;
    }

    public static class SimpleWriterConverterFactory
    implements ColumnConversionFactory {
        private final Class<? extends AbstractWriteConverter> conversionClass;
        private final Map<String, String> properties;

        SimpleWriterConverterFactory(Class<? extends AbstractWriteConverter> conversionClass, Map<String, String> properties) {
            this.conversionClass = conversionClass;
            this.properties = properties;
        }

        @Override
        public AbstractWriteConverter newWriter(ScalarWriter baseWriter) {
            return StandardConversions.newInstance(this.conversionClass, baseWriter, this.properties);
        }
    }

    public static class ConversionDefn {
        public static final ConversionDefn IMPLICIT = new ConversionDefn(ConversionType.IMPLICIT);
        public static final ConversionDefn IMPLICIT_UNSAFE = new ConversionDefn(ConversionType.IMPLICIT_UNSAFE);
        public static final ConversionDefn EXPLICIT = new ConversionDefn(ConversionType.EXPLICIT);
        public final ConversionType type;
        public final Class<? extends AbstractWriteConverter> conversionClass;

        public ConversionDefn(ConversionType type) {
            this.type = type;
            this.conversionClass = null;
        }

        public ConversionDefn(Class<? extends AbstractWriteConverter> conversionClass) {
            this.type = ConversionType.EXPLICIT;
            this.conversionClass = conversionClass;
        }
    }

    public static enum ConversionType {
        NONE,
        IMPLICIT,
        IMPLICIT_UNSAFE,
        EXPLICIT;

    }
}

