/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.convert;

import oadd.org.apache.drill.exec.vector.accessor.InvalidConversionError;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.convert.AbstractWriteConverter;
import oadd.org.joda.time.Instant;
import oadd.org.joda.time.format.DateTimeFormat;
import oadd.org.joda.time.format.DateTimeFormatter;
import oadd.org.joda.time.format.ISODateTimeFormat;

public class ConvertTimeStampToString
extends AbstractWriteConverter {
    private final DateTimeFormatter dateTimeFormatter;

    public ConvertTimeStampToString(ScalarWriter baseWriter) {
        super(baseWriter);
        String formatValue = baseWriter.schema().format();
        this.dateTimeFormatter = formatValue == null ? ISODateTimeFormat.dateTime() : DateTimeFormat.forPattern(formatValue);
    }

    @Override
    public void setTimestamp(Instant value) {
        if (value == null) {
            this.baseWriter.setNull();
        } else {
            try {
                this.baseWriter.setString(this.dateTimeFormatter.print(value));
            }
            catch (IllegalStateException e) {
                throw InvalidConversionError.writeError(this.schema(), value, e);
            }
        }
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setNull();
        } else {
            this.setTimestamp((Instant)value);
        }
    }
}

