/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.convert;

import java.util.Map;
import oadd.org.apache.drill.exec.vector.accessor.InvalidConversionError;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.convert.AbstractConvertFromString;
import oadd.org.joda.time.LocalDate;
import oadd.org.joda.time.format.DateTimeFormatter;

public class ConvertStringToDate
extends AbstractConvertFromString {
    private final DateTimeFormatter dateTimeFormatter;

    public ConvertStringToDate(ScalarWriter baseWriter, Map<String, String> properties) {
        super(baseWriter, properties);
        this.dateTimeFormatter = baseWriter.schema().dateTimeFormatter();
    }

    @Override
    public void setString(String value) {
        String prepared = (String)this.prepare.apply(value);
        if (prepared == null) {
            return;
        }
        try {
            this.baseWriter.setDate(LocalDate.parse(prepared, this.dateTimeFormatter));
        }
        catch (IllegalStateException e) {
            throw InvalidConversionError.writeError(this.schema(), value, e);
        }
    }
}

