/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.Arrays;
import java.util.Set;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.IntervalYearHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.IntervalYearVector;
import oadd.org.apache.drill.exec.vector.NullableVector;
import oadd.org.apache.drill.exec.vector.NullableVectorDefinitionSetter;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.NullableIntervalYearReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.joda.time.Period;
import org.apache.drill.shaded.guava.com.google.common.collect.ObjectArrays;

public final class NullableIntervalYearVector
extends BaseDataValueVector
implements FixedWidthVector,
NullableVector {
    private static final int DEFINED_VALUES_ARRAY_LEN = 1024;
    private static final byte[] DEFINED_VALUES_ARRAY = new byte[1024];
    private final FieldReader reader = new NullableIntervalYearReaderImpl(this);
    private final UInt1Vector bits = new UInt1Vector(bitsField, this.allocator);
    private final IntervalYearVector values = new IntervalYearVector(this.field, this.allocator);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public NullableIntervalYearVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.bits.getValueCapacity(), this.values.getValueCapacity());
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(false), this.values.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public void close() {
        this.bits.close();
        this.values.close();
        super.close();
    }

    @Override
    public void clear() {
        this.bits.clear();
        this.values.clear();
        super.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return this.values.getBufferSizeFor(valueCount) + this.bits.getBufferSizeFor(valueCount);
    }

    @Override
    public int getAllocatedSize() {
        return this.bits.getAllocatedSize() + this.values.getAllocatedSize();
    }

    @Override
    public DrillBuf getBuffer() {
        return this.values.getBuffer();
    }

    @Override
    public IntervalYearVector getValuesVector() {
        return this.values;
    }

    @Override
    public UInt1Vector getBitsVector() {
        return this.bits;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.bits.setInitialCapacity(numRecords);
        this.values.setInitialCapacity(numRecords);
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().addChild(this.bits.getMetadata()).addChild(this.values.getMetadata());
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            success = this.values.allocateNewSafe() && this.bits.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return success;
    }

    @Override
    public DrillBuf reallocRaw(int newAllocationSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        this.bits.collectLedgers(ledgers);
        this.values.collectLedgers(ledgers);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return this.bits.getPayloadByteCount(valueCount) + this.values.getPayloadByteCount(valueCount);
    }

    @Override
    public int getValueWidth() {
        return this.bits.getValueWidth() + 4;
    }

    @Override
    public void allocateNew(int valueCount) {
        try {
            this.values.allocateNew(valueCount);
            this.bits.allocateNew(valueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public void reset() {
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        super.reset();
    }

    @Override
    public void zeroVector() {
        this.bits.zeroVector();
        this.values.zeroVector();
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        this.clear();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        this.bits.load(bitsField, buffer);
        int capacity = buffer.capacity();
        int bitsLength = bitsField.getBufferLength();
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        this.values.load(valuesField, buffer.slice(bitsLength, capacity - bitsLength));
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableIntervalYearVector)to);
    }

    public void transferTo(NullableIntervalYearVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, NullableIntervalYearVector target) {
        this.bits.splitAndTransferTo(startIndex, length, target.bits);
        this.values.splitAndTransferTo(startIndex, length, target.values);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public IntervalYearVector convertToRequiredVector() {
        IntervalYearVector v = new IntervalYearVector(this.getField().getOtherNullableVersion(), this.allocator);
        if (v.data != null) {
            v.data.release(1);
        }
        v.data = this.values.data;
        v.data.retain(1);
        this.clear();
        return v;
    }

    public int getBitsValueCapacity() {
        return this.bits.getValueCapacity();
    }

    public void copyFrom(int fromIndex, int thisIndex, NullableIntervalYearVector from) {
        Accessor fromAccessor = from.getAccessor();
        if (!fromAccessor.isNull(fromIndex)) {
            this.mutator.set(thisIndex, fromAccessor.get(fromIndex));
        }
    }

    public void copyFromSafe(int fromIndex, int thisIndex, IntervalYearVector from) {
        this.values.copyFromSafe(fromIndex, thisIndex, from);
        this.bits.getMutator().setSafe(thisIndex, 1);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, NullableIntervalYearVector from) {
        this.bits.copyFromSafe(fromIndex, thisIndex, from.bits);
        this.values.copyFromSafe(fromIndex, thisIndex, from.values);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        if (from instanceof IntervalYearVector) {
            this.bits.getMutator().setSafe(toIndex, 1);
            this.values.copyFromSafe(fromIndex, toIndex, (IntervalYearVector)from);
            return;
        }
        NullableIntervalYearVector fromVector = (NullableIntervalYearVector)from;
        this.bits.copyFromSafe(fromIndex, toIndex, fromVector.bits);
        this.values.copyFromSafe(fromIndex, toIndex, fromVector.values);
    }

    @Override
    public void exchange(ValueVector other) {
        NullableIntervalYearVector target = (NullableIntervalYearVector)other;
        this.bits.exchange(target.bits);
        this.values.exchange(target.values);
        this.mutator.exchange(other.getMutator());
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        this.exchange(nullableVector);
        this.clear();
    }

    static {
        Arrays.fill(DEFINED_VALUES_ARRAY, (byte)1);
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator
    implements NullableVectorDefinitionSetter {
        private int setCount;

        private Mutator() {
        }

        public IntervalYearVector getVectorWithValues() {
            return NullableIntervalYearVector.this.values;
        }

        @Override
        public void setIndexDefined(int index) {
            NullableIntervalYearVector.this.bits.getMutator().set(index, 1);
        }

        @Override
        public void setIndexDefined(int index, int numValues) {
            int batchSz;
            for (int remaining = numValues; remaining > 0; remaining -= batchSz) {
                batchSz = Math.min(remaining, 1024);
                NullableIntervalYearVector.this.bits.getMutator().set(index + (numValues - remaining), DEFINED_VALUES_ARRAY, 0, batchSz);
            }
        }

        public void set(int index, int value) {
            ++this.setCount;
            IntervalYearVector.Mutator valuesMutator = NullableIntervalYearVector.this.values.getMutator();
            UInt1Vector.Mutator bitsMutator = NullableIntervalYearVector.this.bits.getMutator();
            bitsMutator.set(index, 1);
            valuesMutator.set(index, value);
        }

        public void setNull(int index) {
            NullableIntervalYearVector.this.bits.getMutator().setSafe(index, 0);
        }

        public void setSkipNull(int index, IntervalYearHolder holder) {
            NullableIntervalYearVector.this.values.getMutator().set(index, holder);
        }

        public void setSkipNull(int index, NullableIntervalYearHolder holder) {
            NullableIntervalYearVector.this.values.getMutator().set(index, holder);
        }

        public void set(int index, NullableIntervalYearHolder holder) {
            IntervalYearVector.Mutator valuesMutator = NullableIntervalYearVector.this.values.getMutator();
            NullableIntervalYearVector.this.bits.getMutator().set(index, holder.isSet);
            valuesMutator.set(index, holder);
        }

        public void set(int index, IntervalYearHolder holder) {
            IntervalYearVector.Mutator valuesMutator = NullableIntervalYearVector.this.values.getMutator();
            NullableIntervalYearVector.this.bits.getMutator().set(index, 1);
            valuesMutator.set(index, holder);
        }

        public boolean isSafe(int outIndex) {
            return outIndex < NullableIntervalYearVector.this.getValueCapacity();
        }

        public void set(int index, int isSet, int valueField) {
            IntervalYearVector.Mutator valuesMutator = NullableIntervalYearVector.this.values.getMutator();
            NullableIntervalYearVector.this.bits.getMutator().set(index, isSet);
            valuesMutator.set(index, valueField);
        }

        public void setSafe(int index, int isSet, int valueField) {
            NullableIntervalYearVector.this.bits.getMutator().setSafe(index, isSet);
            NullableIntervalYearVector.this.values.getMutator().setSafe(index, valueField);
            ++this.setCount;
        }

        public void setSafe(int index, NullableIntervalYearHolder value) {
            NullableIntervalYearVector.this.bits.getMutator().setSafe(index, value.isSet);
            NullableIntervalYearVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        public void setSafe(int index, IntervalYearHolder value) {
            NullableIntervalYearVector.this.bits.getMutator().setSafe(index, 1);
            NullableIntervalYearVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        public void setSafe(int index, int value) {
            NullableIntervalYearVector.this.bits.getMutator().setSafe(index, 1);
            NullableIntervalYearVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            NullableIntervalYearVector.this.values.getMutator().setValueCount(valueCount);
            NullableIntervalYearVector.this.bits.getMutator().setValueCount(valueCount);
        }

        @Override
        public void generateTestData(int valueCount) {
            NullableIntervalYearVector.this.bits.getMutator().generateTestDataAlt(valueCount);
            NullableIntervalYearVector.this.values.getMutator().generateTestData(valueCount);
            this.setValueCount(valueCount);
        }

        @Override
        public void reset() {
            this.setCount = 0;
        }

        @Override
        public void exchange(ValueVector.Mutator other) {
            Mutator target = (Mutator)other;
            int temp = this.setCount;
            this.setCount = target.setCount;
            target.setCount = temp;
        }

        public void fromNotNullable(IntervalYearVector srce) {
            NullableIntervalYearVector.this.clear();
            int valueCount = srce.getAccessor().getValueCount();
            BaseValueVector.fillBitsVector(NullableIntervalYearVector.this.getBitsVector(), valueCount);
            NullableIntervalYearVector.this.getValuesVector().exchange(srce);
            this.setValueCount(valueCount);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        final UInt1Vector.Accessor bAccessor;
        final IntervalYearVector.Accessor vAccessor;

        public Accessor() {
            this.bAccessor = NullableIntervalYearVector.this.bits.getAccessor();
            this.vAccessor = NullableIntervalYearVector.this.values.getAccessor();
        }

        public int get(int index) {
            if (this.isNull(index)) {
                throw new IllegalStateException("Can't get a null value");
            }
            return this.vAccessor.get(index);
        }

        @Override
        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        public void get(int index, NullableIntervalYearHolder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
        }

        @Override
        public Period getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        public StringBuilder getAsStringBuilder(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getAsStringBuilder(index);
        }

        @Override
        public int getValueCount() {
            return NullableIntervalYearVector.this.bits.getAccessor().getValueCount();
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        private final NullableIntervalYearVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new NullableIntervalYearVector(field, allocator);
        }

        public TransferImpl(NullableIntervalYearVector to) {
            this.to = to;
        }

        @Override
        public NullableIntervalYearVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableIntervalYearVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            NullableIntervalYearVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, NullableIntervalYearVector.this);
        }
    }
}

