/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user.security;

import java.lang.reflect.Constructor;
import java.util.Set;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.scanner.persistence.ScanResult;
import oadd.org.apache.drill.exec.exception.DrillbitStartupException;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticator;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticatorTemplate;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthenticatorFactory {
    private static final Logger logger = LoggerFactory.getLogger(UserAuthenticatorFactory.class);

    public static UserAuthenticator createAuthenticator(DrillConfig config, ScanResult scan) throws DrillbitStartupException {
        if (!config.hasPath("drill.exec.security.user.auth.impl")) {
            throw new DrillbitStartupException(String.format("BOOT option '%s' is missing in config.", "drill.exec.security.user.auth.impl"));
        }
        String authImplConfigured = config.getString("drill.exec.security.user.auth.impl");
        if (Strings.isNullOrEmpty(authImplConfigured)) {
            throw new DrillbitStartupException(String.format("Invalid value '%s' for BOOT option '%s'", authImplConfigured, "drill.exec.security.user.auth.impl"));
        }
        Set<Class<UserAuthenticator>> authImpls = scan.getImplementations(UserAuthenticator.class);
        logger.debug("Found UserAuthenticator implementations: {}", (Object)authImpls);
        for (Class clazz : authImpls) {
            UserAuthenticatorTemplate template = clazz.getAnnotation(UserAuthenticatorTemplate.class);
            if (template == null) {
                logger.warn("{} doesn't have {} annotation. Skipping.", (Object)clazz.getCanonicalName(), (Object)UserAuthenticatorTemplate.class);
                continue;
            }
            if (Strings.isNullOrEmpty(template.type())) {
                logger.warn("{} annotation doesn't have valid type field for UserAuthenticator implementation {}. Skipping..", (Object)UserAuthenticatorTemplate.class, (Object)clazz.getCanonicalName());
                continue;
            }
            if (!template.type().equalsIgnoreCase(authImplConfigured)) continue;
            Constructor<?> validConstructor = null;
            for (Constructor<?> c : clazz.getConstructors()) {
                if (c.getParameterTypes().length != 0) continue;
                validConstructor = c;
                break;
            }
            if (validConstructor == null) {
                logger.warn("Skipping UserAuthenticator implementation class '{}' since it doesn't implement a constructor [{}()]", (Object)clazz.getCanonicalName(), (Object)clazz.getName());
                continue;
            }
            try {
                UserAuthenticator authenticator = (UserAuthenticator)clazz.newInstance();
                authenticator.setup(config);
                return authenticator;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                throw new DrillbitStartupException(String.format("Failed to create and initialize the UserAuthenticator class '%s'", clazz.getCanonicalName()), e);
            }
        }
        String errMsg = String.format("Failed to find the implementation of '%s' for type '%s'", UserAuthenticator.class.getCanonicalName(), authImplConfigured);
        logger.error(errMsg);
        throw new DrillbitStartupException(errMsg);
    }
}

