/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import java.util.ArrayList;
import java.util.Map;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.MetadataUtils;
import oadd.org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;

public class SchemaPathUtils {
    private SchemaPathUtils() {
    }

    public static ColumnMetadata getColumnMetadata(SchemaPath schemaPath, TupleMetadata schema) {
        PathSegment.NameSegment colPath = schemaPath.getUnIndexed().getRootSegment();
        ColumnMetadata colMetadata = schema.metadata(colPath.getPath());
        while (!colPath.isLastPath() && colMetadata != null) {
            if (colMetadata.isDict()) {
                colMetadata = colMetadata.mapSchema().metadata(0).mapSchema().metadata(1);
                break;
            }
            if (!colMetadata.isMap()) {
                colMetadata = null;
                break;
            }
            colPath = (PathSegment.NameSegment)colPath.getChild();
            colMetadata = colMetadata.mapSchema().metadata(colPath.getPath());
        }
        return colMetadata;
    }

    public static void addColumnMetadata(TupleMetadata schema, SchemaPath schemaPath, TypeProtos.MajorType type, Map<SchemaPath, TypeProtos.MajorType> types) {
        ColumnMetadata colMetadata;
        PathSegment.NameSegment colPath = schemaPath.getUnIndexed().getRootSegment();
        ArrayList<String> names = new ArrayList<String>(types.size());
        while (!colPath.isLastPath()) {
            names.add(colPath.getPath());
            colMetadata = schema.metadata(colPath.getPath());
            TypeProtos.MajorType pathType = types.get(SchemaPath.getCompoundPath(names.toArray(new String[0])));
            if (colMetadata == null) {
                colMetadata = pathType != null && pathType.getMinorType() == TypeProtos.MinorType.DICT ? MetadataUtils.newDict(colPath.getPath(), null) : MetadataUtils.newMap(colPath.getPath(), null);
                schema.addColumn(colMetadata);
            }
            if (!colMetadata.isMap() && !colMetadata.isDict()) {
                throw new DrillRuntimeException(String.format("Expected map or dict, but was %s", colMetadata.majorType()));
            }
            schema = colMetadata.mapSchema();
            colPath = (PathSegment.NameSegment)colPath.getChild();
        }
        colMetadata = schema.metadata(colPath.getPath());
        if (colMetadata == null) {
            schema.addColumn(new PrimitiveColumnMetadata(MaterializedField.create(colPath.getPath(), type)));
        } else if (!colMetadata.majorType().equals(type)) {
            throw new DrillRuntimeException(String.format("Types mismatch: existing type: %s, new type: %s", colMetadata.majorType(), type));
        }
    }
}

