/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import oadd.org.apache.drill.common.types.TypeProtos;

public enum ProjectionType {
    UNPROJECTED,
    WILDCARD,
    UNSPECIFIED,
    SCALAR,
    TUPLE,
    ARRAY,
    TUPLE_ARRAY;


    public boolean isTuple() {
        return this == TUPLE || this == TUPLE_ARRAY;
    }

    public boolean isArray() {
        return this == ARRAY || this == TUPLE_ARRAY;
    }

    public boolean isMaybeScalar() {
        return this == UNSPECIFIED || this == SCALAR;
    }

    public static ProjectionType typeFor(TypeProtos.MajorType majorType) {
        if (majorType.getMinorType() == TypeProtos.MinorType.MAP) {
            if (majorType.getMode() == TypeProtos.DataMode.REPEATED) {
                return TUPLE_ARRAY;
            }
            return TUPLE;
        }
        if (majorType.getMode() == TypeProtos.DataMode.REPEATED) {
            return ARRAY;
        }
        return SCALAR;
    }

    public boolean isCompatible(ProjectionType other) {
        switch (other) {
            case UNPROJECTED: 
            case UNSPECIFIED: 
            case WILDCARD: {
                return true;
            }
        }
        switch (this) {
            case ARRAY: 
            case TUPLE_ARRAY: {
                return other == ARRAY || other == TUPLE_ARRAY;
            }
            case SCALAR: {
                return other == SCALAR;
            }
            case TUPLE: {
                return other == TUPLE;
            }
            case UNPROJECTED: 
            case UNSPECIFIED: 
            case WILDCARD: {
                return true;
            }
        }
        throw new IllegalStateException(this.toString());
    }
}

