/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.opt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import oadd.org.apache.calcite.rel.RelFieldCollation;
import oadd.org.apache.drill.common.JSONOptions;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.exceptions.ExecutionSetupException;
import oadd.org.apache.drill.common.logical.LogicalPlan;
import oadd.org.apache.drill.common.logical.PlanProperties;
import oadd.org.apache.drill.common.logical.StoragePluginConfig;
import oadd.org.apache.drill.common.logical.data.GroupingAggregate;
import oadd.org.apache.drill.common.logical.data.Join;
import oadd.org.apache.drill.common.logical.data.Limit;
import oadd.org.apache.drill.common.logical.data.LogicalOperator;
import oadd.org.apache.drill.common.logical.data.Order;
import oadd.org.apache.drill.common.logical.data.Scan;
import oadd.org.apache.drill.common.logical.data.SinkOperator;
import oadd.org.apache.drill.common.logical.data.Store;
import oadd.org.apache.drill.common.logical.data.Unnest;
import oadd.org.apache.drill.common.logical.data.Window;
import oadd.org.apache.drill.common.logical.data.visitors.AbstractLogicalVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.exception.OptimizerException;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.opt.Optimizer;
import oadd.org.apache.drill.exec.physical.PhysicalPlan;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.physical.config.Filter;
import oadd.org.apache.drill.exec.physical.config.MergeJoinPOP;
import oadd.org.apache.drill.exec.physical.config.Project;
import oadd.org.apache.drill.exec.physical.config.Screen;
import oadd.org.apache.drill.exec.physical.config.SelectionVectorRemover;
import oadd.org.apache.drill.exec.physical.config.Sort;
import oadd.org.apache.drill.exec.physical.config.StreamingAggregate;
import oadd.org.apache.drill.exec.physical.config.UnnestPOP;
import oadd.org.apache.drill.exec.physical.config.WindowPOP;
import oadd.org.apache.drill.exec.rpc.UserClientConnection;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.store.StoragePlugin;

public class BasicOptimizer
extends Optimizer {
    private final QueryContext queryContext;
    private final UserClientConnection userSession;

    public BasicOptimizer(QueryContext queryContext, UserClientConnection userSession) {
        this.queryContext = queryContext;
        this.userSession = userSession;
    }

    @Override
    public void init(DrillConfig config) {
    }

    @Override
    public PhysicalPlan optimize(Optimizer.OptimizationContext context, LogicalPlan plan) throws OptimizerException {
        Object obj = new Object();
        Collection<SinkOperator> roots = plan.getGraph().getRoots();
        ArrayList<PhysicalOperator> physOps = new ArrayList<PhysicalOperator>(roots.size());
        LogicalConverter converter = new LogicalConverter(plan);
        for (SinkOperator op : roots) {
            PhysicalOperator pop = op.accept(converter, obj);
            physOps.add(pop);
        }
        PlanProperties logicalProperties = plan.getProperties();
        PlanProperties props = PlanProperties.builder().type(PlanProperties.PlanType.APACHE_DRILL_PHYSICAL).version(logicalProperties.version).generator(logicalProperties.generator).options(new JSONOptions(context.getOptions().getOptionList())).build();
        return new PhysicalPlan(props, physOps);
    }

    private class LogicalConverter
    extends AbstractLogicalVisitor<PhysicalOperator, Object, OptimizerException> {
        private final LogicalPlan logicalPlan;

        LogicalConverter(LogicalPlan logicalPlan) {
            this.logicalPlan = logicalPlan;
        }

        @Override
        public PhysicalOperator visitGroupingAggregate(GroupingAggregate groupBy, Object value) throws OptimizerException {
            PhysicalOperator input = groupBy.getInput().accept(this, value);
            if (groupBy.getKeys().size() > 0) {
                List orderDefs = groupBy.getKeys().stream().map(e -> new Order.Ordering(RelFieldCollation.Direction.ASCENDING, e.getExpr(), RelFieldCollation.NullDirection.FIRST)).collect(Collectors.toList());
                input = new Sort(input, orderDefs, false);
            }
            return new StreamingAggregate(input, groupBy.getKeys(), groupBy.getExprs(), 1.0f);
        }

        @Override
        public PhysicalOperator visitWindow(Window window, Object value) throws OptimizerException {
            PhysicalOperator input = window.getInput().accept(this, value);
            ArrayList ods = new ArrayList();
            input = new Sort(input, ods, false);
            return new WindowPOP(input, window.getWithins(), window.getAggregations(), window.getOrderings(), false, null, null);
        }

        @Override
        public PhysicalOperator visitOrder(Order order, Object value) throws OptimizerException {
            PhysicalOperator input = order.getInput().accept(this, value);
            ArrayList<Order.Ordering> ods = new ArrayList<Order.Ordering>(order.getOrderings());
            return new SelectionVectorRemover((PhysicalOperator)new Sort(input, ods, false));
        }

        @Override
        public PhysicalOperator visitLimit(Limit limit, Object value) throws OptimizerException {
            PhysicalOperator input = limit.getInput().accept(this, value);
            return new SelectionVectorRemover((PhysicalOperator)new oadd.org.apache.drill.exec.physical.config.Limit(input, limit.getFirst(), limit.getLast()));
        }

        @Override
        public PhysicalOperator visitJoin(Join join, Object value) throws OptimizerException {
            PhysicalOperator leftOp = join.getLeft().accept(this, value);
            List leftOrderDefs = join.getConditions().stream().map(jc -> new Order.Ordering(RelFieldCollation.Direction.ASCENDING, jc.getLeft())).collect(Collectors.toList());
            leftOp = new Sort(leftOp, leftOrderDefs, false);
            leftOp = new SelectionVectorRemover(leftOp);
            PhysicalOperator rightOp = join.getRight().accept(this, value);
            List rightOrderDefs = join.getConditions().stream().map(jc -> new Order.Ordering(RelFieldCollation.Direction.ASCENDING, jc.getRight())).collect(Collectors.toList());
            rightOp = new Sort(rightOp, rightOrderDefs, false);
            rightOp = new SelectionVectorRemover(rightOp);
            MergeJoinPOP mjp = new MergeJoinPOP(leftOp, rightOp, join.getConditions(), join.getJoinType());
            return new SelectionVectorRemover((PhysicalOperator)mjp);
        }

        @Override
        public PhysicalOperator visitScan(Scan scan, Object obj) throws OptimizerException {
            StoragePluginConfig config = this.logicalPlan.getStorageEngineConfig(scan.getStorageEngine());
            if (config == null) {
                throw new OptimizerException(String.format("Logical plan referenced the storage engine config %s but the logical plan didn't have that available as a config.", scan.getStorageEngine()));
            }
            try {
                StoragePlugin storagePlugin = BasicOptimizer.this.queryContext.getStorage().getPlugin(config);
                String user = BasicOptimizer.this.userSession.getSession().getCredentials().getUserName();
                return storagePlugin.getPhysicalScan(user, scan.getSelection(), BasicOptimizer.this.userSession.getSession().getOptions());
            }
            catch (IOException | ExecutionSetupException e) {
                throw new OptimizerException("Failure while attempting to retrieve storage engine.", e);
            }
        }

        @Override
        public PhysicalOperator visitStore(Store store, Object obj) throws OptimizerException {
            LogicalOperator input = store.getInput();
            if (input == null) {
                throw new OptimizerException("Store node in logical plan does not have a child.");
            }
            return new Screen(store.getInput().accept(this, obj), BasicOptimizer.this.queryContext.getCurrentEndpoint());
        }

        @Override
        public PhysicalOperator visitProject(oadd.org.apache.drill.common.logical.data.Project project, Object obj) throws OptimizerException {
            return new Project(project.getSelections(), project.getInput().accept(this, obj));
        }

        @Override
        public PhysicalOperator visitFilter(oadd.org.apache.drill.common.logical.data.Filter filter, Object obj) throws OptimizerException {
            TypeProtos.MajorType.Builder b = TypeProtos.MajorType.getDefaultInstance().newBuilderForType();
            b.setMode(TypeProtos.DataMode.REQUIRED);
            b.setMinorType(TypeProtos.MinorType.BIGINT);
            PhysicalOperator child = filter.getInput().accept(this, obj);
            return new SelectionVectorRemover((PhysicalOperator)new Filter(child, filter.getExpr(), 1.0f));
        }

        @Override
        public PhysicalOperator visitUnnest(Unnest unnest, Object obj) {
            return new UnnestPOP(null, unnest.getColumn(), "$drill_implicit_field$");
        }
    }

    public static class BasicOptimizationContext
    implements Optimizer.OptimizationContext {
        private final OptionManager ops;

        public BasicOptimizationContext(QueryContext c) {
            this.ops = c.getOptions();
        }

        @Override
        public int getPriority() {
            return 1;
        }

        @Override
        public OptionManager getOptions() {
            return this.ops;
        }
    }
}

