/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.memory;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.util.AssertionUtil;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@VisibleForTesting
public class Accountant
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Accountant.class);
    public static final String ALLOW_LENIENT_ALLOCATION = "drill.memory.lenient.allocator";
    public static final int GRACE_MARGIN = 1;
    public static final int MAX_GRACE = 0x6400000;
    public static final boolean ALLOW_LENIENCY = System.getProperty("drill.memory.lenient.allocator") == null ? !AssertionUtil.isAssertionsEnabled() : Boolean.parseBoolean(System.getProperty("drill.memory.lenient.allocator"));
    private boolean lenient = false;
    protected final Accountant parent;
    protected final long reservation;
    private final AtomicLong peakAllocation = new AtomicLong();
    private final AtomicLong allocationLimit = new AtomicLong();
    private final AtomicLong locallyHeldMemory = new AtomicLong();

    public Accountant(Accountant parent, long reservation, long maxAllocation) {
        AllocationOutcome outcome;
        Preconditions.checkArgument(reservation >= 0L, "The initial reservation size must be non-negative.");
        Preconditions.checkArgument(maxAllocation >= 0L, "The maximum allocation limit must be non-negative.");
        Preconditions.checkArgument(reservation <= maxAllocation, "The initial reservation size must be <= the maximum allocation.");
        Preconditions.checkArgument(reservation == 0L || parent != null, "The root accountant can't reserve memory.");
        this.parent = parent;
        this.reservation = reservation;
        this.allocationLimit.set(maxAllocation);
        if (reservation != 0L && !(outcome = parent.allocateBytes(reservation)).isOk()) {
            throw new OutOfMemoryException(String.format("Failure trying to allocate initial reservation for Allocator. Attempted to allocate %d bytes and received an outcome of %s.", reservation, outcome.name()));
        }
    }

    public boolean setLenient() {
        this.lenient = ALLOW_LENIENCY;
        return this.lenient;
    }

    @VisibleForTesting
    public void forceLenient() {
        this.lenient = true;
    }

    AllocationOutcome allocateBytes(long size) {
        AllocationOutcome outcome = this.allocate(size, true, false);
        if (!outcome.isOk()) {
            this.releaseBytes(size);
        }
        return outcome;
    }

    private void updatePeak() {
        long previousPeak;
        long currentMemory = this.locallyHeldMemory.get();
        while (currentMemory > (previousPeak = this.peakAllocation.get()) && !this.peakAllocation.compareAndSet(previousPeak, currentMemory)) {
        }
    }

    boolean forceAllocate(long size) {
        AllocationOutcome outcome = this.allocate(size, true, true);
        return outcome.isOk();
    }

    private AllocationOutcome allocate(long size, boolean incomingUpdatePeak, boolean forceAllocation) {
        AllocationOutcome finalOutcome;
        boolean beyondLimit;
        long newLocal = this.locallyHeldMemory.addAndGet(size);
        long beyondReservation = newLocal - this.reservation;
        boolean bl = beyondLimit = newLocal > this.allocationLimit.get();
        if (beyondLimit && this.lenient) {
            long grace = Math.min(0x6400000L, this.allocationLimit.get() * 1L);
            long graceLimit = this.allocationLimit.get() + grace;
            boolean bl2 = beyondLimit = newLocal > graceLimit;
            if (!beyondLimit) {
                logger.warn("Excess allocation of {} bytes beyond limit of {}, within grace of {}, new total allocation: {}", size, this.allocationLimit.get(), grace, newLocal);
            }
        }
        boolean updatePeak = forceAllocation || incomingUpdatePeak && !beyondLimit;
        AllocationOutcome parentOutcome = AllocationOutcome.SUCCESS;
        if (beyondReservation > 0L && this.parent != null) {
            long parentRequest = Math.min(beyondReservation, size);
            parentOutcome = this.parent.allocate(parentRequest, updatePeak, forceAllocation);
        }
        AllocationOutcome allocationOutcome = beyondLimit ? AllocationOutcome.FAILED_LOCAL : (finalOutcome = parentOutcome.ok ? AllocationOutcome.SUCCESS : AllocationOutcome.FAILED_PARENT);
        if (updatePeak) {
            this.updatePeak();
        }
        return finalOutcome;
    }

    public void releaseBytes(long size) {
        long newSize = this.locallyHeldMemory.addAndGet(-size);
        Preconditions.checkArgument(newSize >= 0L, "Accounted size went negative.");
        long originalSize = newSize + size;
        if (originalSize > this.reservation && this.parent != null) {
            long possibleAmountToReleaseToParent = originalSize - this.reservation;
            long actualToReleaseToParent = Math.min(size, possibleAmountToReleaseToParent);
            this.parent.releaseBytes(actualToReleaseToParent);
        }
    }

    public void setLimit(long newLimit) {
        this.allocationLimit.set(newLimit);
    }

    public boolean isOverLimit() {
        return this.getAllocatedMemory() > this.getLimit() || this.parent != null && this.parent.isOverLimit();
    }

    @Override
    public void close() {
        if (this.parent != null) {
            this.parent.releaseBytes(this.reservation);
        }
    }

    public long getLimit() {
        return this.allocationLimit.get();
    }

    public long getAllocatedMemory() {
        return this.locallyHeldMemory.get();
    }

    public long getPeakMemoryAllocation() {
        return this.peakAllocation.get();
    }

    public static enum AllocationOutcome {
        SUCCESS(true),
        FORCED_SUCESS(true),
        FAILED_LOCAL(false),
        FAILED_PARENT(false);

        private final boolean ok;

        private AllocationOutcome(boolean ok) {
            this.ok = ok;
        }

        public boolean isOk() {
            return this.ok;
        }
    }
}

