/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JLabel;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.calcite.util.Pair;
import oadd.org.apache.drill.common.expression.AnyValueExpression;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.CastExpression;
import oadd.org.apache.drill.common.expression.ConvertExpression;
import oadd.org.apache.drill.common.expression.ExpressionStringBuilder;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.IfExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.NullExpression;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedNullConstant;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.compile.sig.ConstantExpressionIdentifier;
import oadd.org.apache.drill.exec.compile.sig.GeneratorMapping;
import oadd.org.apache.drill.exec.compile.sig.MappingSet;
import oadd.org.apache.drill.exec.expr.BatchReference;
import oadd.org.apache.drill.exec.expr.ClassGenerator;
import oadd.org.apache.drill.exec.expr.DirectExpression;
import oadd.org.apache.drill.exec.expr.EqualityVisitor;
import oadd.org.apache.drill.exec.expr.GetSetVectorHelper;
import oadd.org.apache.drill.exec.expr.HashVisitor;
import oadd.org.apache.drill.exec.expr.HoldingContainerExpression;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import oadd.org.apache.drill.exec.expr.ValueVectorReadExpression;
import oadd.org.apache.drill.exec.expr.ValueVectorWriteExpression;
import oadd.org.apache.drill.exec.expr.fn.AbstractFuncHolder;
import oadd.org.apache.drill.exec.expr.fn.impl.DateUtility;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;
import oadd.org.apache.drill.exec.physical.impl.filter.ReturnValueExpression;
import oadd.org.apache.drill.exec.util.Text;
import oadd.org.apache.drill.exec.vector.ValueHolderHelper;
import oadd.org.apache.drill.exec.vector.complex.impl.NullReader;
import oadd.org.apache.drill.exec.vector.complex.impl.SingleDictReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.shaded.guava.com.google.common.base.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationVisitor {
    static final Logger logger = LoggerFactory.getLogger(EvaluationVisitor.class);
    Map<ExpressionHolder, ClassGenerator.HoldingContainer> previousExpressions = new HashMap<ExpressionHolder, ClassGenerator.HoldingContainer>();
    Stack<Map<ExpressionHolder, ClassGenerator.HoldingContainer>> mapStack = new Stack();

    public ClassGenerator.HoldingContainer addExpr(LogicalExpression e, ClassGenerator<?> generator) {
        Set constantBoundaries = generator.getMappingSet().hasEmbeddedConstant() ? Collections.emptySet() : ConstantExpressionIdentifier.getConstantExpressionSet((LogicalExpression)e);
        return (ClassGenerator.HoldingContainer)e.accept(new CSEFilter(constantBoundaries), generator);
    }

    void newScope() {
        this.mapStack.push(this.previousExpressions);
        this.previousExpressions = new HashMap<ExpressionHolder, ClassGenerator.HoldingContainer>(this.previousExpressions);
    }

    void leaveScope() {
        this.previousExpressions.clear();
        this.previousExpressions = this.mapStack.pop();
    }

    private ClassGenerator.HoldingContainer getPrevious(LogicalExpression expression, MappingSet mappingSet) {
        ClassGenerator.HoldingContainer previous = this.previousExpressions.get(new ExpressionHolder(expression, mappingSet));
        if (previous != null) {
            logger.debug("Found previously evaluated expression: {}", (Object)ExpressionStringBuilder.toString(expression));
        }
        return previous;
    }

    private void put(LogicalExpression expression, ClassGenerator.HoldingContainer hc, MappingSet mappingSet) {
        this.previousExpressions.put(new ExpressionHolder(expression, mappingSet), hc);
    }

    private class ConstantFilter
    extends EvalVisitor {
        private Set<LogicalExpression> constantBoundaries;

        public ConstantFilter(Set<LogicalExpression> constantBoundaries) {
            this.constantBoundaries = constantBoundaries;
        }

        @Override
        public ClassGenerator.HoldingContainer visitFunctionCall(FunctionCall e, ClassGenerator<?> generator) throws RuntimeException {
            throw new UnsupportedOperationException("FunctionCall is not expected here. It should have been converted to FunctionHolderExpression in materialization");
        }

        @Override
        public ClassGenerator.HoldingContainer visitFunctionHolderExpression(FunctionHolderExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitFunctionHolderExpression(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitFunctionHolderExpression(e, generator).setConstant(true);
            }
            return super.visitFunctionHolderExpression(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitBooleanOperator(BooleanOperator e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitBooleanOperator(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitBooleanOperator(e, generator).setConstant(true);
            }
            return super.visitBooleanOperator(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitIfExpression(IfExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitIfExpression(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitIfExpression(e, generator).setConstant(true);
            }
            return super.visitIfExpression(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitSchemaPath(SchemaPath e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitSchemaPath(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitSchemaPath(e, generator).setConstant(true);
            }
            return super.visitSchemaPath(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitLongConstant(ValueExpressions.LongExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitLongConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitLongConstant(e, generator).setConstant(true);
            }
            return super.visitLongConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal9Constant(ValueExpressions.Decimal9Expression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitDecimal9Constant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitDecimal9Constant(e, generator).setConstant(true);
            }
            return super.visitDecimal9Constant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal18Constant(ValueExpressions.Decimal18Expression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitDecimal18Constant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitDecimal18Constant(e, generator).setConstant(true);
            }
            return super.visitDecimal18Constant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal28Constant(ValueExpressions.Decimal28Expression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitDecimal28Constant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitDecimal28Constant(e, generator).setConstant(true);
            }
            return super.visitDecimal28Constant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal38Constant(ValueExpressions.Decimal38Expression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitDecimal38Constant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitDecimal38Constant(e, generator).setConstant(true);
            }
            return super.visitDecimal38Constant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitVarDecimalConstant(ValueExpressions.VarDecimalExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitVarDecimalConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitVarDecimalConstant(e, generator).setConstant(true);
            }
            return super.visitVarDecimalConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntConstant(ValueExpressions.IntExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitIntConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitIntConstant(e, generator).setConstant(true);
            }
            return super.visitIntConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDateConstant(ValueExpressions.DateExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitDateConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitDateConstant(e, generator).setConstant(true);
            }
            return super.visitDateConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitTimeConstant(ValueExpressions.TimeExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitTimeConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitTimeConstant(e, generator).setConstant(true);
            }
            return super.visitTimeConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntervalYearConstant(ValueExpressions.IntervalYearExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitIntervalYearConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitIntervalYearConstant(e, generator).setConstant(true);
            }
            return super.visitIntervalYearConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitTimeStampConstant(ValueExpressions.TimeStampExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitTimeStampConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitTimeStampConstant(e, generator).setConstant(true);
            }
            return super.visitTimeStampConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitFloatConstant(ValueExpressions.FloatExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitFloatConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitFloatConstant(e, generator).setConstant(true);
            }
            return super.visitFloatConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitDoubleConstant(ValueExpressions.DoubleExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitDoubleConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitDoubleConstant(e, generator).setConstant(true);
            }
            return super.visitDoubleConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitBooleanConstant(ValueExpressions.BooleanExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitBooleanConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitBooleanConstant(e, generator).setConstant(true);
            }
            return super.visitBooleanConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitUnknown(LogicalExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitUnknown(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitUnknown(e, generator).setConstant(true);
            }
            return super.visitUnknown(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitQuotedStringConstant(ValueExpressions.QuotedString e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitQuotedStringConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitQuotedStringConstant(e, generator).setConstant(true);
            }
            return super.visitQuotedStringConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntervalDayConstant(ValueExpressions.IntervalDayExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (this.constantBoundaries.contains(e)) {
                generator.getMappingSet().enterConstant();
                ClassGenerator.HoldingContainer c = super.visitIntervalDayConstant(e, generator);
                return this.renderConstantExpression(generator, c);
            }
            if (generator.getMappingSet().isWithinConstant()) {
                return super.visitIntervalDayConstant(e, generator).setConstant(true);
            }
            return super.visitIntervalDayConstant(e, generator);
        }

        private ClassGenerator.HoldingContainer renderConstantExpression(ClassGenerator<?> generator, ClassGenerator.HoldingContainer input) {
            JVar fieldValue = generator.declareClassField("constant", generator.getHolderType(input.getMajorType()));
            generator.getEvalBlock().assign((JAssignmentTarget)fieldValue, (JExpression)JExpr._new((JType)generator.getHolderType(input.getMajorType())));
            List<String> holderFields = ValueHolderHelper.getHolderParams(input.getMajorType());
            for (String holderField : holderFields) {
                generator.getEvalBlock().assign((JAssignmentTarget)fieldValue.ref(holderField), (JExpression)input.getHolder().ref(holderField));
            }
            generator.getMappingSet().exitConstant();
            return new ClassGenerator.HoldingContainer(input.getMajorType(), fieldValue, fieldValue.ref("value"), fieldValue.ref("isSet")).setConstant(true);
        }
    }

    private class CSEFilter
    extends ConstantFilter {
        public CSEFilter(Set<LogicalExpression> constantBoundaries) {
            super(constantBoundaries);
        }

        @Override
        public ClassGenerator.HoldingContainer visitFunctionCall(FunctionCall call, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(call, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitFunctionCall(call, generator);
                EvaluationVisitor.this.put(call, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitFunctionHolderExpression(FunctionHolderExpression holder, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(holder, generator.getMappingSet());
            if (hc == null || holder.isRandom()) {
                hc = super.visitFunctionHolderExpression(holder, generator);
                EvaluationVisitor.this.put(holder, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitIfExpression(IfExpression ifExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(ifExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitIfExpression(ifExpr, generator);
                EvaluationVisitor.this.put(ifExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitBooleanOperator(BooleanOperator call, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(call, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitBooleanOperator(call, generator);
                EvaluationVisitor.this.put(call, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitSchemaPath(SchemaPath path, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(path, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitSchemaPath(path, generator);
                EvaluationVisitor.this.put(path, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntConstant(ValueExpressions.IntExpression intExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(intExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitIntConstant(intExpr, generator);
                EvaluationVisitor.this.put(intExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitFloatConstant(ValueExpressions.FloatExpression fExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(fExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitFloatConstant(fExpr, generator);
                EvaluationVisitor.this.put(fExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitLongConstant(ValueExpressions.LongExpression longExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(longExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitLongConstant(longExpr, generator);
                EvaluationVisitor.this.put(longExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDateConstant(ValueExpressions.DateExpression dateExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(dateExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitDateConstant(dateExpr, generator);
                EvaluationVisitor.this.put(dateExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitTimeConstant(ValueExpressions.TimeExpression timeExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(timeExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitTimeConstant(timeExpr, generator);
                EvaluationVisitor.this.put(timeExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitTimeStampConstant(ValueExpressions.TimeStampExpression timeStampExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(timeStampExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitTimeStampConstant(timeStampExpr, generator);
                EvaluationVisitor.this.put(timeStampExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntervalYearConstant(ValueExpressions.IntervalYearExpression intervalYearExpression, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(intervalYearExpression, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitIntervalYearConstant(intervalYearExpression, generator);
                EvaluationVisitor.this.put(intervalYearExpression, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntervalDayConstant(ValueExpressions.IntervalDayExpression intervalDayExpression, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(intervalDayExpression, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitIntervalDayConstant(intervalDayExpression, generator);
                EvaluationVisitor.this.put(intervalDayExpression, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal9Constant(ValueExpressions.Decimal9Expression decExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(decExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitDecimal9Constant(decExpr, generator);
                EvaluationVisitor.this.put(decExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal18Constant(ValueExpressions.Decimal18Expression decExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(decExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitDecimal18Constant(decExpr, generator);
                EvaluationVisitor.this.put(decExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal28Constant(ValueExpressions.Decimal28Expression decExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(decExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitDecimal28Constant(decExpr, generator);
                EvaluationVisitor.this.put(decExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal38Constant(ValueExpressions.Decimal38Expression decExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(decExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitDecimal38Constant(decExpr, generator);
                EvaluationVisitor.this.put(decExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitVarDecimalConstant(ValueExpressions.VarDecimalExpression decExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(decExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitVarDecimalConstant(decExpr, generator);
                EvaluationVisitor.this.put(decExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(dExpr, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitDoubleConstant(dExpr, generator);
                EvaluationVisitor.this.put(dExpr, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitBooleanConstant(ValueExpressions.BooleanExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(e, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitBooleanConstant(e, generator);
                EvaluationVisitor.this.put(e, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitQuotedStringConstant(ValueExpressions.QuotedString e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(e, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitQuotedStringConstant(e, generator);
                EvaluationVisitor.this.put(e, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitNullConstant(TypedNullConstant e, ClassGenerator<?> generator) throws RuntimeException {
            return (ClassGenerator.HoldingContainer)super.visitNullConstant(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitNullExpression(NullExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(e, generator.getMappingSet());
            if (hc == null) {
                hc = (ClassGenerator.HoldingContainer)super.visitNullExpression(e, generator);
                EvaluationVisitor.this.put(e, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitUnknown(LogicalExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (e instanceof ValueVectorReadExpression) {
                ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(e, generator.getMappingSet());
                if (hc == null) {
                    hc = super.visitUnknown(e, generator);
                    EvaluationVisitor.this.put(e, hc, generator.getMappingSet());
                }
                return hc;
            }
            return super.visitUnknown(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitCastExpression(CastExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(e, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitCastExpression(e, generator);
                EvaluationVisitor.this.put(e, hc, generator.getMappingSet());
            }
            return hc;
        }

        @Override
        public ClassGenerator.HoldingContainer visitConvertExpression(ConvertExpression e, ClassGenerator<?> generator) throws RuntimeException {
            ClassGenerator.HoldingContainer hc = EvaluationVisitor.this.getPrevious(e, generator.getMappingSet());
            if (hc == null) {
                hc = super.visitConvertExpression(e, generator);
                EvaluationVisitor.this.put(e, hc, generator.getMappingSet());
            }
            return hc;
        }
    }

    private class EvalVisitor
    extends AbstractExprVisitor<ClassGenerator.HoldingContainer, ClassGenerator<?>, RuntimeException> {
        private EvalVisitor() {
        }

        @Override
        public ClassGenerator.HoldingContainer visitFunctionCall(FunctionCall call, ClassGenerator<?> generator) throws RuntimeException {
            throw new UnsupportedOperationException("FunctionCall is not expected here. It should have been converted to FunctionHolderExpression in materialization");
        }

        @Override
        public ClassGenerator.HoldingContainer visitBooleanOperator(BooleanOperator op, ClassGenerator<?> generator) throws RuntimeException {
            if (op.getName().equals("booleanAnd")) {
                return this.visitBooleanAnd(op, generator);
            }
            if (op.getName().equals("booleanOr")) {
                return this.visitBooleanOr(op, generator);
            }
            throw new UnsupportedOperationException("BooleanOperator can only be booleanAnd, booleanOr. You are using " + op.getName());
        }

        @Override
        public ClassGenerator.HoldingContainer visitFunctionHolderExpression(FunctionHolderExpression holderExpr, ClassGenerator<?> generator) throws RuntimeException {
            AbstractFuncHolder holder = (AbstractFuncHolder)holderExpr.getHolder();
            JVar[] workspaceVars = holder.renderStart(generator, null, holderExpr.getFieldReference());
            if (holder.isNested()) {
                generator.getMappingSet().enterChild();
            }
            ClassGenerator.HoldingContainer[] args = new ClassGenerator.HoldingContainer[holderExpr.args.size()];
            for (int i = 0; i < holderExpr.args.size(); ++i) {
                args[i] = (ClassGenerator.HoldingContainer)((LogicalExpression)holderExpr.args.get(i)).accept(this, generator);
            }
            holder.renderMiddle(generator, args, workspaceVars);
            if (holder.isNested()) {
                generator.getMappingSet().exitChild();
            }
            return holder.renderEnd(generator, args, workspaceVars, holderExpr.getFieldReference());
        }

        @Override
        public ClassGenerator.HoldingContainer visitIfExpression(IfExpression ifExpr, ClassGenerator<?> generator) throws RuntimeException {
            JBlock local = generator.getEvalBlock();
            ClassGenerator.HoldingContainer output = generator.declare(ifExpr.getMajorType());
            JBlock conditionalBlock = new JBlock(false, false);
            IfExpression.IfCondition c = ifExpr.ifCondition;
            ClassGenerator.HoldingContainer holdingContainer = (ClassGenerator.HoldingContainer)c.condition.accept(this, generator);
            JConditional jc = holdingContainer.isOptional() ? conditionalBlock._if(holdingContainer.getIsSet().eq(JExpr.lit((int)1)).cand(holdingContainer.getValue().eq(JExpr.lit((int)1)))) : conditionalBlock._if(holdingContainer.getValue().eq(JExpr.lit((int)1)));
            generator.nestEvalBlock(jc._then());
            ClassGenerator.HoldingContainer thenExpr = (ClassGenerator.HoldingContainer)c.expression.accept(this, generator);
            generator.unNestEvalBlock();
            List<String> holderFields = ValueHolderHelper.getHolderParams(output.getMajorType());
            if (thenExpr.isOptional()) {
                JConditional newCond = jc._then()._if(thenExpr.getIsSet().ne(JExpr.lit((int)0)));
                JBlock b = newCond._then();
                for (String holderField : holderFields) {
                    b.assign((JAssignmentTarget)output.f(holderField), (JExpression)thenExpr.f(holderField));
                }
            } else {
                for (String holderField : holderFields) {
                    jc._then().assign((JAssignmentTarget)output.f(holderField), (JExpression)thenExpr.f(holderField));
                }
            }
            generator.nestEvalBlock(jc._else());
            ClassGenerator.HoldingContainer elseExpr = (ClassGenerator.HoldingContainer)ifExpr.elseExpression.accept(this, generator);
            generator.unNestEvalBlock();
            if (elseExpr.isOptional()) {
                JConditional newCond = jc._else()._if(elseExpr.getIsSet().ne(JExpr.lit((int)0)));
                JBlock b = newCond._then();
                for (String holderField : holderFields) {
                    b.assign((JAssignmentTarget)output.f(holderField), (JExpression)elseExpr.f(holderField));
                }
            } else {
                for (String holderField : holderFields) {
                    jc._else().assign((JAssignmentTarget)output.f(holderField), (JExpression)elseExpr.f(holderField));
                }
            }
            local.add((JStatement)conditionalBlock);
            return output;
        }

        @Override
        public ClassGenerator.HoldingContainer visitSchemaPath(SchemaPath path, ClassGenerator<?> generator) throws RuntimeException {
            throw new UnsupportedOperationException("All schema paths should have been replaced with ValueVectorExpressions.");
        }

        private ClassGenerator.HoldingContainer getHoldingContainer(ClassGenerator<?> generator, TypeProtos.MajorType majorType, Function<DrillBuf, ? extends ValueHolder> function) {
            JType holderType = generator.getHolderType(majorType);
            Pair<Integer, JVar> depthVar = generator.declareClassConstField("const", holderType, function);
            JFieldRef outputSet = null;
            JVar var = (JVar)depthVar.getValue();
            if (majorType.getMode() == TypeProtos.DataMode.OPTIONAL) {
                outputSet = var.ref("isSet");
            }
            return new ClassGenerator.HoldingContainer(majorType, var, var.ref("value"), outputSet);
        }

        @Override
        public ClassGenerator.HoldingContainer visitLongConstant(ValueExpressions.LongExpression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getBigIntHolder(e.getLong()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntConstant(ValueExpressions.IntExpression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getIntHolder(e.getInt()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitDateConstant(ValueExpressions.DateExpression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getDateHolder(e.getDate()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitTimeConstant(ValueExpressions.TimeExpression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getTimeHolder(e.getTime()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntervalYearConstant(ValueExpressions.IntervalYearExpression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getIntervalYearHolder(e.getIntervalYear()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitTimeStampConstant(ValueExpressions.TimeStampExpression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getTimeStampHolder(e.getTimeStamp()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitFloatConstant(ValueExpressions.FloatExpression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getFloat4Holder(e.getFloat()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitDoubleConstant(ValueExpressions.DoubleExpression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getFloat8Holder(e.getDouble()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitBooleanConstant(ValueExpressions.BooleanExpression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getBitHolder(e.getBoolean() ? 1 : 0));
        }

        @Override
        public ClassGenerator.HoldingContainer visitUnknown(LogicalExpression e, ClassGenerator<?> generator) throws RuntimeException {
            if (e instanceof ValueVectorReadExpression) {
                return this.visitValueVectorReadExpression((ValueVectorReadExpression)e, generator);
            }
            if (e instanceof ValueVectorWriteExpression) {
                return this.visitValueVectorWriteExpression((ValueVectorWriteExpression)e, generator);
            }
            if (e instanceof ReturnValueExpression) {
                return this.visitReturnValueExpression((ReturnValueExpression)e, generator);
            }
            if (e instanceof HoldingContainerExpression) {
                return ((HoldingContainerExpression)e).getContainer();
            }
            if (e instanceof NullExpression) {
                return generator.declare(e.getMajorType());
            }
            if (e instanceof TypedNullConstant) {
                return generator.declare(e.getMajorType());
            }
            return (ClassGenerator.HoldingContainer)super.visitUnknown(e, generator);
        }

        @Override
        public ClassGenerator.HoldingContainer visitParameter(ValueExpressions.ParameterExpression e, ClassGenerator<?> generator) {
            ClassGenerator.HoldingContainer out = generator.declare(e.getMajorType(), e.getName(), true);
            generator.getEvalBlock().assign((JAssignmentTarget)out.getValue(), (JExpression)JExpr.ref((String)e.getName()));
            return out;
        }

        private ClassGenerator.HoldingContainer visitValueVectorWriteExpression(ValueVectorWriteExpression e, ClassGenerator<?> generator) {
            LogicalExpression child = e.getChild();
            ClassGenerator.HoldingContainer inputContainer = (ClassGenerator.HoldingContainer)child.accept(this, generator);
            JBlock block = generator.getEvalBlock();
            DirectExpression outIndex = generator.getMappingSet().getValueWriteIndex();
            JVar vv = generator.declareVectorValueSetupAndMember(generator.getMappingSet().getOutgoing(), e.getFieldId());
            if (inputContainer.isReader()) {
                JType writerImpl = generator.getModel()._ref(TypeHelper.getWriterImpl(inputContainer.getMinorType(), inputContainer.getMajorType().getMode()));
                JType writerIFace = generator.getModel()._ref(TypeHelper.getWriterInterface(inputContainer.getMinorType(), inputContainer.getMajorType().getMode()));
                JVar writer = generator.declareClassField("writer", writerIFace);
                generator.getSetupBlock().assign((JAssignmentTarget)writer, (JExpression)JExpr._new((JType)writerImpl).arg((JExpression)vv).arg(JExpr._null()));
                generator.getEvalBlock().add((JStatement)writer.invoke("setPosition").arg((JExpression)outIndex));
                String copyMethod = inputContainer.isSingularRepeated() ? "copyAsValueSingle" : "copyAsValue";
                generator.getEvalBlock().add((JStatement)inputContainer.getHolder().invoke(copyMethod).arg((JExpression)writer));
                if (e.isSafe()) {
                    ClassGenerator.HoldingContainer outputContainer = generator.declare(Types.REQUIRED_BIT);
                    generator.getEvalBlock().assign((JAssignmentTarget)outputContainer.getValue(), JExpr.lit((int)1));
                    return outputContainer;
                }
            } else {
                JInvocation setMeth = GetSetVectorHelper.write(e.getChild().getMajorType(), vv, inputContainer, (JExpression)outIndex, e.isSafe() ? "setSafe" : "set");
                if (inputContainer.isOptional()) {
                    JConditional jc = block._if(inputContainer.getIsSet().eq(JExpr.lit((int)0)).not());
                    block = jc._then();
                }
                block.add((JStatement)setMeth);
            }
            return null;
        }

        private ClassGenerator.HoldingContainer visitValueVectorReadExpression(ValueVectorReadExpression e, ClassGenerator<?> generator) throws RuntimeException {
            DirectExpression recordIndex;
            DirectExpression batchIndex;
            DirectExpression batchName;
            BatchReference batchRef = e.getBatchRef();
            if (batchRef != null) {
                batchName = DirectExpression.direct(batchRef.getBatchName());
                batchIndex = DirectExpression.direct(batchRef.getBatchIndex());
                recordIndex = DirectExpression.direct(batchRef.getRecordIndex());
            } else {
                batchName = generator.getMappingSet().getIncoming();
                recordIndex = batchIndex = generator.getMappingSet().getValueReadIndex();
            }
            JVar vv1 = generator.declareVectorValueSetupAndMember(batchName, e.getFieldId());
            JExpression componentVariable = batchIndex.shrz(JExpr.lit((int)16));
            if (e.isSuperReader()) {
                vv1 = vv1.component(componentVariable);
                recordIndex = recordIndex.band(JExpr.lit((int)65535));
            }
            ClassGenerator.HoldingContainer out = generator.declare(e.getMajorType());
            boolean hasReadPath = e.hasReadPath();
            boolean complex = Types.isComplex(e.getMajorType());
            boolean repeated = Types.isRepeated(e.getMajorType());
            boolean listVector = e.getTypedFieldId().isListVector();
            if (!hasReadPath && !complex) {
                JBlock eval = new JBlock();
                if (repeated) {
                    JInvocation expr = vv1.invoke("getReader");
                    eval.add((JStatement)expr.invoke("reset"));
                    eval.add((JStatement)expr.invoke("setPosition").arg((JExpression)recordIndex));
                }
                GetSetVectorHelper.read(e.getMajorType(), (JExpression)vv1, eval, out, generator.getModel(), (JExpression)recordIndex);
                generator.getEvalBlock().add((JStatement)eval);
            } else {
                JInvocation expr = vv1.invoke("getReader");
                PathSegment seg = e.getReadPath();
                JVar isNull = null;
                boolean isNullReaderLikely = this.isNullReaderLikely(seg, complex || repeated || listVector);
                if (isNullReaderLikely) {
                    isNull = generator.getEvalBlock().decl((JType)generator.getModel().INT, generator.getNextVar("isNull"), JExpr.lit((int)0));
                }
                JLabel label = generator.getEvalBlock().label("complex");
                JBlock eval = generator.getEvalBlock().block();
                eval.add((JStatement)expr.invoke("reset"));
                eval.add((JStatement)expr.invoke("setPosition").arg((JExpression)recordIndex));
                int listNum = 0;
                JVar valueIndex = eval.decl((JType)generator.getModel().INT, "valueIndex", JExpr.lit((int)-2));
                int depth = 0;
                while (seg != null) {
                    if (seg.isArray()) {
                        if (seg.isLastPath() && !complex && !repeated && !listVector) break;
                        if (e.getFieldId().isDict(depth)) {
                            expr = this.getDictReaderReadByKeyExpression(generator, eval, (JExpression)expr, seg, valueIndex, isNull);
                            seg = seg.getChild();
                            ++depth;
                            continue;
                        }
                        JVar list = generator.declareClassField("list", generator.getModel()._ref(FieldReader.class));
                        eval.assign((JAssignmentTarget)list, (JExpression)expr);
                        JVar desiredIndex = eval.decl((JType)generator.getModel().INT, "desiredIndex" + listNum, JExpr.lit((int)seg.getArraySegment().getIndex()));
                        JVar currentIndex = eval.decl((JType)generator.getModel().INT, "currentIndex" + listNum, JExpr.lit((int)-1));
                        eval._while(currentIndex.lt((JExpression)desiredIndex).cand((JExpression)list.invoke("next"))).body().assign((JAssignmentTarget)currentIndex, currentIndex.plus(JExpr.lit((int)1)));
                        JBlock ifNoVal = eval._if(desiredIndex.ne((JExpression)currentIndex))._then().block();
                        if (out.isOptional()) {
                            ifNoVal.assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)0));
                        }
                        ifNoVal.assign((JAssignmentTarget)isNull, JExpr.lit((int)1));
                        ifNoVal._break(label);
                        expr = list.invoke("reader");
                        ++listNum;
                    } else {
                        if (e.getFieldId().isDict(depth)) {
                            TypeProtos.MajorType finalType = e.getFieldId().getFinalType();
                            if (seg.getChild() == null && !Types.isComplex(finalType) && !Types.isRepeated(finalType)) {
                                eval.add((JStatement)expr.invoke("read").arg(this.getKeyExpression(seg, generator)).arg((JExpression)out.getHolder()));
                                return out;
                            }
                            expr = this.getDictReaderReadByKeyExpression(generator, eval, (JExpression)expr, seg, valueIndex, isNull);
                            seg = seg.getChild();
                            ++depth;
                            continue;
                        }
                        JExpression fieldName = JExpr.lit((String)seg.getNameSegment().getPath());
                        expr = expr.invoke("reader").arg(fieldName);
                    }
                    seg = seg.getChild();
                    ++depth;
                }
                if (complex || repeated) {
                    if (e.getFieldId().isDict(depth)) {
                        JVar dictReader = generator.declareClassField("dictReader", generator.getModel()._ref(FieldReader.class));
                        eval.assign((JAssignmentTarget)dictReader, (JExpression)expr);
                        return new ClassGenerator.HoldingContainer(e.getMajorType(), dictReader, null, null, false, true);
                    }
                    JVar complexReader = generator.declareClassField("reader", generator.getModel()._ref(FieldReader.class));
                    if (isNullReaderLikely) {
                        JConditional jc = generator.getEvalBlock()._if(isNull.eq(JExpr.lit((int)0)));
                        JClass nrClass = generator.getModel().ref(NullReader.class);
                        JFieldRef nullReader = complex ? nrClass.staticRef("EMPTY_MAP_INSTANCE") : nrClass.staticRef("EMPTY_LIST_INSTANCE");
                        jc._then().assign((JAssignmentTarget)complexReader, (JExpression)expr);
                        jc._else().assign((JAssignmentTarget)complexReader, (JExpression)nullReader);
                    } else {
                        eval.assign((JAssignmentTarget)complexReader, (JExpression)expr);
                    }
                    ClassGenerator.HoldingContainer hc = new ClassGenerator.HoldingContainer(e.getMajorType(), complexReader, null, null, false, true);
                    return hc;
                }
                if (seg != null) {
                    JExpression argExpr;
                    JVar holderExpr = out.getHolder();
                    if (e.getFieldId().isDict(depth)) {
                        holderExpr = JExpr.cast((JType)generator.getModel()._ref(ValueHolder.class), (JExpression)holderExpr);
                        argExpr = this.getKeyExpression(seg, generator);
                    } else {
                        argExpr = JExpr.lit((int)seg.getArraySegment().getIndex());
                    }
                    JClass dictReaderClass = generator.getModel().ref(SingleDictReaderImpl.class);
                    JConditional jc = eval._if(valueIndex.ne((JExpression)dictReaderClass.staticRef("NOT_FOUND")));
                    jc._then().add((JStatement)expr.invoke("read").arg(argExpr).arg((JExpression)holderExpr));
                } else {
                    eval.add((JStatement)expr.invoke("read").arg((JExpression)out.getHolder()));
                }
            }
            return out;
        }

        private boolean isNullReaderLikely(PathSegment seg, boolean complexOrRepeated) {
            while (seg != null) {
                if (seg.isArray() && !seg.isLastPath()) {
                    return true;
                }
                if (seg.isLastPath() && complexOrRepeated) {
                    return true;
                }
                seg = seg.getChild();
            }
            return false;
        }

        private JExpression getDictReaderReadByKeyExpression(ClassGenerator generator, JBlock eval, JExpression expr, PathSegment segment, JVar valueIndex, JVar isNull) {
            JVar dictReader = generator.declareClassField("dictReader", generator.getModel()._ref(FieldReader.class));
            eval.assign((JAssignmentTarget)dictReader, expr);
            JExpression keyExpr = this.getKeyExpression(segment, generator);
            eval.assign((JAssignmentTarget)valueIndex, (JExpression)expr.invoke("find").arg(keyExpr));
            JConditional conditional = eval._if(valueIndex.gt(JExpr.lit((int)-1)));
            JBlock ifFound = conditional._then().block();
            expr = dictReader.invoke("reader").arg(JExpr.lit((String)"value"));
            ifFound.add((JStatement)expr.invoke("setPosition").arg((JExpression)valueIndex));
            JBlock elseBlock = conditional._else().block();
            JClass nrClass = generator.getModel().ref(NullReader.class);
            JFieldRef nullReader = nrClass.staticRef("EMPTY_MAP_INSTANCE");
            elseBlock.assign((JAssignmentTarget)dictReader, (JExpression)nullReader);
            if (isNull != null) {
                elseBlock.assign((JAssignmentTarget)isNull, JExpr.lit((int)1));
            }
            return expr;
        }

        private JExpression getKeyExpression(PathSegment segment, ClassGenerator generator) {
            TypeProtos.MajorType valueType = segment.getOriginalValueType();
            if (segment.isArray()) {
                if (valueType == null) {
                    return JExpr.lit((int)segment.getArraySegment().getIndex());
                }
                switch (valueType.getMinorType()) {
                    case INT: {
                        return JExpr.cast((JType)generator.getModel().ref(Object.class), (JExpression)JExpr.lit((int)segment.getArraySegment().getIndex()));
                    }
                    case SMALLINT: {
                        return JExpr.lit((int)((Short)segment.getOriginalValue()).shortValue());
                    }
                    case TINYINT: {
                        return JExpr.lit((int)((Byte)segment.getOriginalValue()).byteValue());
                    }
                }
                throw new IllegalArgumentException("ArraySegment!");
            }
            if (valueType == null) {
                return JExpr.lit((String)segment.getNameSegment().getPath());
            }
            switch (valueType.getMinorType()) {
                case VARCHAR: {
                    String vcValue = (String)segment.getOriginalValue();
                    JType keyType = generator.getModel()._ref(Text.class);
                    JInvocation newKeyObject = JExpr._new((JType)keyType).arg(vcValue);
                    JVar dictKey = generator.declareClassField("dictKey", keyType);
                    generator.getSetupBlock().assign((JAssignmentTarget)dictKey, (JExpression)newKeyObject);
                    return dictKey;
                }
                case VARDECIMAL: {
                    BigDecimal bdValue = (BigDecimal)segment.getOriginalValue();
                    JType keyType = generator.getModel()._ref(BigDecimal.class);
                    JClass rmClass = generator.getModel().ref(RoundingMode.class);
                    JInvocation newKeyObject = JExpr._new((JType)keyType).arg(JExpr.lit((double)bdValue.doubleValue())).invoke("setScale").arg(JExpr.lit((int)bdValue.scale())).arg((JExpression)rmClass.staticRef("HALF_UP"));
                    JVar dictKey = generator.declareClassField("dictKey", keyType);
                    generator.getSetupBlock().assign((JAssignmentTarget)dictKey, (JExpression)newKeyObject);
                    return dictKey;
                }
                case BIGINT: {
                    return JExpr.lit((long)((Long)segment.getOriginalValue()));
                }
                case FLOAT4: {
                    return JExpr.lit((float)((Float)segment.getOriginalValue()).floatValue());
                }
                case FLOAT8: {
                    return JExpr.lit((double)((Double)segment.getOriginalValue()));
                }
                case BIT: {
                    return JExpr.lit((boolean)((Boolean)segment.getOriginalValue()));
                }
                case TIMESTAMP: {
                    return this.getDateTimeKey(segment, generator, LocalDateTime.class, "parseBest");
                }
                case DATE: {
                    return this.getDateTimeKey(segment, generator, LocalDate.class, "parseLocalDate");
                }
                case TIME: {
                    return this.getDateTimeKey(segment, generator, LocalTime.class, "parseLocalTime");
                }
            }
            throw new IllegalArgumentException("NamedSegment!");
        }

        private JVar getDateTimeKey(PathSegment segment, ClassGenerator generator, Class<?> javaClass, String methodName) {
            String strValue = (String)segment.getOriginalValue();
            JClass dateUtilityClass = generator.getModel().ref(DateUtility.class);
            JInvocation newKeyObject = dateUtilityClass.staticInvoke(methodName).arg(JExpr.lit((String)strValue));
            JType keyType = generator.getModel()._ref(javaClass);
            JVar dictKey = generator.declareClassField("dictKey", keyType);
            generator.getSetupBlock().assign((JAssignmentTarget)dictKey, (JExpression)newKeyObject);
            return dictKey;
        }

        private ClassGenerator.HoldingContainer visitReturnValueExpression(ReturnValueExpression e, ClassGenerator<?> generator) {
            LogicalExpression child = e.getChild();
            ClassGenerator.HoldingContainer hc = (ClassGenerator.HoldingContainer)child.accept(this, generator);
            if (e.isReturnTrueOnOne()) {
                generator.getEvalBlock()._return(hc.getValue().eq(JExpr.lit((int)1)));
            } else {
                generator.getEvalBlock()._return((JExpression)hc.getValue());
            }
            return null;
        }

        @Override
        public ClassGenerator.HoldingContainer visitQuotedStringConstant(ValueExpressions.QuotedString e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getVarCharHolder(buffer, e.getString()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitIntervalDayConstant(ValueExpressions.IntervalDayExpression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getIntervalDayHolder(e.getIntervalDay(), e.getIntervalMillis()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal9Constant(ValueExpressions.Decimal9Expression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getDecimal9Holder(e.getIntFromDecimal(), e.getScale(), e.getPrecision()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal18Constant(ValueExpressions.Decimal18Expression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getDecimal18Holder(e.getLongFromDecimal(), e.getScale(), e.getPrecision()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal28Constant(ValueExpressions.Decimal28Expression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getDecimal28Holder(buffer, e.getBigDecimal()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitDecimal38Constant(ValueExpressions.Decimal38Expression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getDecimal38Holder(buffer, e.getBigDecimal()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitVarDecimalConstant(ValueExpressions.VarDecimalExpression e, ClassGenerator<?> generator) throws RuntimeException {
            return this.getHoldingContainer(generator, e.getMajorType(), buffer -> ValueHolderHelper.getVarDecimalHolder(buffer, e.getBigDecimal()));
        }

        @Override
        public ClassGenerator.HoldingContainer visitCastExpression(CastExpression e, ClassGenerator<?> value) throws RuntimeException {
            throw new UnsupportedOperationException("CastExpression is not expected here. It should have been converted to FunctionHolderExpression in materialization");
        }

        @Override
        public ClassGenerator.HoldingContainer visitConvertExpression(ConvertExpression e, ClassGenerator<?> value) throws RuntimeException {
            String convertFunctionName = e.getConvertFunction() + e.getEncodingType();
            ArrayList<LogicalExpression> newArgs = new ArrayList<LogicalExpression>();
            newArgs.add(e.getInput());
            FunctionCall fc = new FunctionCall(convertFunctionName, newArgs, e.getPosition());
            return (ClassGenerator.HoldingContainer)fc.accept(this, value);
        }

        @Override
        public ClassGenerator.HoldingContainer visitAnyValueExpression(AnyValueExpression e, ClassGenerator<?> value) throws RuntimeException {
            ArrayList<LogicalExpression> newArgs = new ArrayList<LogicalExpression>();
            newArgs.add(e.getInput());
            FunctionCall fc = new FunctionCall("any_value", newArgs, e.getPosition());
            return (ClassGenerator.HoldingContainer)fc.accept(this, value);
        }

        private ClassGenerator.HoldingContainer visitBooleanAnd(BooleanOperator op, ClassGenerator<?> generator) {
            ClassGenerator.HoldingContainer out = generator.declare(op.getMajorType());
            JLabel label = generator.getEvalBlockLabel("AndOP");
            JBlock eval = generator.createInnerEvalBlock();
            generator.nestEvalBlock(eval);
            ClassGenerator.HoldingContainer arg = null;
            Object e = null;
            for (int i = 0; i < op.args.size(); ++i) {
                arg = (ClassGenerator.HoldingContainer)((LogicalExpression)op.args.get(i)).accept(this, generator);
                JBlock earlyExit = null;
                if (arg.isOptional()) {
                    earlyExit = eval._if(arg.getIsSet().eq(JExpr.lit((int)1)).cand(arg.getValue().ne(JExpr.lit((int)1))))._then();
                    e = e == null ? arg.getIsSet() : e.mul((JExpression)arg.getIsSet());
                } else {
                    earlyExit = eval._if(arg.getValue().ne(JExpr.lit((int)1)))._then();
                }
                if (out.isOptional()) {
                    earlyExit.assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)1));
                }
                earlyExit.assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)0));
                earlyExit._break(label);
            }
            if (out.isOptional()) {
                assert (e != null);
                JConditional notSetJC = eval._if(e.eq(JExpr.lit((int)0)));
                notSetJC._then().assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)0));
                JBlock setBlock = notSetJC._else().block();
                setBlock.assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)1));
                setBlock.assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)1));
            } else {
                assert (e == null);
                eval.assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)1));
            }
            generator.unNestEvalBlock();
            return out;
        }

        private ClassGenerator.HoldingContainer visitBooleanOr(BooleanOperator op, ClassGenerator<?> generator) {
            ClassGenerator.HoldingContainer out = generator.declare(op.getMajorType());
            JLabel label = generator.getEvalBlockLabel("OrOP");
            JBlock eval = generator.createInnerEvalBlock();
            generator.nestEvalBlock(eval);
            ClassGenerator.HoldingContainer arg = null;
            Object e = null;
            for (int i = 0; i < op.args.size(); ++i) {
                arg = (ClassGenerator.HoldingContainer)((LogicalExpression)op.args.get(i)).accept(this, generator);
                JBlock earlyExit = null;
                if (arg.isOptional()) {
                    earlyExit = eval._if(arg.getIsSet().eq(JExpr.lit((int)1)).cand(arg.getValue().eq(JExpr.lit((int)1))))._then();
                    e = e == null ? arg.getIsSet() : e.mul((JExpression)arg.getIsSet());
                } else {
                    earlyExit = eval._if(arg.getValue().eq(JExpr.lit((int)1)))._then();
                }
                if (out.isOptional()) {
                    earlyExit.assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)1));
                }
                earlyExit.assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)1));
                earlyExit._break(label);
            }
            if (out.isOptional()) {
                assert (e != null);
                JConditional notSetJC = eval._if(e.eq(JExpr.lit((int)0)));
                notSetJC._then().assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)0));
                JBlock setBlock = notSetJC._else().block();
                setBlock.assign((JAssignmentTarget)out.getIsSet(), JExpr.lit((int)1));
                setBlock.assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)0));
            } else {
                assert (e == null);
                eval.assign((JAssignmentTarget)out.getValue(), JExpr.lit((int)0));
            }
            generator.unNestEvalBlock();
            return out;
        }
    }

    private class ExpressionHolder {
        private LogicalExpression expression;
        private GeneratorMapping mapping;
        private MappingSet mappingSet;

        ExpressionHolder(LogicalExpression expression, MappingSet mappingSet) {
            this.expression = expression;
            this.mapping = mappingSet.getCurrentMapping();
            this.mappingSet = mappingSet;
        }

        public int hashCode() {
            return this.expression.accept(new HashVisitor(), null);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExpressionHolder)) {
                return false;
            }
            ExpressionHolder that = (ExpressionHolder)obj;
            return this.mappingSet == that.mappingSet && this.mapping == that.mapping && this.expression.accept(new EqualityVisitor(), that.expression) != false;
        }
    }
}

