/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.coord.store;

import oadd.com.dyuproject.protostuff.Schema;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.google.protobuf.Message;
import oadd.org.apache.drill.exec.coord.store.TransientStoreConfigBuilder;
import oadd.org.apache.drill.exec.serialization.InstanceSerializer;
import oadd.org.apache.drill.exec.serialization.JacksonSerializer;
import oadd.org.apache.drill.exec.serialization.ProtoSerializer;
import org.apache.drill.shaded.guava.com.google.common.base.Objects;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;

public class TransientStoreConfig<V> {
    private final String name;
    private final InstanceSerializer<V> serializer;

    protected TransientStoreConfig(String name, InstanceSerializer<V> serializer) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is required");
        this.name = name;
        this.serializer = Preconditions.checkNotNull(serializer, "serializer cannot be null");
    }

    public String getName() {
        return this.name;
    }

    public InstanceSerializer<V> getSerializer() {
        return this.serializer;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.serializer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransientStoreConfig && obj.getClass().equals(this.getClass())) {
            TransientStoreConfig other = (TransientStoreConfig)obj;
            return Objects.equal(this.name, other.name) && Objects.equal(this.serializer, other.serializer);
        }
        return false;
    }

    public static <V> TransientStoreConfigBuilder<V> newBuilder() {
        return new TransientStoreConfigBuilder();
    }

    public static <V extends Message, B extends Message.Builder> TransientStoreConfigBuilder<V> newProtoBuilder(Schema<V> writeSchema, Schema<B> readSchema) {
        return TransientStoreConfig.newBuilder().serializer(new ProtoSerializer<V, B>(readSchema, writeSchema));
    }

    public static <V> TransientStoreConfigBuilder<V> newJacksonBuilder(ObjectMapper mapper, Class<V> klazz) {
        return TransientStoreConfig.newBuilder().serializer(new JacksonSerializer<V>(mapper, klazz));
    }
}

