/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression.types;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oadd.com.fasterxml.jackson.core.JsonGenerationException;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.SerializerProvider;
import oadd.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import oadd.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import oadd.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import oadd.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import oadd.org.apache.drill.common.expression.types.AtomType;
import oadd.org.apache.drill.common.expression.types.LateBindType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=Se.class)
@JsonDeserialize(using=De.class)
abstract class DataType {
    static final Logger logger = LoggerFactory.getLogger(DataType.class);
    public static final DataType LATEBIND = new LateBindType();
    public static final DataType BOOLEAN = new AtomType("BOOLEAN", Comparability.EQUAL, false);
    public static final DataType BYTES = new AtomType("BYTES", Comparability.ORDERED, false);
    public static final DataType SIGNED_BYTE = new AtomType("SIGNED_BYTE", Comparability.ORDERED, true);
    public static final DataType SIGNED_INT16 = new AtomType("SIGNED_INT16", Comparability.ORDERED, true);
    public static final DataType NVARCHAR = new AtomType("VARCHAR", Comparability.ORDERED, false);
    public static final DataType FLOAT32 = new AtomType("FLOAT32", Comparability.ORDERED, true);
    public static final DataType FLOAT64 = new AtomType("FLOAT64", Comparability.ORDERED, true);
    public static final DataType INT64 = new AtomType("INT64", Comparability.ORDERED, true);
    public static final DataType INT32 = new AtomType("INT32", Comparability.ORDERED, true);
    public static final DataType INT16 = new AtomType("INT16", Comparability.ORDERED, true);
    public static final DataType UINT16 = new AtomType("UINT16", Comparability.ORDERED, true);
    public static final DataType DATE = new AtomType("DATE", Comparability.ORDERED, false);
    public static final DataType DATETIME = new AtomType("DATETIME", Comparability.ORDERED, false);
    public static final DataType MAP = new AtomType("MAP", Comparability.NONE, false);
    public static final DataType ARRAY = new AtomType("ARRAY", Comparability.NONE, false);
    public static final DataType NULL = new AtomType("NULL", Comparability.NONE, false);
    static final Map<String, DataType> TYPES;

    DataType() {
    }

    public abstract String getName();

    public abstract boolean isLateBind();

    public abstract boolean hasChildType();

    public abstract DataType getChildType();

    public abstract Comparability getComparability();

    public abstract boolean isNumericType();

    public int size() {
        if (this == BOOLEAN) {
            return 1;
        }
        if (this == INT32) {
            return 4;
        }
        if (this == INT16) {
            return 4;
        }
        return 2;
    }

    public static DataType getDataType(String name) {
        if (TYPES.containsKey(name)) {
            return TYPES.get(name);
        }
        throw new IllegalArgumentException(String.format("Unknown type requested of [%s].", name));
    }

    static {
        Field[] fields = DataType.class.getFields();
        HashMap<String, DataType> types = new HashMap<String, DataType>();
        for (Field f : fields) {
            if (!Modifier.isStatic(f.getModifiers())) continue;
            try {
                Object o = f.get(null);
                if (!(o instanceof DataType)) continue;
                types.put(((DataType)o).getName(), (DataType)o);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                logger.warn("Failure while reading DataType.", e);
            }
        }
        TYPES = Collections.unmodifiableMap(types);
    }

    public static class Se
    extends StdSerializer<DataType> {
        public Se() {
            super(DataType.class);
        }

        @Override
        public void serialize(DataType value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString(value.getName());
        }
    }

    public static class De
    extends StdDeserializer<DataType> {
        public De() {
            super(DataType.class);
        }

        @Override
        public DataType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DataType.getDataType(this._parseString(jp, ctxt));
        }
    }

    public static enum Comparability {
        UNKNOWN,
        NONE,
        EQUAL,
        ORDERED;

    }
}

