/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.digester;

import oadd.org.apache.commons.beanutils.BeanUtils;
import oadd.org.apache.commons.beanutils.DynaBean;
import oadd.org.apache.commons.beanutils.DynaProperty;
import oadd.org.apache.commons.beanutils.PropertyUtils;
import oadd.org.apache.commons.digester.Digester;
import oadd.org.apache.commons.digester.Rule;

public class BeanPropertySetterRule
extends Rule {
    protected String propertyName = null;
    protected String bodyText = null;

    public BeanPropertySetterRule(Digester digester, String propertyName) {
        this(propertyName);
    }

    public BeanPropertySetterRule(Digester digester) {
        this();
    }

    public BeanPropertySetterRule(String propertyName) {
        this.propertyName = propertyName;
    }

    public BeanPropertySetterRule() {
        this((String)null);
    }

    public void body(String namespace, String name, String text) throws Exception {
        if (this.digester.log.isDebugEnabled()) {
            this.digester.log.debug((Object)("[BeanPropertySetterRule]{" + this.digester.match + "} Called with text '" + text + "'"));
        }
        this.bodyText = text.trim();
    }

    public void end(String namespace, String name) throws Exception {
        DynaProperty desc;
        String property = this.propertyName;
        if (property == null) {
            property = name;
        }
        Object top = this.digester.peek();
        if (this.digester.log.isDebugEnabled()) {
            this.digester.log.debug((Object)("[BeanPropertySetterRule]{" + this.digester.match + "} Set " + top.getClass().getName() + " property " + property + " with text " + this.bodyText));
        }
        if (top instanceof DynaBean ? (desc = ((DynaBean)top).getDynaClass().getDynaProperty(property)) == null : (desc = PropertyUtils.getPropertyDescriptor((Object)top, (String)property)) == null) {
            throw new NoSuchMethodException("Bean has no property named " + property);
        }
        BeanUtils.setProperty((Object)top, (String)property, (Object)this.bodyText);
    }

    public void finish() throws Exception {
        this.bodyText = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BeanPropertySetterRule[");
        sb.append("propertyName=");
        sb.append(this.propertyName);
        sb.append("]");
        return sb.toString();
    }
}

