/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.dbcp2.managed;

import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import oadd.org.apache.commons.dbcp2.BasicDataSource;
import oadd.org.apache.commons.dbcp2.ConnectionFactory;
import oadd.org.apache.commons.dbcp2.PoolableConnection;
import oadd.org.apache.commons.dbcp2.PoolableConnectionFactory;
import oadd.org.apache.commons.dbcp2.managed.DataSourceXAConnectionFactory;
import oadd.org.apache.commons.dbcp2.managed.LocalXAConnectionFactory;
import oadd.org.apache.commons.dbcp2.managed.ManagedDataSource;
import oadd.org.apache.commons.dbcp2.managed.PoolableManagedConnectionFactory;
import oadd.org.apache.commons.dbcp2.managed.TransactionRegistry;
import oadd.org.apache.commons.dbcp2.managed.XAConnectionFactory;
import oadd.org.apache.commons.pool2.ObjectPool;

public class BasicManagedDataSource
extends BasicDataSource {
    private TransactionRegistry transactionRegistry;
    private transient TransactionManager transactionManager;
    private String xaDataSource;
    private XADataSource xaDataSourceInstance;

    public synchronized XADataSource getXaDataSourceInstance() {
        return this.xaDataSourceInstance;
    }

    public synchronized void setXaDataSourceInstance(XADataSource xaDataSourceInstance) {
        this.xaDataSourceInstance = xaDataSourceInstance;
        this.xaDataSource = xaDataSourceInstance == null ? null : xaDataSourceInstance.getClass().getName();
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    protected synchronized TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public synchronized String getXADataSource() {
        return this.xaDataSource;
    }

    public synchronized void setXADataSource(String xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws SQLException {
        if (this.transactionManager == null) {
            throw new SQLException("Transaction manager must be set before a connection can be created");
        }
        if (this.xaDataSource == null) {
            ConnectionFactory connectionFactory = super.createConnectionFactory();
            LocalXAConnectionFactory xaConnectionFactory = new LocalXAConnectionFactory(this.getTransactionManager(), connectionFactory);
            this.transactionRegistry = xaConnectionFactory.getTransactionRegistry();
            return xaConnectionFactory;
        }
        if (this.xaDataSourceInstance == null) {
            Class<?> xaDataSourceClass = null;
            try {
                xaDataSourceClass = Class.forName(this.xaDataSource);
            }
            catch (Exception t) {
                String message = "Cannot load XA data source class '" + this.xaDataSource + "'";
                throw new SQLException(message, t);
            }
            try {
                this.xaDataSourceInstance = (XADataSource)xaDataSourceClass.newInstance();
            }
            catch (Exception t) {
                String message = "Cannot create XA data source of class '" + this.xaDataSource + "'";
                throw new SQLException(message, t);
            }
        }
        DataSourceXAConnectionFactory xaConnectionFactory = new DataSourceXAConnectionFactory(this.getTransactionManager(), this.xaDataSourceInstance, this.getUsername(), this.getPassword());
        this.transactionRegistry = xaConnectionFactory.getTransactionRegistry();
        return xaConnectionFactory;
    }

    @Override
    protected DataSource createDataSourceInstance() throws SQLException {
        ManagedDataSource<PoolableConnection> pds = new ManagedDataSource<PoolableConnection>((ObjectPool<PoolableConnection>)this.getConnectionPool(), this.transactionRegistry);
        pds.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        return pds;
    }

    @Override
    protected PoolableConnectionFactory createPoolableConnectionFactory(ConnectionFactory driverConnectionFactory) throws SQLException {
        PoolableManagedConnectionFactory connectionFactory = null;
        try {
            connectionFactory = new PoolableManagedConnectionFactory((XAConnectionFactory)driverConnectionFactory, this.getRegisteredJmxName());
            connectionFactory.setValidationQuery(this.getValidationQuery());
            connectionFactory.setValidationQueryTimeout(this.getValidationQueryTimeout());
            connectionFactory.setConnectionInitSql(this.getConnectionInitSqls());
            connectionFactory.setDefaultReadOnly(this.getDefaultReadOnly());
            connectionFactory.setDefaultAutoCommit(this.getDefaultAutoCommit());
            connectionFactory.setDefaultTransactionIsolation(this.getDefaultTransactionIsolation());
            connectionFactory.setDefaultCatalog(this.getDefaultCatalog());
            connectionFactory.setDefaultSchema(this.getDefaultSchema());
            connectionFactory.setCacheState(this.getCacheState());
            connectionFactory.setPoolStatements(this.isPoolPreparedStatements());
            connectionFactory.setMaxOpenPreparedStatements(this.getMaxOpenPreparedStatements());
            connectionFactory.setMaxConnLifetimeMillis(this.getMaxConnLifetimeMillis());
            connectionFactory.setRollbackOnReturn(this.getRollbackOnReturn());
            connectionFactory.setEnableAutoCommitOnReturn(this.getEnableAutoCommitOnReturn());
            connectionFactory.setDefaultQueryTimeout(this.getDefaultQueryTimeout());
            connectionFactory.setFastFailValidation(this.getFastFailValidation());
            connectionFactory.setDisconnectionSqlCodes(this.getDisconnectionSqlCodes());
            BasicManagedDataSource.validateConnectionFactory(connectionFactory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Cannot create PoolableConnectionFactory (" + e.getMessage() + ")", e);
        }
        return connectionFactory;
    }
}

