/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.jsonwebtoken.impl.crypto;

import java.nio.charset.Charset;
import java.security.Key;
import oadd.io.jsonwebtoken.SignatureAlgorithm;
import oadd.io.jsonwebtoken.impl.TextCodec;
import oadd.io.jsonwebtoken.impl.crypto.DefaultSignerFactory;
import oadd.io.jsonwebtoken.impl.crypto.JwtSigner;
import oadd.io.jsonwebtoken.impl.crypto.Signer;
import oadd.io.jsonwebtoken.impl.crypto.SignerFactory;
import oadd.io.jsonwebtoken.lang.Assert;

public class DefaultJwtSigner
implements JwtSigner {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private final Signer signer;

    public DefaultJwtSigner(SignatureAlgorithm alg, Key key) {
        this(DefaultSignerFactory.INSTANCE, alg, key);
    }

    public DefaultJwtSigner(SignerFactory factory, SignatureAlgorithm alg, Key key) {
        Assert.notNull(factory, "SignerFactory argument cannot be null.");
        this.signer = factory.createSigner(alg, key);
    }

    @Override
    public String sign(String jwtWithoutSignature) {
        byte[] bytesToSign = jwtWithoutSignature.getBytes(US_ASCII);
        byte[] signature = this.signer.sign(bytesToSign);
        return TextCodec.BASE64URL.encode(signature);
    }
}

