/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.typesafe.config.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import oadd.com.typesafe.config.ConfigOrigin;
import oadd.com.typesafe.config.ConfigRenderOptions;
import oadd.com.typesafe.config.ConfigValueType;
import oadd.com.typesafe.config.impl.AbstractConfigValue;
import oadd.com.typesafe.config.impl.ConfigImplUtil;
import oadd.com.typesafe.config.impl.SerializedConfigValue;

final class ConfigString
extends AbstractConfigValue
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String value;

    ConfigString(ConfigOrigin configOrigin, String string) {
        super(configOrigin);
        this.value = string;
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.STRING;
    }

    @Override
    public String unwrapped() {
        return this.value;
    }

    @Override
    String transformToString() {
        return this.value;
    }

    @Override
    protected void render(StringBuilder stringBuilder, int n, ConfigRenderOptions configRenderOptions) {
        String string = configRenderOptions.getJson() ? ConfigImplUtil.renderJsonString(this.value) : ConfigImplUtil.renderStringUnquotedIfPossible(this.value);
        stringBuilder.append(string);
    }

    @Override
    protected ConfigString newCopy(ConfigOrigin configOrigin) {
        return new ConfigString(configOrigin, this.value);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }
}

