/*
 * Decompiled with CFR 0.152.
 */
package com.papertrail.profiler;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import oadd.org.joda.time.Duration;
import oadd.org.joda.time.Instant;

public class CpuProfile {
    private final Map<List<StackTraceElement>, Long> counts;
    public final Duration duration;
    public final long count;
    public final long missed;
    private static final Set<StringPair> idleClassAndMethod = new HashSet<StringPair>();

    public CpuProfile(Map<List<StackTraceElement>, Long> counts, Duration duration, long count, long missed) {
        this.counts = counts;
        this.duration = duration;
        this.count = count;
        this.missed = missed;
    }

    public void writeGoogleProfile(OutputStream out) throws IOException {
        int next = 1;
        HashMap<StackTraceElement, Integer> uniq = new HashMap<StackTraceElement, Integer>();
        Word word = new Word(out);
        word.putString(String.format("--- symbol\nbinary=%s\n", CpuProfile.mainClassName()));
        for (Map.Entry<List<StackTraceElement>, Long> stack : this.counts.entrySet()) {
            for (StackTraceElement frame : stack.getKey()) {
                if (uniq.containsKey(frame)) continue;
                word.putString(String.format("0x%016x %s\n", next, frame.toString()));
                uniq.put(frame, next);
                ++next;
            }
        }
        word.putString("---\n--- profile\n");
        for (Object w : (Iterator<Map.Entry<List<StackTraceElement>, Long>>)new int[]{0, 3, 0, 1, 0}) {
            word.putWord((long)w);
        }
        for (Map.Entry<List<StackTraceElement>, Long> entry : this.counts.entrySet()) {
            List<StackTraceElement> stack = entry.getKey();
            long n = entry.getValue();
            if (!stack.isEmpty()) {
                word.putWord(n);
                word.putWord(stack.size());
            }
            for (StackTraceElement frame : stack) {
                word.putWord(((Integer)uniq.get(frame)).intValue());
            }
        }
        word.putWord(0L);
        word.putWord(1L);
        word.putWord(0L);
        word.flush();
    }

    protected static boolean isRunnable(StackTraceElement elem) {
        return !idleClassAndMethod.contains(new StringPair(elem.getClassName(), elem.getMethodName()));
    }

    public static CpuProfile record(Duration howlong, int frequency, Thread.State state) {
        if (frequency > 1000) {
            throw new RuntimeException("frequency must be < 1000");
        }
        HashMap<List<StackTraceElement>, Long> counts = new HashMap<List<StackTraceElement>, Long>();
        ThreadMXBean bean2 = ManagementFactory.getThreadMXBean();
        Instant start = Instant.now();
        Instant end = start.plus(howlong);
        int periodMillis = 1000 / frequency;
        long myId = Thread.currentThread().getId();
        Instant next = Instant.now();
        long n = 0L;
        long nmissed = 0L;
        while (Instant.now().isBefore(end)) {
            for (ThreadInfo thread : bean2.dumpAllThreads(false, false)) {
                boolean include;
                List<StackTraceElement> s;
                if (thread.getThreadState() != state || thread.getThreadId() == myId || (s = Arrays.asList(thread.getStackTrace())).isEmpty()) continue;
                boolean bl = include = state != Thread.State.RUNNABLE || CpuProfile.isRunnable(s.get(0));
                if (!include) continue;
                if (counts.get(s) == null) {
                    counts.put(s, 1L);
                    continue;
                }
                long count = (Long)counts.get(s);
                counts.put(s, count + 1L);
            }
            ++n;
            next = next.plus(periodMillis);
            while (next.isBefore(Instant.now()) && next.isBefore(end)) {
                ++nmissed;
                next = next.plus(periodMillis);
            }
            long sleep = Math.max(next.getMillis() - Instant.now().getMillis(), 0L);
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                System.out.print("CpuProfile interrupted.");
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return new CpuProfile(counts, new Duration(start, Instant.now()), n, nmissed);
    }

    public CpuProfile record(Duration howlong, int frequency) {
        return CpuProfile.record(howlong, frequency, Thread.State.RUNNABLE);
    }

    public static Future<CpuProfile> recordInThread(final Duration howlong, final int frequency, final Thread.State state) {
        FutureTask<CpuProfile> future = new FutureTask<CpuProfile>(new Callable<CpuProfile>(){

            @Override
            public CpuProfile call() throws Exception {
                return CpuProfile.record(howlong, frequency, state);
            }
        });
        Thread t = new Thread(future, "CpuProfile");
        t.start();
        return future;
    }

    public static Future<CpuProfile> recordInThread(Duration howlong, int frequency) {
        return CpuProfile.recordInThread(howlong, frequency, Thread.State.RUNNABLE);
    }

    public static String mainClassName() {
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            Thread t = entry.getKey();
            StackTraceElement[] elements = entry.getValue();
            if (!"main".equals(t.getName())) continue;
            for (int i = elements.length - 1; i >= 0; --i) {
                StackTraceElement elem = elements[i];
                if (elem.getClassName().startsWith("scala.tools.nsc.MainGenericRunner")) continue;
                return elem.getClassName();
            }
        }
        return "unknown";
    }

    static {
        idleClassAndMethod.add(new StringPair("sun.nio.ch.EPollArrayWrapper", "epollWait"));
        idleClassAndMethod.add(new StringPair("sun.nio.ch.KQueueArrayWrapper", "kevent0"));
        idleClassAndMethod.add(new StringPair("java.net.SocketInputStream", "socketRead0"));
        idleClassAndMethod.add(new StringPair("java.net.SocketOutputStream", "socketWrite0"));
        idleClassAndMethod.add(new StringPair("java.net.PlainSocketImpl", "socketAvailable"));
        idleClassAndMethod.add(new StringPair("java.net.PlainSocketImpl", "socketAccept"));
        idleClassAndMethod.add(new StringPair("sun.nio.ch.ServerSocketChannelImpl", "accept0"));
    }

    static class StringPair {
        final String a;
        final String b;

        StringPair(String a, String b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringPair that = (StringPair)o;
            return Objects.equals(this.a, that.a) && Objects.equals(this.b, that.b);
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }
    }

    private static class Word {
        final ByteBuffer buf;
        final OutputStream os;

        public Word(OutputStream os) {
            this(Word.createBuffer(), os);
        }

        private Word(ByteBuffer buf, OutputStream os) {
            this.buf = buf;
            this.os = os;
        }

        public void putWord(long n) throws IOException {
            this.buf.clear();
            this.buf.putLong(n);
            this.os.write(this.buf.array());
        }

        public void putString(String s) throws IOException {
            this.os.write(s.getBytes());
        }

        private static ByteBuffer createBuffer() {
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            return buf;
        }

        public void flush() throws IOException {
            this.os.flush();
        }
    }
}

