/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.JsonParserReader;
import com.esri.core.geometry.JsonReader;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.SpatialReferenceSerializer;
import java.io.ObjectStreamException;
import java.io.Serializable;
import oadd.com.fasterxml.jackson.core.JsonParser;

public abstract class SpatialReference
implements Serializable {
    private static final long serialVersionUID = 2L;

    public static SpatialReference create(int wkid) {
        SpatialReferenceImpl spatRef = SpatialReferenceImpl.createImpl(wkid);
        return spatRef;
    }

    public static SpatialReference create(String wktext) {
        return SpatialReferenceImpl.createImpl(wktext);
    }

    boolean isLocal() {
        return false;
    }

    public static SpatialReference fromJson(JsonParser parser) throws Exception {
        return SpatialReference.fromJson(new JsonParserReader(parser));
    }

    public static SpatialReference fromJson(String string) throws Exception {
        return SpatialReference.fromJson(JsonParserReader.createFromString(string));
    }

    public static SpatialReference fromJson(JsonReader parser) throws Exception {
        boolean bFoundWkid = false;
        boolean bFoundLatestWkid = false;
        boolean bFoundVcsWkid = false;
        boolean bFoundLatestVcsWkid = false;
        boolean bFoundWkt = false;
        int wkid = -1;
        int latestWkid = -1;
        int vcs_wkid = -1;
        int latestVcsWkid = -1;
        String wkt = null;
        while (parser.nextToken() != JsonReader.Token.END_OBJECT) {
            String name = parser.currentString();
            parser.nextToken();
            if (!bFoundWkid && name.equals("wkid")) {
                bFoundWkid = true;
                if (parser.currentToken() != JsonReader.Token.VALUE_NUMBER_INT) continue;
                wkid = parser.currentIntValue();
                continue;
            }
            if (!bFoundLatestWkid && name.equals("latestWkid")) {
                bFoundLatestWkid = true;
                if (parser.currentToken() != JsonReader.Token.VALUE_NUMBER_INT) continue;
                latestWkid = parser.currentIntValue();
                continue;
            }
            if (!bFoundWkt && name.equals("wkt")) {
                bFoundWkt = true;
                if (parser.currentToken() != JsonReader.Token.VALUE_STRING) continue;
                wkt = parser.currentString();
                continue;
            }
            if (!bFoundVcsWkid && name.equals("vcsWkid")) {
                bFoundVcsWkid = true;
                if (parser.currentToken() != JsonReader.Token.VALUE_NUMBER_INT) continue;
                vcs_wkid = parser.currentIntValue();
                continue;
            }
            if (bFoundLatestVcsWkid || !name.equals("latestVcsWkid")) continue;
            bFoundLatestVcsWkid = true;
            if (parser.currentToken() != JsonReader.Token.VALUE_NUMBER_INT) continue;
            latestVcsWkid = parser.currentIntValue();
        }
        if (latestVcsWkid <= 0 && vcs_wkid > 0) {
            latestVcsWkid = vcs_wkid;
        }
        SpatialReference spatial_reference = null;
        if (wkt != null && wkt.length() != 0) {
            try {
                spatial_reference = SpatialReference.create(wkt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (spatial_reference == null && latestWkid > 0) {
            try {
                spatial_reference = SpatialReference.create(latestWkid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (spatial_reference == null && wkid > 0) {
            try {
                spatial_reference = SpatialReference.create(wkid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return spatial_reference;
    }

    public abstract int getID();

    public abstract String getText();

    abstract int getOldID();

    abstract int getLatestID();

    public double getTolerance() {
        return this.getTolerance(0);
    }

    abstract double getTolerance(int var1);

    Object writeReplace() throws ObjectStreamException {
        SpatialReferenceSerializer srSerializer = new SpatialReferenceSerializer();
        srSerializer.setSpatialReferenceByValue(this);
        return srSerializer;
    }

    public String toString() {
        return "[ tol: " + this.getTolerance() + "; wkid: " + this.getID() + "; wkt: " + this.getText() + "]";
    }
}

