/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.RawString;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRawString {
    static final String[] VALUES = new String[]{"", "1", "22", "333", "4444", "55555", "666666", "7777777", "88888888", "999999999"};

    @Test
    public void testReadWrite() {
        for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
            RawString type = Order.ASCENDING == ord ? RawString.ASCENDING : RawString.DESCENDING;
            for (String val : VALUES) {
                SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(Bytes.toBytes((String)val).length);
                Assert.assertEquals((long)buff.getLength(), (long)type.encode((PositionedByteRange)buff, val));
                byte[] expected = Bytes.toBytes((String)val);
                ord.apply(expected);
                Assert.assertArrayEquals((byte[])expected, (byte[])buff.getBytes());
                buff.setPosition(0);
                Assert.assertEquals((Object)val, (Object)type.decode((PositionedByteRange)buff));
                buff.setPosition(0);
                Assert.assertEquals((long)buff.getLength(), (long)type.skip((PositionedByteRange)buff));
                Assert.assertEquals((long)buff.getLength(), (long)buff.getPosition());
            }
        }
    }
}

