/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.server.preauth.pkinit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.crypto.interfaces.DHPublicKey;
import org.apache.kerby.asn1.Asn1;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.type.Asn1Integer;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.cms.type.CertificateChoices;
import org.apache.kerby.cms.type.CertificateSet;
import org.apache.kerby.cms.type.ContentInfo;
import org.apache.kerby.cms.type.EncapsulatedContentInfo;
import org.apache.kerby.cms.type.SignedData;
import org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.common.CheckSumUtil;
import org.apache.kerby.kerberos.kerb.common.KrbUtil;
import org.apache.kerby.kerberos.kerb.crypto.dh.DiffieHellmanServer;
import org.apache.kerby.kerberos.kerb.preauth.PluginRequestContext;
import org.apache.kerby.kerberos.kerb.preauth.PreauthPluginMeta;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.CertificateHelper;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.CmsMessageType;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.PkinitCrypto;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.PkinitPlgCryptoContext;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.PkinitPreauthMeta;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.PluginOpts;
import org.apache.kerby.kerberos.kerb.server.KdcContext;
import org.apache.kerby.kerberos.kerb.server.preauth.AbstractPreauthPlugin;
import org.apache.kerby.kerberos.kerb.server.preauth.pkinit.PkinitKdcContext;
import org.apache.kerby.kerberos.kerb.server.preauth.pkinit.PkinitRequestContext;
import org.apache.kerby.kerberos.kerb.server.request.KdcRequest;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.CheckSum;
import org.apache.kerby.kerberos.kerb.type.base.CheckSumType;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcOption;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.AuthPack;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.DhRepInfo;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.KdcDhKeyInfo;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.PaPkAsRep;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.PaPkAsReq;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.PkAuthenticator;
import org.apache.kerby.x509.type.Certificate;
import org.apache.kerby.x509.type.DhParameter;
import org.apache.kerby.x509.type.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PkinitPreauth
extends AbstractPreauthPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(PkinitPreauth.class);
    private final Map<String, PkinitKdcContext> pkinitContexts = new HashMap<String, PkinitKdcContext>(1);

    public PkinitPreauth() {
        super((PreauthPluginMeta)new PkinitPreauthMeta());
    }

    @Override
    public void initWith(KdcContext kdcContext) {
        String pkinitIdentity;
        super.initWith(kdcContext);
        PkinitKdcContext tmp = new PkinitKdcContext();
        tmp.realm = kdcContext.getKdcRealm();
        tmp.identityOpts.identity = pkinitIdentity = kdcContext.getConfig().getPkinitIdentity();
        this.pkinitContexts.put(kdcContext.getKdcRealm(), tmp);
    }

    @Override
    public PluginRequestContext initRequestContext(KdcRequest kdcRequest) {
        PkinitRequestContext reqCtx = new PkinitRequestContext();
        return reqCtx;
    }

    @Override
    public boolean verify(KdcRequest kdcRequest, PluginRequestContext requestContext, PaDataEntry paData) throws KrbException {
        LOG.info("pkinit verify padata: entered!");
        PkinitRequestContext reqCtx = (PkinitRequestContext)requestContext;
        PrincipalName serverPrincipal = kdcRequest.getServerEntry().getPrincipal();
        kdcRequest.setServerPrincipal(serverPrincipal);
        PkinitKdcContext pkinitContext = this.findContext(serverPrincipal);
        if (pkinitContext == null) {
            return false;
        }
        reqCtx.paType = paData.getPaDataType();
        if (paData.getPaDataType() == PaDataType.PK_AS_REQ) {
            LOG.info("processing PK_AS_REQ");
            PaPkAsReq paPkAsReq = (PaPkAsReq)KrbCodec.decode((byte[])paData.getPaDataValue(), PaPkAsReq.class);
            byte[] signedAuthPack = paPkAsReq.getSignedAuthPack();
            AuthPack authPack = null;
            if (kdcRequest.isAnonymous()) {
                EncapsulatedContentInfo eContentInfo = new EncapsulatedContentInfo();
                try {
                    eContentInfo.decode(signedAuthPack);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                authPack = (AuthPack)KrbCodec.decode((byte[])eContentInfo.getContent(), AuthPack.class);
            } else {
                ContentInfo contentInfo = new ContentInfo();
                try {
                    contentInfo.decode(signedAuthPack);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SignedData signedData = (SignedData)contentInfo.getContentAs(SignedData.class);
                PkinitCrypto.verifyCmsSignedData((CmsMessageType)CmsMessageType.CMS_SIGN_CLIENT, (SignedData)signedData);
                Boolean isSigned = signedData.isSigned();
                if (isSigned.booleanValue()) {
                    LOG.info("Signed data.");
                } else {
                    PrincipalName clientPrincial = kdcRequest.getClientEntry().getPrincipal();
                    PrincipalName anonymousPrincipal = KrbUtil.makeAnonymousPrincipal();
                    if (kdcRequest.getKdcOptions().isFlagSet((EnumType)KdcOption.REQUEST_ANONYMOUS) && !KrbUtil.pricipalCompareIgnoreRealm((PrincipalName)clientPrincial, (PrincipalName)anonymousPrincipal)) {
                        String errMsg = "Pkinit request not signed, but client not anonymous.";
                        LOG.error(errMsg);
                        throw new KrbException(KrbErrorCode.KDC_ERR_PREAUTH_FAILED, errMsg);
                    }
                }
                authPack = (AuthPack)KrbCodec.decode((byte[])signedData.getEncapContentInfo().getContent(), AuthPack.class);
            }
            PkAuthenticator pkAuthenticator = authPack.getPkAuthenticator();
            this.checkClockskew(kdcRequest, pkAuthenticator.getCtime());
            byte[] reqBodyBytes = null;
            if (kdcRequest.getReqPackage() == null) {
                LOG.error("ReqBodyBytes isn't available");
                return false;
            }
            Asn1ParseResult parseResult = null;
            try {
                parseResult = Asn1.parse((ByteBuffer)kdcRequest.getReqPackage());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Asn1Container container = (Asn1Container)parseResult;
            List parseResults = container.getChildren();
            Asn1Container parsingItem = (Asn1Container)parseResults.get(0);
            List items = parsingItem.getChildren();
            if (items.size() > 3) {
                ByteBuffer bodyBuffer = ((Asn1ParseResult)items.get(3)).getBodyBuffer();
                reqBodyBytes = new byte[bodyBuffer.remaining()];
                bodyBuffer.get(reqBodyBytes);
            }
            CheckSum expectedCheckSum = null;
            try {
                expectedCheckSum = CheckSumUtil.makeCheckSum((CheckSumType)CheckSumType.NIST_SHA, reqBodyBytes);
            }
            catch (KrbException e) {
                LOG.error("Unable to calculate AS REQ checksum.", (Object)e.getMessage());
            }
            byte[] receivedCheckSumByte = pkAuthenticator.getPaChecksum();
            if (expectedCheckSum.getChecksum().length != receivedCheckSumByte.length || !Arrays.equals(expectedCheckSum.getChecksum(), receivedCheckSumByte)) {
                LOG.debug("received checksum length: " + receivedCheckSumByte.length + ", expected checksum type: " + expectedCheckSum.getCksumtype() + ", expected checksum length: " + expectedCheckSum.encodingLength());
                String errorMessage = "Failed to match the checksum.";
                LOG.error(errorMessage);
                throw new KrbException(KrbErrorCode.KDC_ERR_PA_CHECKSUM_MUST_BE_INCLUDED, errorMessage);
            }
            SubjectPublicKeyInfo publicKeyInfo = authPack.getClientPublicValue();
            if (publicKeyInfo.getSubjectPubKey() != null) {
                DhParameter dhParameter = (DhParameter)authPack.getClientPublicValue().getAlgorithm().getParametersAs(DhParameter.class);
                PkinitCrypto.serverCheckDH((PluginOpts)pkinitContext.pluginOpts, (PkinitPlgCryptoContext)pkinitContext.cryptoctx, (DhParameter)dhParameter);
                byte[] clientSubjectPubKey = (byte[])publicKeyInfo.getSubjectPubKey().getValue();
                Asn1Integer clientPubKey = (Asn1Integer)KrbCodec.decode((byte[])clientSubjectPubKey, Asn1Integer.class);
                BigInteger y = (BigInteger)clientPubKey.getValue();
                BigInteger p = dhParameter.getP();
                BigInteger g = dhParameter.getG();
                DHPublicKey dhPublicKey = PkinitCrypto.createDHPublicKey((BigInteger)p, (BigInteger)g, (BigInteger)y);
                DiffieHellmanServer server = new DiffieHellmanServer();
                DHPublicKey serverPubKey = null;
                try {
                    serverPubKey = (DHPublicKey)server.initAndDoPhase(dhPublicKey.getEncoded());
                }
                catch (Exception e) {
                    LOG.error("Fail to create server public key.", (Throwable)e);
                }
                EncryptionKey secretKey = server.generateKey(null, null, kdcRequest.getEncryptionType());
                kdcRequest.setClientKey(secretKey);
                String identity = pkinitContext.identityOpts.identity;
                PaPkAsRep paPkAsRep = this.makePaPkAsRep(pkinitContext.cryptoctx, serverPubKey, identity);
                PaDataEntry paDataEntry = this.makeEntry(paPkAsRep);
                kdcRequest.getPreauthContext().getOutputPaData().add((Asn1Type)paDataEntry);
            } else {
                if (!kdcRequest.isAnonymous()) {
                    String errMessage = "Anonymous pkinit without DH public value not supported.";
                    LOG.error(errMessage);
                    throw new KrbException(KrbErrorCode.KDC_ERR_PREAUTH_FAILED, errMessage);
                }
                System.out.println("rsa");
            }
        }
        return true;
    }

    private PkinitKdcContext findContext(PrincipalName principal) {
        String realm = principal.getRealm();
        if (this.pkinitContexts.containsKey(realm)) {
            return this.pkinitContexts.get(realm);
        }
        return null;
    }

    private PaDataEntry makeEntry(PaPkAsRep paPkAsRep) throws KrbException {
        PaDataEntry paDataEntry = new PaDataEntry();
        paDataEntry.setPaDataType(PaDataType.PK_AS_REP);
        try {
            paDataEntry.setPaDataValue(paPkAsRep.encode());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return paDataEntry;
    }

    private PaPkAsRep makePaPkAsRep(PkinitPlgCryptoContext cryptoContext, DHPublicKey severPubKey, String identityString) throws KrbException {
        List<String> identityList = Arrays.asList(identityString.split(","));
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (String identity : identityList) {
            File file = new File(identity);
            try {
                Scanner scanner = new Scanner(file, "UTF-8");
                String found = scanner.findInLine("CERTIFICATE");
                if (found == null) continue;
                FileInputStream res = null;
                try {
                    res = new FileInputStream(identity);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                X509Certificate certificate = null;
                try {
                    certificate = (X509Certificate)CertificateHelper.loadCerts((InputStream)res).iterator().next();
                }
                catch (KrbException e) {
                    e.printStackTrace();
                }
                certificates.add(certificate);
            }
            catch (FileNotFoundException e) {
                e.getMessage();
            }
        }
        PaPkAsRep paPkAsRep = new PaPkAsRep();
        DhRepInfo dhRepInfo = new DhRepInfo();
        KdcDhKeyInfo kdcDhKeyInfo = new KdcDhKeyInfo();
        Asn1Integer publickey = new Asn1Integer(severPubKey.getY());
        byte[] pubKeyData = KrbCodec.encode((Asn1Type)publickey);
        kdcDhKeyInfo.setSubjectPublicKey(pubKeyData);
        kdcDhKeyInfo.setNonce(0);
        kdcDhKeyInfo.setDHKeyExpiration(new KerberosTime(System.currentTimeMillis() + 86400000L));
        byte[] signedDataBytes = null;
        CertificateSet certificateSet = new CertificateSet();
        for (X509Certificate x509Certificate : certificates) {
            Certificate certificate = PkinitCrypto.changeToCertificate((X509Certificate)x509Certificate);
            CertificateChoices certificateChoices = new CertificateChoices();
            certificateChoices.setCertificate(certificate);
            certificateSet.addElement((Asn1Type)certificateChoices);
        }
        String oid = cryptoContext.getIdPkinitDHKeyDataOID();
        signedDataBytes = PkinitCrypto.cmsSignedDataCreate((byte[])KrbCodec.encode((Asn1Type)kdcDhKeyInfo), (String)oid, (int)3, null, null, null, null);
        dhRepInfo.setDHSignedData(signedDataBytes);
        paPkAsRep.setDHRepInfo(dhRepInfo);
        return paPkAsRep;
    }

    private boolean checkClockskew(KdcRequest kdcRequest, KerberosTime time) throws KrbException {
        long clockSkew = kdcRequest.getKdcContext().getConfig().getAllowableClockSkew() * 1000L;
        if (!time.isInClockSkew(clockSkew)) {
            throw new KrbException(KrbErrorCode.KDC_ERR_PREAUTH_FAILED);
        }
        return true;
    }
}

