/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.server;

import java.io.File;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.identity.backend.BackendConfig;
import org.apache.kerby.kerberos.kerb.identity.backend.IdentityBackend;
import org.apache.kerby.kerberos.kerb.server.KdcConfig;
import org.apache.kerby.kerberos.kerb.server.KdcServerOption;
import org.apache.kerby.kerberos.kerb.server.KdcSetting;
import org.apache.kerby.kerberos.kerb.server.KdcUtil;
import org.apache.kerby.kerberos.kerb.server.impl.DefaultInternalKdcServerImpl;
import org.apache.kerby.kerberos.kerb.server.impl.InternalKdcServer;

public class KdcServer {
    private final KdcConfig kdcConfig;
    private final BackendConfig backendConfig;
    private final KdcSetting kdcSetting;
    private final KOptions startupOptions;
    private InternalKdcServer innerKdc;

    public KdcServer(KdcConfig kdcConfig, BackendConfig backendConfig) throws KrbException {
        this.kdcConfig = kdcConfig;
        this.backendConfig = backendConfig;
        this.startupOptions = new KOptions();
        this.kdcSetting = new KdcSetting(this.startupOptions, kdcConfig, backendConfig);
    }

    public KdcServer(File confDir) throws KrbException {
        KdcConfig tmpKdcConfig = KdcUtil.getKdcConfig(confDir);
        if (tmpKdcConfig == null) {
            tmpKdcConfig = new KdcConfig();
        }
        this.kdcConfig = tmpKdcConfig;
        BackendConfig tmpBackendConfig = KdcUtil.getBackendConfig(confDir);
        if (tmpBackendConfig == null) {
            tmpBackendConfig = new BackendConfig();
        }
        tmpBackendConfig.setConfDir(confDir);
        this.backendConfig = tmpBackendConfig;
        this.startupOptions = new KOptions();
        this.kdcSetting = new KdcSetting(this.startupOptions, this.kdcConfig, this.backendConfig);
    }

    public KdcServer() {
        this.kdcConfig = new KdcConfig();
        this.backendConfig = new BackendConfig();
        this.startupOptions = new KOptions();
        this.kdcSetting = new KdcSetting(this.startupOptions, this.kdcConfig, this.backendConfig);
    }

    public void setKdcRealm(String realm) {
        this.startupOptions.add((KOption)KdcServerOption.KDC_REALM, (Object)realm);
    }

    public void setKdcHost(String kdcHost) {
        this.startupOptions.add((KOption)KdcServerOption.KDC_HOST, (Object)kdcHost);
    }

    public void setKdcPort(int kdcPort) {
        this.startupOptions.add((KOption)KdcServerOption.KDC_PORT, (Object)kdcPort);
    }

    public void setKdcTcpPort(int kdcTcpPort) {
        this.startupOptions.add((KOption)KdcServerOption.KDC_TCP_PORT, (Object)kdcTcpPort);
    }

    public void setAllowUdp(boolean allowUdp) {
        this.startupOptions.add((KOption)KdcServerOption.ALLOW_UDP, (Object)allowUdp);
    }

    public void setAllowTcp(boolean allowTcp) {
        this.startupOptions.add((KOption)KdcServerOption.ALLOW_TCP, (Object)allowTcp);
    }

    public void setKdcUdpPort(int kdcUdpPort) {
        this.startupOptions.add((KOption)KdcServerOption.KDC_UDP_PORT, (Object)kdcUdpPort);
    }

    public void setWorkDir(File workDir) {
        this.startupOptions.add((KOption)KdcServerOption.WORK_DIR, (Object)workDir);
    }

    public void enableDebug() {
        this.startupOptions.add((KOption)KdcServerOption.ENABLE_DEBUG);
    }

    public void setInnerKdcImpl(InternalKdcServer innerKdcImpl) {
        this.startupOptions.add((KOption)KdcServerOption.INNER_KDC_IMPL, (Object)innerKdcImpl);
    }

    public KdcSetting getKdcSetting() {
        return this.kdcSetting;
    }

    public KdcConfig getKdcConfig() {
        return this.kdcConfig;
    }

    public BackendConfig getBackendConfig() {
        return this.backendConfig;
    }

    public IdentityBackend getIdentityService() {
        if (this.innerKdc == null) {
            throw new RuntimeException("Not init yet");
        }
        return this.innerKdc.getIdentityBackend();
    }

    public void init() throws KrbException {
        this.innerKdc = this.startupOptions.contains((KOption)KdcServerOption.INNER_KDC_IMPL) ? (InternalKdcServer)this.startupOptions.getOptionValue((KOption)KdcServerOption.INNER_KDC_IMPL) : new DefaultInternalKdcServerImpl(this.kdcSetting);
        this.innerKdc.init();
    }

    public void start() throws KrbException {
        if (this.innerKdc == null) {
            throw new RuntimeException("Not init yet");
        }
        this.innerKdc.start();
    }

    public void stop() throws KrbException {
        if (this.innerKdc != null) {
            this.innerKdc.stop();
        }
    }
}

