/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.readers.initilializers;

import java.util.HashMap;
import java.util.Map;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.store.hive.HiveSubScan;
import org.apache.drill.exec.store.hive.readers.HiveAbstractReader;
import org.apache.drill.exec.store.hive.readers.HiveAvroReader;
import org.apache.drill.exec.store.hive.readers.HiveDefaultReader;
import org.apache.drill.exec.store.hive.readers.HiveOrcReader;
import org.apache.drill.exec.store.hive.readers.HiveParquetReader;
import org.apache.drill.exec.store.hive.readers.HiveRCFileReader;
import org.apache.drill.exec.store.hive.readers.HiveTextReader;
import org.apache.drill.exec.store.hive.readers.initilializers.AbstractReadersInitializer;
import org.apache.drill.exec.store.hive.readers.initilializers.DefaultReadersInitializer;
import org.apache.drill.exec.store.hive.readers.initilializers.EmptyReadersInitializer;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

public class ReadersInitializer {
    private static final Map<String, Class<? extends HiveAbstractReader>> READER_MAP = new HashMap<String, Class<? extends HiveAbstractReader>>();

    public static AbstractReadersInitializer getInitializer(FragmentContext context, HiveSubScan config) {
        Class<? extends HiveAbstractReader> readerClass = ReadersInitializer.getReaderClass(config);
        if (config.getInputSplits().isEmpty()) {
            return new EmptyReadersInitializer(context, config, readerClass);
        }
        return new DefaultReadersInitializer(context, config, readerClass);
    }

    private static Class<? extends HiveAbstractReader> getReaderClass(HiveSubScan config) {
        String formatName = config.getTable().getSd().getInputFormat();
        Class readerClass = HiveDefaultReader.class;
        if (READER_MAP.containsKey(formatName)) {
            readerClass = READER_MAP.get(formatName);
        }
        return readerClass;
    }

    static {
        READER_MAP.put(OrcInputFormat.class.getCanonicalName(), HiveOrcReader.class);
        READER_MAP.put(AvroContainerInputFormat.class.getCanonicalName(), HiveAvroReader.class);
        READER_MAP.put(RCFileInputFormat.class.getCanonicalName(), HiveRCFileReader.class);
        READER_MAP.put(MapredParquetInputFormat.class.getCanonicalName(), HiveParquetReader.class);
        READER_MAP.put(TextInputFormat.class.getCanonicalName(), HiveTextReader.class);
    }
}

