/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.readers;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.store.hive.HivePartition;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.readers.HiveAbstractReader;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.security.UserGroupInformation;

public class HiveAvroReader
extends HiveAbstractReader {
    Object value;

    public HiveAvroReader(HiveTableWithColumnCache table, HivePartition partition, Collection<InputSplit> inputSplit, List<SchemaPath> projectedColumns, FragmentContext context, HiveConf hiveConf, UserGroupInformation proxyUgi) throws ExecutionSetupException {
        super(table, partition, inputSplit, projectedColumns, context, hiveConf, proxyUgi);
    }

    @Override
    public void internalInit(Properties tableProperties, RecordReader<Object, Object> reader) {
        this.key = reader.createKey();
        this.value = reader.createValue();
    }

    @Override
    public int next() {
        for (ValueVector vv : this.vectors) {
            AllocationHelper.allocateNew((ValueVector)vv, (int)4000);
        }
        if (this.empty) {
            this.setValueCountAndPopulatePartitionVectors(0);
            return 0;
        }
        try {
            int recordCount;
            for (recordCount = 0; recordCount < 4000 && this.hasNextValue(this.value); ++recordCount) {
                Object deSerializedValue = this.partitionDeserializer.deserialize((Writable)this.value);
                if (this.partTblObjectInspectorConverter != null) {
                    deSerializedValue = this.partTblObjectInspectorConverter.convert(deSerializedValue);
                }
                this.readHiveRecordAndInsertIntoRecordBatch(deSerializedValue, recordCount);
            }
            this.setValueCountAndPopulatePartitionVectors(recordCount);
            return recordCount;
        }
        catch (SerDeException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }
}

