/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;

public class HivePartitionHolder {
    private final Map<Path, Integer> keyToIndexMapper;
    private final List<List<String>> partitionValues;

    @JsonCreator
    public HivePartitionHolder(@JsonProperty(value="keyToIndexMapper") Map<Path, Integer> keyToIndexMapper, @JsonProperty(value="partitionValues") List<List<String>> partitionValues) {
        this.keyToIndexMapper = keyToIndexMapper;
        this.partitionValues = partitionValues;
    }

    public HivePartitionHolder() {
        this.keyToIndexMapper = new HashMap<Path, Integer>();
        this.partitionValues = new ArrayList<List<String>>();
    }

    @JsonProperty
    public Map<Path, Integer> getKeyToIndexMapper() {
        return this.keyToIndexMapper;
    }

    @JsonProperty
    public List<List<String>> getPartitionValues() {
        return this.partitionValues;
    }

    public void add(Path key, List<String> values) {
        int index = this.partitionValues.indexOf(values);
        if (index == -1) {
            index = this.partitionValues.size();
            this.partitionValues.add(values);
        }
        this.keyToIndexMapper.put(key, index);
    }

    public List<String> get(Path key) {
        Integer index = this.keyToIndexMapper.get(key);
        if (index == null) {
            return Collections.emptyList();
        }
        return this.partitionValues.get(index);
    }
}

