/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.drill.exec.store.dfs.ReadEntryWithPath;
import org.apache.drill.exec.store.hive.HiveMetadataProvider;
import org.apache.drill.exec.store.hive.HivePartitionHolder;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.parquet.BaseParquetMetadataProvider;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.metadata.Metadata;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.ql.io.parquet.ProjectionPusher;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;

public class HiveParquetTableMetadataProvider
extends BaseParquetMetadataProvider {
    private final HiveStoragePlugin hiveStoragePlugin;
    private final HivePartitionHolder hivePartitionHolder;

    public HiveParquetTableMetadataProvider(List<ReadEntryWithPath> entries, HivePartitionHolder hivePartitionHolder, HiveStoragePlugin hiveStoragePlugin, ParquetReaderConfig readerConfig) throws IOException {
        super(entries, readerConfig);
        this.hiveStoragePlugin = hiveStoragePlugin;
        this.hivePartitionHolder = hivePartitionHolder;
        this.init(null);
    }

    public HiveParquetTableMetadataProvider(HiveStoragePlugin hiveStoragePlugin, List<HiveMetadataProvider.LogicalInputSplit> logicalInputSplits, ParquetReaderConfig readerConfig) throws IOException {
        super(null, readerConfig);
        this.hiveStoragePlugin = hiveStoragePlugin;
        this.hivePartitionHolder = new HivePartitionHolder();
        for (HiveMetadataProvider.LogicalInputSplit logicalInputSplit : logicalInputSplits) {
            Iterator<InputSplit> iterator = logicalInputSplit.getInputSplits().iterator();
            assert (iterator.hasNext());
            InputSplit split = iterator.next();
            assert (split instanceof FileSplit);
            FileSplit fileSplit = (FileSplit)split;
            Path finalPath = fileSplit.getPath();
            Path pathString = Path.getPathWithoutSchemeAndAuthority((Path)finalPath);
            this.entries.add(new ReadEntryWithPath(pathString));
            Partition partition = logicalInputSplit.getPartition();
            if (partition == null) continue;
            this.hivePartitionHolder.add(pathString, partition.getValues());
        }
        this.init(null);
    }

    public HivePartitionHolder getHivePartitionHolder() {
        return this.hivePartitionHolder;
    }

    protected void initInternal() throws IOException {
        LinkedHashMap<FileStatus, FileSystem> fileStatusConfMap = new LinkedHashMap<FileStatus, FileSystem>();
        for (ReadEntryWithPath entry : this.entries) {
            Path path = entry.getPath();
            JobConf conf = new ProjectionPusher().pushProjectionsAndFilters(new JobConf((Configuration)this.hiveStoragePlugin.getHiveConf()), path.getParent());
            FileSystem fs = path.getFileSystem((Configuration)conf);
            fileStatusConfMap.put(fs.getFileStatus(Path.getPathWithoutSchemeAndAuthority((Path)path)), fs);
        }
        this.parquetTableMetadata = Metadata.getParquetTableMetadata(fileStatusConfMap, (ParquetReaderConfig)this.readerConfig);
    }
}

