/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.hive.HiveDrillNativeParquetRowGroupScan;
import org.apache.drill.exec.store.parquet.AbstractParquetScanBatchCreator;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class HiveDrillNativeParquetScanBatchCreator
extends AbstractParquetScanBatchCreator
implements BatchCreator<HiveDrillNativeParquetRowGroupScan> {
    public CloseableRecordBatch getBatch(ExecutorFragmentContext context, HiveDrillNativeParquetRowGroupScan rowGroupScan, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        OperatorContext oContext = context.newOperatorContext((PhysicalOperator)rowGroupScan);
        return this.getBatch(context, rowGroupScan, oContext);
    }

    protected AbstractParquetScanBatchCreator.AbstractDrillFileSystemManager getDrillFileSystemCreator(OperatorContext operatorContext, OptionManager optionManager) {
        return new HiveDrillNativeParquetDrillFileSystemManager(operatorContext);
    }

    private class HiveDrillNativeParquetDrillFileSystemManager
    extends AbstractParquetScanBatchCreator.AbstractDrillFileSystemManager {
        private final Map<Path, DrillFileSystem> fileSystems;

        HiveDrillNativeParquetDrillFileSystemManager(OperatorContext operatorContext) {
            super((AbstractParquetScanBatchCreator)HiveDrillNativeParquetScanBatchCreator.this, operatorContext);
            this.fileSystems = new HashMap<Path, DrillFileSystem>();
        }

        protected DrillFileSystem get(Configuration config, Path path) throws ExecutionSetupException {
            DrillFileSystem fs = this.fileSystems.get(path);
            if (fs == null) {
                try {
                    fs = this.operatorContext.newNonTrackingFileSystem(config);
                }
                catch (IOException e) {
                    throw new ExecutionSetupException(String.format("Failed to create non-tracking DrillFileSystem: %s", e.getMessage()), (Throwable)e);
                }
                this.fileSystems.put(path, fs);
            }
            return fs;
        }
    }
}

