/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractGroupScanWithMetadata;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.ReadEntryWithPath;
import org.apache.drill.exec.store.hive.HiveDrillNativeParquetRowGroupScan;
import org.apache.drill.exec.store.hive.HiveMetadataProvider;
import org.apache.drill.exec.store.hive.HiveParquetTableMetadataProvider;
import org.apache.drill.exec.store.hive.HivePartitionHolder;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.hive.HiveStoragePluginConfig;
import org.apache.drill.exec.store.parquet.AbstractParquetGroupScan;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.RowGroupReadEntry;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.metastore.LocationProvider;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.hadoop.fs.Path;

@JsonTypeName(value="hive-drill-native-parquet-scan")
public class HiveDrillNativeParquetScan
extends AbstractParquetGroupScan {
    private final HiveStoragePlugin hiveStoragePlugin;
    private final HivePartitionHolder hivePartitionHolder;
    private final Map<String, String> confProperties;

    @JsonCreator
    public HiveDrillNativeParquetScan(@JacksonInject StoragePluginRegistry engineRegistry, @JsonProperty(value="userName") String userName, @JsonProperty(value="hiveStoragePluginConfig") HiveStoragePluginConfig hiveStoragePluginConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="entries") List<ReadEntryWithPath> entries, @JsonProperty(value="hivePartitionHolder") HivePartitionHolder hivePartitionHolder, @JsonProperty(value="confProperties") Map<String, String> confProperties, @JsonProperty(value="readerConfig") ParquetReaderConfig readerConfig, @JsonProperty(value="filter") LogicalExpression filter) throws IOException, ExecutionSetupException {
        super(ImpersonationUtil.resolveUserName((String)userName), columns, entries, readerConfig, filter);
        this.hiveStoragePlugin = (HiveStoragePlugin)engineRegistry.getPlugin((StoragePluginConfig)hiveStoragePluginConfig);
        this.confProperties = confProperties;
        this.metadataProvider = new HiveParquetTableMetadataProvider(entries, hivePartitionHolder, this.hiveStoragePlugin, readerConfig);
        HiveParquetTableMetadataProvider hiveMetadataProvider = (HiveParquetTableMetadataProvider)this.metadataProvider;
        this.hivePartitionHolder = hiveMetadataProvider.getHivePartitionHolder();
        this.fileSet = hiveMetadataProvider.getFileSet();
        this.init();
    }

    public HiveDrillNativeParquetScan(String userName, List<SchemaPath> columns, HiveStoragePlugin hiveStoragePlugin, List<HiveMetadataProvider.LogicalInputSplit> logicalInputSplits, Map<String, String> confProperties, ParquetReaderConfig readerConfig) throws IOException {
        this(userName, columns, hiveStoragePlugin, logicalInputSplits, confProperties, readerConfig, (LogicalExpression)ValueExpressions.BooleanExpression.TRUE);
    }

    public HiveDrillNativeParquetScan(String userName, List<SchemaPath> columns, HiveStoragePlugin hiveStoragePlugin, List<HiveMetadataProvider.LogicalInputSplit> logicalInputSplits, Map<String, String> confProperties, ParquetReaderConfig readerConfig, LogicalExpression filter) throws IOException {
        super(userName, columns, new ArrayList(), readerConfig, filter);
        this.hiveStoragePlugin = hiveStoragePlugin;
        this.confProperties = confProperties;
        this.metadataProvider = new HiveParquetTableMetadataProvider(hiveStoragePlugin, logicalInputSplits, readerConfig);
        HiveParquetTableMetadataProvider hiveMetadataProvider = (HiveParquetTableMetadataProvider)this.metadataProvider;
        this.entries = hiveMetadataProvider.getEntries();
        this.hivePartitionHolder = hiveMetadataProvider.getHivePartitionHolder();
        this.fileSet = hiveMetadataProvider.getFileSet();
        this.init();
    }

    private HiveDrillNativeParquetScan(HiveDrillNativeParquetScan that) {
        super((AbstractParquetGroupScan)that);
        this.hiveStoragePlugin = that.hiveStoragePlugin;
        this.hivePartitionHolder = that.hivePartitionHolder;
        this.confProperties = that.confProperties;
    }

    @JsonProperty
    public HiveStoragePluginConfig getHiveStoragePluginConfig() {
        return this.hiveStoragePlugin.getConfig();
    }

    @JsonProperty
    public HivePartitionHolder getHivePartitionHolder() {
        return this.hivePartitionHolder;
    }

    @JsonProperty
    public Map<String, String> getConfProperties() {
        return this.confProperties;
    }

    public SubScan getSpecificScan(int minorFragmentId) {
        List readEntries = this.getReadEntries(minorFragmentId);
        HivePartitionHolder subPartitionHolder = new HivePartitionHolder();
        for (RowGroupReadEntry readEntry : readEntries) {
            List<String> values = this.hivePartitionHolder.get(readEntry.getPath());
            subPartitionHolder.add(readEntry.getPath(), values);
        }
        return new HiveDrillNativeParquetRowGroupScan(this.getUserName(), this.hiveStoragePlugin, readEntries, this.columns, subPartitionHolder, this.confProperties, this.readerConfig, this.filter, (TupleSchema)this.getTableMetadata().getSchema());
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new HiveDrillNativeParquetScan(this);
    }

    public HiveDrillNativeParquetScan clone(FileSelection selection) throws IOException {
        HiveDrillNativeParquetScan newScan = new HiveDrillNativeParquetScan(this);
        newScan.modifyFileSelection(selection);
        newScan.init();
        return newScan;
    }

    public GroupScan clone(List<SchemaPath> columns) {
        HiveDrillNativeParquetScan newScan = new HiveDrillNativeParquetScan(this);
        newScan.columns = columns;
        return newScan;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HiveDrillNativeParquetScan [");
        builder.append("entries=").append(this.entries);
        builder.append(", numFiles=").append(this.getEntries().size());
        builder.append(", numRowGroups=").append(this.getRowGroupsMetadata().size());
        String filterString = this.getFilterString();
        if (!filterString.isEmpty()) {
            builder.append(", filter=").append(filterString);
        }
        builder.append(", columns=").append(this.columns);
        builder.append("]");
        return builder.toString();
    }

    protected AbstractParquetGroupScan.RowGroupScanFilterer getFilterer() {
        return new HiveDrillNativeParquetScanFilterer(this);
    }

    protected Collection<CoordinationProtos.DrillbitEndpoint> getDrillbits() {
        return this.hiveStoragePlugin.getContext().getBits();
    }

    protected AbstractParquetGroupScan cloneWithFileSelection(Collection<Path> filePaths) throws IOException {
        FileSelection newSelection = new FileSelection(null, new ArrayList<Path>(filePaths), null, null, false);
        return this.clone(newSelection);
    }

    protected boolean supportsFileImplicitColumns() {
        return true;
    }

    protected List<String> getPartitionValues(LocationProvider locationProvider) {
        return this.hivePartitionHolder.get(locationProvider.getLocation());
    }

    private class HiveDrillNativeParquetScanFilterer
    extends AbstractParquetGroupScan.RowGroupScanFilterer {
        public HiveDrillNativeParquetScanFilterer(HiveDrillNativeParquetScan source) {
            super((AbstractGroupScanWithMetadata)source);
        }

        protected AbstractParquetGroupScan getNewScan() {
            return new HiveDrillNativeParquetScan((HiveDrillNativeParquetScan)this.source);
        }
    }
}

