/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerConfigurationFactory;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerDefaultConfigurationFactory;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerSuppliedConfigurationFactory;
import org.glassfish.jersey.server.mvc.spi.AbstractTemplateProcessor;
import org.jvnet.hk2.annotations.Optional;

final class FreemarkerViewProcessor
extends AbstractTemplateProcessor<Template> {
    private final FreemarkerConfigurationFactory factory;

    @Inject
    public FreemarkerViewProcessor(javax.ws.rs.core.Configuration config, final ServiceLocator serviceLocator, final @Optional ServletContext servletContext) {
        super(config, servletContext, "freemarker", new String[]{"ftl"});
        this.factory = (FreemarkerConfigurationFactory)this.getTemplateObjectFactory(serviceLocator, FreemarkerConfigurationFactory.class, (Value)new Value<FreemarkerConfigurationFactory>(){

            public FreemarkerConfigurationFactory get() {
                Configuration configuration = (Configuration)FreemarkerViewProcessor.this.getTemplateObjectFactory(serviceLocator, Configuration.class, Values.empty());
                if (configuration == null) {
                    return new FreemarkerDefaultConfigurationFactory(servletContext);
                }
                return new FreemarkerSuppliedConfigurationFactory(configuration);
            }
        });
    }

    protected Template resolve(String templateReference, Reader reader) throws Exception {
        return this.factory.getConfiguration().getTemplate(templateReference);
    }

    public void writeTo(Template template, final Viewable viewable, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream out) throws IOException {
        try {
            Object model = viewable.getModel();
            if (!(model instanceof Map)) {
                model = new HashMap<String, Object>(){
                    {
                        this.put("model", viewable.getModel());
                    }
                };
            }
            Charset encoding = this.setContentType(mediaType, httpHeaders);
            template.process(model, (Writer)new OutputStreamWriter(out, encoding));
        }
        catch (TemplateException te) {
            throw new ContainerException((Throwable)te);
        }
    }
}

