/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.type;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.msgpack.type.ArrayValue;
import org.msgpack.type.ArrayValueImpl;
import org.msgpack.type.BigIntegerValueImpl;
import org.msgpack.type.BooleanValue;
import org.msgpack.type.ByteArrayRawValueImpl;
import org.msgpack.type.DoubleValueImpl;
import org.msgpack.type.FalseValueImpl;
import org.msgpack.type.FloatValue;
import org.msgpack.type.FloatValueImpl;
import org.msgpack.type.IntValueImpl;
import org.msgpack.type.IntegerValue;
import org.msgpack.type.LongValueImpl;
import org.msgpack.type.MapValue;
import org.msgpack.type.NilValue;
import org.msgpack.type.RawValue;
import org.msgpack.type.SequentialMapValueImpl;
import org.msgpack.type.StringRawValueImpl;
import org.msgpack.type.TrueValueImpl;
import org.msgpack.type.Value;

public final class ValueFactory {
    public static NilValue createNilValue() {
        return NilValue.getInstance();
    }

    public static BooleanValue createBooleanValue(boolean v) {
        if (v) {
            return TrueValueImpl.getInstance();
        }
        return FalseValueImpl.getInstance();
    }

    public static IntegerValue createIntegerValue(byte v) {
        return new IntValueImpl(v);
    }

    public static IntegerValue createIntegerValue(short v) {
        return new IntValueImpl(v);
    }

    public static IntegerValue createIntegerValue(int v) {
        return new IntValueImpl(v);
    }

    public static IntegerValue createIntegerValue(long v) {
        return new LongValueImpl(v);
    }

    public static IntegerValue createIntegerValue(BigInteger v) {
        return new BigIntegerValueImpl(v);
    }

    public static FloatValue createFloatValue(float v) {
        return new FloatValueImpl(v);
    }

    public static FloatValue createFloatValue(double v) {
        return new DoubleValueImpl(v);
    }

    public static RawValue createRawValue() {
        return ByteArrayRawValueImpl.getEmptyInstance();
    }

    public static RawValue createRawValue(byte[] b) {
        return ValueFactory.createRawValue(b, false);
    }

    public static RawValue createRawValue(byte[] b, boolean gift) {
        return new ByteArrayRawValueImpl(b, gift);
    }

    public static RawValue createRawValue(byte[] b, int off, int len) {
        return new ByteArrayRawValueImpl(b, off, len);
    }

    public static RawValue createRawValue(String s) {
        return new StringRawValueImpl(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RawValue createRawValue(ByteBuffer bb) {
        int pos = bb.position();
        try {
            byte[] buf = new byte[bb.remaining()];
            bb.get(buf);
            ByteArrayRawValueImpl byteArrayRawValueImpl = new ByteArrayRawValueImpl(buf, true);
            return byteArrayRawValueImpl;
        }
        finally {
            bb.position(pos);
        }
    }

    public static ArrayValue createArrayValue() {
        return ArrayValueImpl.getEmptyInstance();
    }

    public static ArrayValue createArrayValue(Value[] array) {
        if (array.length == 0) {
            return ArrayValueImpl.getEmptyInstance();
        }
        return ValueFactory.createArrayValue(array, false);
    }

    public static ArrayValue createArrayValue(Value[] array, boolean gift) {
        if (array.length == 0) {
            return ArrayValueImpl.getEmptyInstance();
        }
        return new ArrayValueImpl(array, gift);
    }

    public static MapValue createMapValue() {
        return SequentialMapValueImpl.getEmptyInstance();
    }

    public static MapValue createMapValue(Value[] kvs) {
        if (kvs.length == 0) {
            return SequentialMapValueImpl.getEmptyInstance();
        }
        return ValueFactory.createMapValue(kvs, false);
    }

    public static MapValue createMapValue(Value[] kvs, boolean gift) {
        if (kvs.length == 0) {
            return SequentialMapValueImpl.getEmptyInstance();
        }
        return new SequentialMapValueImpl(kvs, gift);
    }

    private ValueFactory() {
    }
}

