/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import hive.com.google.common.base.Function;
import hive.com.google.common.base.Predicate;
import java.text.Collator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

public class ReplicationSpec {
    private boolean isInReplicationScope = false;
    private boolean isMetadataOnly = false;
    private String eventId = null;
    private String currStateId = null;
    private boolean isNoop = false;
    private boolean isLazy = false;
    private boolean isInsert = false;
    private static Collator collator = Collator.getInstance();

    public ReplicationSpec(ASTNode node) {
        if (node != null) {
            if (ReplicationSpec.isApplicable(node)) {
                this.init(node);
                return;
            }
            for (int i = 1; i < node.getChildCount(); ++i) {
                ASTNode child = (ASTNode)node.getChild(i);
                if (!ReplicationSpec.isApplicable(child)) continue;
                this.init(child);
                return;
            }
        }
    }

    public ReplicationSpec() {
        this((ASTNode)null);
    }

    public ReplicationSpec(boolean isInReplicationScope, boolean isMetadataOnly, String eventReplicationState, String currentReplicationState, boolean isNoop, boolean isLazy, boolean isInsert) {
        this.isInReplicationScope = isInReplicationScope;
        this.isMetadataOnly = isMetadataOnly;
        this.eventId = eventReplicationState;
        this.currStateId = currentReplicationState;
        this.isNoop = isNoop;
        this.isLazy = isLazy;
        this.isInsert = isInsert;
    }

    public ReplicationSpec(Function<String, String> keyFetcher) {
        String scope = keyFetcher.apply(KEY.REPL_SCOPE.toString());
        this.isMetadataOnly = false;
        this.isInReplicationScope = false;
        if (scope != null) {
            if (scope.equalsIgnoreCase("metadata")) {
                this.isMetadataOnly = true;
                this.isInReplicationScope = true;
            } else if (scope.equalsIgnoreCase("all")) {
                this.isInReplicationScope = true;
            }
        }
        this.eventId = keyFetcher.apply(KEY.EVENT_ID.toString());
        this.currStateId = keyFetcher.apply(KEY.CURR_STATE_ID.toString());
        this.isNoop = Boolean.parseBoolean(keyFetcher.apply(KEY.NOOP.toString()));
        this.isLazy = Boolean.parseBoolean(keyFetcher.apply(KEY.LAZY.toString()));
        this.isInsert = Boolean.parseBoolean(keyFetcher.apply(KEY.IS_INSERT.toString()));
    }

    public static boolean isApplicable(ASTNode node) {
        return node.getToken().getType() == 882;
    }

    public static boolean allowReplacement(String currReplState, String replacementReplState) {
        if (currReplState == null || currReplState.isEmpty()) {
            return true;
        }
        if (replacementReplState == null || replacementReplState.isEmpty()) {
            return false;
        }
        long currReplStateLong = Long.parseLong(currReplState.replaceAll("\\D", ""));
        long replacementReplStateLong = Long.parseLong(replacementReplState.replaceAll("\\D", ""));
        if (currReplStateLong != 0L || replacementReplStateLong != 0L) {
            return currReplStateLong - replacementReplStateLong <= 0L;
        }
        return collator.compare(currReplState.toLowerCase(), replacementReplState.toLowerCase()) <= 0;
    }

    public boolean allowReplacementInto(org.apache.hadoop.hive.ql.metadata.Partition ptn) {
        return ReplicationSpec.allowReplacement(ReplicationSpec.getLastReplicatedStateFromParameters(ptn.getParameters()), this.getCurrentReplicationState());
    }

    public boolean allowReplacementInto(Partition ptn) {
        return ReplicationSpec.allowReplacement(ReplicationSpec.getLastReplicatedStateFromParameters(ptn.getParameters()), this.getCurrentReplicationState());
    }

    public boolean allowEventReplacementInto(org.apache.hadoop.hive.ql.metadata.Partition ptn) {
        return ReplicationSpec.allowReplacement(ReplicationSpec.getLastReplicatedStateFromParameters(ptn.getParameters()), this.getReplicationState());
    }

    public boolean allowReplacementInto(Table table) {
        return ReplicationSpec.allowReplacement(ReplicationSpec.getLastReplicatedStateFromParameters(table.getParameters()), this.getCurrentReplicationState());
    }

    public boolean allowEventReplacementInto(Table table) {
        return ReplicationSpec.allowReplacement(ReplicationSpec.getLastReplicatedStateFromParameters(table.getParameters()), this.getReplicationState());
    }

    public Predicate<org.apache.hadoop.hive.ql.metadata.Partition> allowEventReplacementInto() {
        return new Predicate<org.apache.hadoop.hive.ql.metadata.Partition>(){

            @Override
            public boolean apply(@Nullable org.apache.hadoop.hive.ql.metadata.Partition partition) {
                if (partition == null) {
                    return false;
                }
                return ReplicationSpec.this.allowEventReplacementInto(partition);
            }
        };
    }

    private static String getLastReplicatedStateFromParameters(Map<String, String> m) {
        if (m != null && m.containsKey(KEY.CURR_STATE_ID.toString())) {
            return m.get(KEY.CURR_STATE_ID.toString());
        }
        return null;
    }

    private void init(ASTNode node) {
        this.isInReplicationScope = true;
        this.eventId = PlanUtils.stripQuotes(node.getChild(0).getText());
        if (node.getChildCount() > 1 && node.getChild(1).getText().toLowerCase().equals("metadata")) {
            this.isMetadataOnly = true;
        }
    }

    public boolean isInReplicationScope() {
        return this.isInReplicationScope;
    }

    public boolean isMetadataOnly() {
        return this.isMetadataOnly;
    }

    public void setIsMetadataOnly(boolean isMetadataOnly) {
        this.isMetadataOnly = isMetadataOnly;
    }

    public boolean isInsert() {
        return this.isInsert;
    }

    public void setIsInsert(boolean isInsert) {
        this.isInsert = isInsert;
    }

    public String getReplicationState() {
        return this.eventId;
    }

    public String getCurrentReplicationState() {
        return this.currStateId;
    }

    public void setCurrentReplicationState(String currStateId) {
        this.currStateId = currStateId;
    }

    public boolean isNoop() {
        return this.isNoop;
    }

    public void setNoop(boolean isNoop) {
        this.isNoop = isNoop;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public void setLazy(boolean isLazy) {
        this.isLazy = isLazy;
    }

    public String get(KEY key) {
        switch (key) {
            case REPL_SCOPE: {
                switch (this.getScope()) {
                    case MD_ONLY: {
                        return "metadata";
                    }
                    case REPL: {
                        return "all";
                    }
                    case NO_REPL: {
                        return "none";
                    }
                }
            }
            case EVENT_ID: {
                return this.getReplicationState();
            }
            case CURR_STATE_ID: {
                return this.getCurrentReplicationState();
            }
            case NOOP: {
                return String.valueOf(this.isNoop());
            }
            case LAZY: {
                return String.valueOf(this.isLazy());
            }
            case IS_INSERT: {
                return String.valueOf(this.isInsert());
            }
        }
        return null;
    }

    public SCOPE getScope() {
        if (this.isInReplicationScope()) {
            if (this.isMetadataOnly()) {
                return SCOPE.MD_ONLY;
            }
            return SCOPE.REPL;
        }
        return SCOPE.NO_REPL;
    }

    public static class ReplStateMap<K, V extends Comparable>
    extends HashMap<K, V> {
        @Override
        public V put(K k, V v) {
            if (!this.containsKey(k)) {
                return (V)((Comparable)super.put(k, v));
            }
            Comparable oldValue = (Comparable)this.get(k);
            if (v.compareTo((Comparable)oldValue) > 0) {
                return (V)((Comparable)super.put(k, v));
            }
            return (V)oldValue;
        }
    }

    public static enum SCOPE {
        NO_REPL,
        MD_ONLY,
        REPL;

    }

    public static enum KEY {
        REPL_SCOPE("repl.scope"),
        EVENT_ID("repl.event.id"),
        CURR_STATE_ID("repl.last.id"),
        NOOP("repl.noop"),
        LAZY("repl.lazy"),
        IS_INSERT("repl.is.insert");

        private final String keyName;

        private KEY(String s) {
            this.keyName = s;
        }

        public String toString() {
            return this.keyName;
        }
    }
}

