/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSemiJoinRule
extends RelOptRule {
    public static final HiveSemiJoinRule INSTANCE = new HiveSemiJoinRule(HiveRelFactories.HIVE_BUILDER);
    protected static final Logger LOG = LoggerFactory.getLogger(HiveSemiJoinRule.class);

    private HiveSemiJoinRule(RelBuilderFactory relBuilder) {
        super(HiveSemiJoinRule.operand(Project.class, (RelOptRuleOperandChildren)HiveSemiJoinRule.some((RelOptRuleOperand)HiveSemiJoinRule.operand(Join.class, (RelOptRuleOperandChildren)HiveSemiJoinRule.some((RelOptRuleOperand)HiveSemiJoinRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveSemiJoinRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{HiveSemiJoinRule.operand(Aggregate.class, (RelOptRuleOperandChildren)HiveSemiJoinRule.any())})), (RelOptRuleOperand[])new RelOptRuleOperand[0])), relBuilder, null);
    }

    public void onMatch(RelOptRuleCall call) {
        LOG.debug("Matched HiveSemiJoinRule");
        Project project = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        RelNode left = call.rel(2);
        Aggregate aggregate = (Aggregate)call.rel(3);
        RelOptCluster cluster = join.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        ImmutableBitSet bits = RelOptUtil.InputFinder.bits((List)project.getProjects(), null);
        ImmutableBitSet rightBits = ImmutableBitSet.range((int)left.getRowType().getFieldCount(), (int)join.getRowType().getFieldCount());
        if (bits.intersects(rightBits)) {
            return;
        }
        JoinInfo joinInfo = join.analyzeCondition();
        if (!joinInfo.rightSet().equals((Object)ImmutableBitSet.range((int)aggregate.getGroupCount()))) {
            return;
        }
        if (join.getJoinType() == JoinRelType.LEFT) {
            call.transformTo(call.builder().push(left).project((Iterable)project.getProjects(), (Iterable)project.getRowType().getFieldNames()).build());
            return;
        }
        if (join.getJoinType() != JoinRelType.INNER) {
            return;
        }
        if (!joinInfo.isEqui()) {
            return;
        }
        LOG.debug("All conditions matched for HiveSemiJoinRule. Going to apply transformation.");
        ArrayList newRightKeyBuilder = Lists.newArrayList();
        List aggregateKeys = aggregate.getGroupSet().asList();
        Iterator iterator = joinInfo.rightKeys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            newRightKeyBuilder.add(aggregateKeys.get(key));
        }
        ImmutableIntList newRightKeys = ImmutableIntList.copyOf(newRightKeyBuilder);
        RelNode newRight = aggregate.getInput();
        RexNode newCondition = RelOptUtil.createEquiJoinCondition((RelNode)left, (List)joinInfo.leftKeys, (RelNode)newRight, (List)newRightKeys, (RexBuilder)rexBuilder);
        RelNode semi = null;
        if (aggregate.getInput() instanceof HepRelVertex && ((HepRelVertex)aggregate.getInput()).getCurrentRel() instanceof Join) {
            Join rightJoin = (Join)((HepRelVertex)aggregate.getInput()).getCurrentRel();
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            for (int i = 0; i < rightJoin.getRowType().getFieldCount(); ++i) {
                projects.add(rexBuilder.makeInputRef((RelNode)rightJoin, i));
            }
            RelNode topProject = call.builder().push((RelNode)rightJoin).project(projects, (Iterable)rightJoin.getRowType().getFieldNames(), true).build();
            semi = call.builder().push(left).push(topProject).semiJoin(new RexNode[]{newCondition}).build();
        } else {
            semi = call.builder().push(left).push(aggregate.getInput()).semiJoin(new RexNode[]{newCondition}).build();
        }
        call.transformTo(call.builder().push(semi).project((Iterable)project.getProjects(), (Iterable)project.getRowType().getFieldNames()).build());
    }
}

