/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import hive.com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManagerImpl;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbTxnManager
extends HiveTxnManagerImpl {
    private static final String CLASS_NAME = DbTxnManager.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private volatile DbLockManager lockMgr = null;
    private volatile long txnId = 0L;
    private int statementId = -1;
    private String queryId;
    private static ScheduledExecutorService heartbeatExecutorService = null;
    private ScheduledFuture<?> heartbeatTask = null;
    private Runnable shutdownRunner = new Runnable(){

        @Override
        public void run() {
            if (heartbeatExecutorService != null && !heartbeatExecutorService.isShutdown() && !heartbeatExecutorService.isTerminated()) {
                LOG.info("Shutting down Heartbeater thread pool.");
                heartbeatExecutorService.shutdown();
            }
        }
    };
    private static final int SHUTDOWN_HOOK_PRIORITY = 0;
    private Hive hive = null;

    IMetaStoreClient getMS() throws LockException {
        try {
            return this.hive.getMSC();
        }
        catch (MetaException e) {
            String msg = "Unable to reach Hive Metastore: " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new LockException(e);
        }
    }

    DbTxnManager() {
        ShutdownHookManager.addShutdownHook(this.shutdownRunner, 0);
    }

    @Override
    void setHiveConf(HiveConf conf) {
        super.setHiveConf(conf);
        if (!conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY)) {
            throw new RuntimeException(ErrorMsg.DBTXNMGR_REQUIRES_CONCURRENCY.getMsg());
        }
    }

    @Override
    public long openTxn(Context ctx, String user) throws LockException {
        return this.openTxn(ctx, user, 0L);
    }

    @VisibleForTesting
    long openTxn(Context ctx, String user, long delay) throws LockException {
        this.init();
        if (this.isTxnOpen()) {
            throw new LockException("Transaction already opened. " + JavaUtils.txnIdToString(this.txnId));
        }
        try {
            this.txnId = this.getMS().openTxn(user);
            this.statementId = 0;
            LOG.debug("Opened " + JavaUtils.txnIdToString(this.txnId));
            ctx.setHeartbeater(this.startHeartbeat(delay));
            return this.txnId;
        }
        catch (TException e) {
            throw new LockException(e, ErrorMsg.METASTORE_COMMUNICATION_FAILED);
        }
    }

    @Override
    public HiveLockManager getLockManager() throws LockException {
        this.init();
        if (this.lockMgr == null) {
            this.lockMgr = new DbLockManager(this.conf, this);
        }
        return this.lockMgr;
    }

    @Override
    public void acquireLocks(QueryPlan plan, Context ctx, String username) throws LockException {
        try {
            this.acquireLocksWithHeartbeatDelay(plan, ctx, username, 0L);
        }
        catch (LockException e) {
            if (e.getCause() instanceof TxnAbortedException) {
                this.txnId = 0L;
                this.statementId = -1;
            }
            throw e;
        }
    }

    LockState acquireLocks(QueryPlan plan, Context ctx, String username, boolean isBlocking) throws LockException {
        LockComponent comp;
        Table t;
        LockComponentBuilder compBuilder;
        this.init();
        this.getLockManager();
        boolean atLeastOneLock = false;
        this.queryId = plan.getQueryId();
        LockRequestBuilder rqstBuilder = new LockRequestBuilder(this.queryId);
        LOG.info("Setting lock request transaction to " + JavaUtils.txnIdToString(this.txnId) + " for queryId=" + this.queryId);
        rqstBuilder.setTransactionId(this.txnId).setUser(username);
        block18: for (ReadEntity input : plan.getInputs()) {
            if (!input.needsLock() || input.isUpdateOrDelete() || input.getType() == Entity.Type.TABLE && input.getTable().isTemporary()) continue;
            compBuilder = new LockComponentBuilder();
            compBuilder.setShared();
            compBuilder.setOperationType(DataOperationType.SELECT);
            t = null;
            switch (input.getType()) {
                case DATABASE: {
                    compBuilder.setDbName(input.getDatabase().getName());
                    break;
                }
                case TABLE: {
                    t = input.getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                case PARTITION: 
                case DUMMYPARTITION: {
                    compBuilder.setPartitionName(input.getPartition().getName());
                    t = input.getPartition().getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                default: {
                    continue block18;
                }
            }
            if (t != null && AcidUtils.isAcidTable(t)) {
                compBuilder.setIsAcid(true);
            }
            comp = compBuilder.build();
            LOG.debug("Adding lock component to lock request " + comp.toString());
            rqstBuilder.addLockComponent(comp);
            atLeastOneLock = true;
        }
        block19: for (WriteEntity output : plan.getOutputs()) {
            LOG.debug("output is null " + (output == null));
            if (output.getType() == Entity.Type.DFS_DIR || output.getType() == Entity.Type.LOCAL_DIR || output.getType() == Entity.Type.TABLE && output.getTable().isTemporary()) continue;
            compBuilder = new LockComponentBuilder();
            t = null;
            switch (output.getWriteType()) {
                case DDL_EXCLUSIVE: 
                case INSERT_OVERWRITE: {
                    compBuilder.setExclusive();
                    compBuilder.setOperationType(DataOperationType.NO_TXN);
                    break;
                }
                case INSERT: {
                    t = DbTxnManager.getTable(output);
                    if (AcidUtils.isAcidTable(t)) {
                        compBuilder.setShared();
                        compBuilder.setIsAcid(true);
                    } else {
                        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_TXN_STRICT_LOCKING_MODE)) {
                            compBuilder.setExclusive();
                        } else {
                            compBuilder.setShared();
                        }
                        compBuilder.setIsAcid(false);
                    }
                    compBuilder.setOperationType(DataOperationType.INSERT);
                    break;
                }
                case DDL_SHARED: {
                    compBuilder.setShared();
                    compBuilder.setOperationType(DataOperationType.NO_TXN);
                    break;
                }
                case UPDATE: {
                    compBuilder.setSemiShared();
                    compBuilder.setOperationType(DataOperationType.UPDATE);
                    t = DbTxnManager.getTable(output);
                    break;
                }
                case DELETE: {
                    compBuilder.setSemiShared();
                    compBuilder.setOperationType(DataOperationType.DELETE);
                    t = DbTxnManager.getTable(output);
                    break;
                }
                case DDL_NO_LOCK: {
                    continue block19;
                }
                default: {
                    throw new RuntimeException("Unknown write type " + output.getWriteType().toString());
                }
            }
            switch (output.getType()) {
                case DATABASE: {
                    compBuilder.setDbName(output.getDatabase().getName());
                    break;
                }
                case TABLE: 
                case DUMMYPARTITION: {
                    t = output.getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                case PARTITION: {
                    compBuilder.setPartitionName(output.getPartition().getName());
                    t = output.getPartition().getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                default: {
                    continue block19;
                }
            }
            if (t != null && AcidUtils.isAcidTable(t)) {
                compBuilder.setIsAcid(true);
            }
            compBuilder.setIsDynamicPartitionWrite(output.isDynamicPartitionWrite());
            comp = compBuilder.build();
            LOG.debug("Adding lock component to lock request " + comp.toString());
            rqstBuilder.addLockComponent(comp);
            atLeastOneLock = true;
        }
        if (!atLeastOneLock) {
            LOG.debug("No locks needed for queryId" + this.queryId);
            return null;
        }
        ArrayList<HiveLock> locks = new ArrayList<HiveLock>(1);
        LockState lockState = this.lockMgr.lock(rqstBuilder.build(), this.queryId, isBlocking, locks);
        ctx.setHiveLocks(locks);
        return lockState;
    }

    private static Table getTable(WriteEntity we) {
        Table t = we.getTable();
        if (t == null) {
            throw new IllegalStateException("No table info for " + we);
        }
        return t;
    }

    @VisibleForTesting
    void acquireLocksWithHeartbeatDelay(QueryPlan plan, Context ctx, String username, long delay) throws LockException {
        LockState ls = this.acquireLocks(plan, ctx, username, true);
        if (ls != null && !this.isTxnOpen()) {
            ctx.setHeartbeater(this.startHeartbeat(delay));
        }
    }

    @Override
    public void releaseLocks(List<HiveLock> hiveLocks) throws LockException {
        if (this.lockMgr != null) {
            this.stopHeartbeat();
            this.lockMgr.releaseLocks(hiveLocks);
        }
    }

    @Override
    public void commitTxn() throws LockException {
        if (!this.isTxnOpen()) {
            throw new RuntimeException("Attempt to commit before opening a transaction");
        }
        try {
            this.lockMgr.clearLocalLockRecords();
            this.stopHeartbeat();
            LOG.debug("Committing txn " + JavaUtils.txnIdToString(this.txnId));
            this.getMS().commitTxn(this.txnId);
        }
        catch (NoSuchTxnException e) {
            LOG.error("Metastore could not find " + JavaUtils.txnIdToString(this.txnId));
            throw new LockException(e, ErrorMsg.TXN_NO_SUCH_TRANSACTION, JavaUtils.txnIdToString(this.txnId));
        }
        catch (TxnAbortedException e) {
            LockException le = new LockException(e, ErrorMsg.TXN_ABORTED, JavaUtils.txnIdToString(this.txnId), e.getMessage());
            LOG.error(le.getMessage());
            throw le;
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
        finally {
            this.txnId = 0L;
            this.statementId = -1;
        }
    }

    @Override
    public void rollbackTxn() throws LockException {
        if (!this.isTxnOpen()) {
            throw new RuntimeException("Attempt to rollback before opening a transaction");
        }
        try {
            this.lockMgr.clearLocalLockRecords();
            this.stopHeartbeat();
            LOG.debug("Rolling back " + JavaUtils.txnIdToString(this.txnId));
            this.getMS().rollbackTxn(this.txnId);
        }
        catch (NoSuchTxnException e) {
            LOG.error("Metastore could not find " + JavaUtils.txnIdToString(this.txnId));
            throw new LockException(e, ErrorMsg.TXN_NO_SUCH_TRANSACTION, JavaUtils.txnIdToString(this.txnId));
        }
        catch (TxnAbortedException e) {
            throw new LockException(e, ErrorMsg.TXN_ABORTED, JavaUtils.txnIdToString(this.txnId));
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
        finally {
            this.txnId = 0L;
            this.statementId = -1;
        }
    }

    @Override
    public void heartbeat() throws LockException {
        List<HiveLock> locks;
        if (this.isTxnOpen()) {
            DbLockManager.DbHiveLock dummyLock = new DbLockManager.DbHiveLock(0L);
            locks = new ArrayList<HiveLock>(1);
            locks.add(dummyLock);
        } else {
            locks = this.lockMgr.getLocks(false, false);
        }
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("Sending heartbeat for ").append(JavaUtils.txnIdToString(this.txnId)).append(" and");
            for (HiveLock lock2 : locks) {
                sb.append(" ").append(lock2.toString());
            }
            LOG.info(sb.toString());
        }
        if (!this.isTxnOpen() && locks.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No need to send heartbeat as there is no transaction and no locks.");
            }
            return;
        }
        for (HiveLock lock3 : locks) {
            long lockId = ((DbLockManager.DbHiveLock)lock3).lockId;
            try {
                this.getMS().heartbeat(this.txnId, lockId);
            }
            catch (NoSuchLockException e) {
                LOG.error("Unable to find lock " + JavaUtils.lockIdToString(lockId));
                throw new LockException(e, ErrorMsg.LOCK_NO_SUCH_LOCK, JavaUtils.lockIdToString(lockId));
            }
            catch (NoSuchTxnException e) {
                LOG.error("Unable to find transaction " + JavaUtils.txnIdToString(this.txnId));
                throw new LockException(e, ErrorMsg.TXN_NO_SUCH_TRANSACTION, JavaUtils.txnIdToString(this.txnId));
            }
            catch (TxnAbortedException e) {
                LockException le = new LockException(e, ErrorMsg.TXN_ABORTED, JavaUtils.txnIdToString(this.txnId), e.getMessage());
                LOG.error(le.getMessage());
                throw le;
            }
            catch (TException e) {
                throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg() + "(" + JavaUtils.txnIdToString(this.txnId) + "," + lock3.toString() + ")", e);
            }
        }
    }

    private Heartbeater startHeartbeat(long initialDelay) throws LockException {
        long heartbeatInterval = DbTxnManager.getHeartbeatInterval(this.conf);
        assert (heartbeatInterval > 0L);
        Heartbeater heartbeater = new Heartbeater(this, this.conf, this.queryId);
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && this.conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODEFAILHEARTBEATER)) {
            initialDelay = 0L;
        } else if (initialDelay == 0L) {
            initialDelay = heartbeatInterval;
        }
        this.heartbeatTask = heartbeatExecutorService.scheduleAtFixedRate(heartbeater, initialDelay, heartbeatInterval, TimeUnit.MILLISECONDS);
        LOG.info("Started heartbeat with delay/interval = " + initialDelay + "/" + heartbeatInterval + " " + (Object)((Object)TimeUnit.MILLISECONDS) + " for query: " + this.queryId);
        return heartbeater;
    }

    private void stopHeartbeat() throws LockException {
        if (this.heartbeatTask != null) {
            this.heartbeatTask.cancel(true);
            long startTime = System.currentTimeMillis();
            long sleepInterval = 100L;
            while (!this.heartbeatTask.isCancelled() && !this.heartbeatTask.isDone()) {
                long now = System.currentTimeMillis();
                if (now - startTime > 30000L) {
                    LOG.warn("Heartbeat task cannot be cancelled for unknown reason. QueryId: " + this.queryId);
                    break;
                }
                try {
                    Thread.sleep(sleepInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                sleepInterval *= 2L;
            }
            if (this.heartbeatTask.isCancelled() || this.heartbeatTask.isDone()) {
                LOG.info("Stopped heartbeat for query: " + this.queryId);
            }
            this.heartbeatTask = null;
            this.queryId = null;
        }
    }

    @Override
    public ValidTxnList getValidTxns() throws LockException {
        this.init();
        try {
            return this.getMS().getValidTxns(this.txnId);
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public String getTxnManagerName() {
        return CLASS_NAME;
    }

    @Override
    public boolean supportsExplicitLock() {
        return false;
    }

    @Override
    public boolean useNewShowLocksFormat() {
        return true;
    }

    @Override
    public boolean supportsAcid() {
        return true;
    }

    @Override
    protected void destruct() {
        try {
            this.stopHeartbeat();
            if (this.shutdownRunner != null) {
                ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
            }
            if (this.isTxnOpen()) {
                this.rollbackTxn();
            }
            if (this.lockMgr != null) {
                this.lockMgr.close();
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception " + e.getClass().getName() + " with message <" + e.getMessage() + ">, swallowing as there is nothing we can do with it.");
        }
    }

    private void init() throws LockException {
        if (this.conf == null) {
            throw new RuntimeException("Must call setHiveConf before any other methods.");
        }
        this.initHiveDb();
        this.initHeartbeatExecutorService();
    }

    private synchronized void initHiveDb() throws LockException {
        try {
            if (this.hive == null) {
                this.hive = Hive.get(this.conf);
            }
        }
        catch (HiveException e) {
            String msg = "Unable to reach Hive Metastore: " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new LockException(e);
        }
    }

    private synchronized void initHeartbeatExecutorService() {
        if (heartbeatExecutorService != null && !heartbeatExecutorService.isShutdown() && !heartbeatExecutorService.isTerminated()) {
            return;
        }
        heartbeatExecutorService = Executors.newScheduledThreadPool(this.conf.getIntVar(HiveConf.ConfVars.HIVE_TXN_HEARTBEAT_THREADPOOL_SIZE), new ThreadFactory(){
            private final AtomicInteger threadCounter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new HeartbeaterThread(r, "Heartbeater-" + this.threadCounter.getAndIncrement());
            }
        });
        ((ScheduledThreadPoolExecutor)heartbeatExecutorService).setRemoveOnCancelPolicy(true);
    }

    @Override
    public boolean isTxnOpen() {
        return this.txnId > 0L;
    }

    @Override
    public long getCurrentTxnId() {
        return this.txnId;
    }

    @Override
    public int getWriteIdAndIncrement() {
        assert (this.isTxnOpen());
        return this.statementId++;
    }

    private static long getHeartbeatInterval(Configuration conf) throws LockException {
        long interval = HiveConf.getTimeVar(conf, HiveConf.ConfVars.HIVE_TXN_TIMEOUT, TimeUnit.MILLISECONDS) / 2L;
        if (interval == 0L) {
            throw new LockException(HiveConf.ConfVars.HIVE_TXN_MANAGER.toString() + " not set, heartbeats won't be sent");
        }
        return interval;
    }

    public static class Heartbeater
    implements Runnable {
        private HiveTxnManager txnMgr;
        private HiveConf conf;
        LockException lockException;
        private final String queryId;

        public LockException getLockException() {
            return this.lockException;
        }

        Heartbeater(HiveTxnManager txnMgr, HiveConf conf, String queryId) {
            this.txnMgr = txnMgr;
            this.conf = conf;
            this.lockException = null;
            this.queryId = queryId;
        }

        @Override
        public void run() {
            try {
                if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && this.conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODEFAILHEARTBEATER)) {
                    throw new LockException(HiveConf.ConfVars.HIVETESTMODEFAILHEARTBEATER.name() + "=true");
                }
                LOG.debug("Heartbeating...");
                this.txnMgr.heartbeat();
            }
            catch (LockException e) {
                LOG.error("Failed trying to heartbeat queryId=" + this.queryId + ": " + e.getMessage());
                this.lockException = e;
            }
            catch (Throwable t) {
                LOG.error("Failed trying to heartbeat queryId=" + this.queryId + ": " + t.getMessage(), t);
                this.lockException = new LockException("Failed trying to heartbeat queryId=" + this.queryId + ": " + t.getMessage(), t);
            }
        }
    }

    public static class HeartbeaterThread
    extends Thread {
        HeartbeaterThread(Runnable target, String name) {
            super(target, name);
            this.setDaemon(true);
        }
    }
}

