/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.avro;

import hive.org.apache.avro.Schema;
import hive.org.apache.avro.file.DataFileReader;
import hive.org.apache.avro.file.FileReader;
import hive.org.apache.avro.generic.GenericData;
import hive.org.apache.avro.generic.GenericDatumReader;
import hive.org.apache.avro.generic.GenericRecord;
import hive.org.apache.avro.mapred.FsInput;
import java.io.IOException;
import java.rmi.server.UID;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroGenericRecordReader
implements RecordReader<NullWritable, AvroGenericRecordWritable>,
JobConfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(AvroGenericRecordReader.class);
    private final FileReader<GenericRecord> reader;
    private final long start;
    private final long stop;
    protected JobConf jobConf;
    private final boolean isEmptyInput;
    private final UID recordReaderID;

    public AvroGenericRecordReader(JobConf job, FileSplit split, Reporter reporter) throws IOException {
        Schema latest;
        this.jobConf = job;
        try {
            latest = this.getSchema(job, split);
        }
        catch (AvroSerdeException e) {
            throw new IOException(e);
        }
        GenericDatumReader gdr = new GenericDatumReader();
        if (latest != null) {
            gdr.setExpected(latest);
        }
        if (split.getLength() == 0L) {
            this.isEmptyInput = true;
            this.start = 0L;
            this.reader = null;
        } else {
            this.isEmptyInput = false;
            this.reader = new DataFileReader<GenericRecord>(new FsInput(split.getPath(), (Configuration)job), gdr);
            this.reader.sync(split.getStart());
            this.start = this.reader.tell();
        }
        this.stop = split.getStart() + split.getLength();
        this.recordReaderID = new UID();
    }

    private Schema getSchema(JobConf job, FileSplit split) throws AvroSerdeException, IOException {
        String s;
        if (AvroSerdeUtils.insideMRJob(job)) {
            MapWork mapWork = Utilities.getMapWork((Configuration)job);
            for (Map.Entry<Path, PartitionDesc> pathsAndParts : mapWork.getPathToPartitionInfo().entrySet()) {
                Properties props;
                Path partitionPath = pathsAndParts.getKey();
                if (!this.pathIsInPartition(split.getPath(), partitionPath)) continue;
                if (LOG.isInfoEnabled()) {
                    LOG.info("Matching partition " + partitionPath + " with input split " + split);
                }
                if ((props = pathsAndParts.getValue().getProperties()).containsKey(AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName()) || props.containsKey(AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName())) {
                    return AvroSerdeUtils.determineSchemaOrThrowException((Configuration)job, props);
                }
                return null;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Unable to match filesplit " + split + " with a partition.");
            }
        }
        if ((s = job.get(AvroSerdeUtils.AvroTableProperties.AVRO_SERDE_SCHEMA.getPropName())) != null) {
            LOG.info("Found the avro schema in the job: " + s);
            return AvroSerdeUtils.getSchemaFor(s);
        }
        return null;
    }

    private boolean pathIsInPartition(Path split, Path partitionPath) {
        boolean schemeless;
        boolean bl = schemeless = split.toUri().getScheme() == null;
        if (schemeless) {
            Path pathNoSchema = Path.getPathWithoutSchemeAndAuthority((Path)partitionPath);
            return FileUtils.isPathWithinSubtree(split, pathNoSchema);
        }
        return FileUtils.isPathWithinSubtree(split, partitionPath);
    }

    public boolean next(NullWritable nullWritable, AvroGenericRecordWritable record) throws IOException {
        if (this.isEmptyInput || !this.reader.hasNext() || this.reader.pastSync(this.stop)) {
            return false;
        }
        GenericData.Record r = (GenericData.Record)this.reader.next();
        record.setRecord(r);
        record.setRecordReaderID(this.recordReaderID);
        record.setFileSchema(this.reader.getSchema());
        return true;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public AvroGenericRecordWritable createValue() {
        return new AvroGenericRecordWritable();
    }

    public long getPos() throws IOException {
        return this.isEmptyInput ? 0L : this.reader.tell();
    }

    public void close() throws IOException {
        if (!this.isEmptyInput) {
            this.reader.close();
        }
    }

    public float getProgress() throws IOException {
        return this.stop == this.start ? 0.0f : Math.min(1.0f, (float)(this.getPos() - this.start) / (float)(this.stop - this.start));
    }

    public void configure(JobConf jobConf) {
        this.jobConf = jobConf;
    }
}

