/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import hive.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.spark.MapInput;
import org.apache.hadoop.hive.ql.exec.spark.ReduceTran;
import org.apache.hadoop.hive.ql.exec.spark.ShuffleTran;
import org.apache.hadoop.hive.ql.exec.spark.SparkShuffler;
import org.apache.hadoop.hive.ql.exec.spark.SparkTran;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.BytesWritable;
import org.apache.spark.api.java.JavaPairRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkPlan {
    private static final String CLASS_NAME = SparkPlan.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(SparkPlan.class);
    private final PerfLogger perfLogger = SessionState.getPerfLogger();
    private final Set<SparkTran> rootTrans = new HashSet<SparkTran>();
    private final Set<SparkTran> leafTrans = new HashSet<SparkTran>();
    private final Map<SparkTran, List<SparkTran>> transGraph = new HashMap<SparkTran, List<SparkTran>>();
    private final Map<SparkTran, List<SparkTran>> invertedTransGraph = new HashMap<SparkTran, List<SparkTran>>();
    private final Set<Integer> cachedRDDIds = new HashSet<Integer>();

    public JavaPairRDD<HiveKey, BytesWritable> generateGraph() {
        this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkBuildRDDGraph");
        HashMap<SparkTran, JavaPairRDD> tranToOutputRDDMap = new HashMap<SparkTran, JavaPairRDD>();
        for (SparkTran tran : this.getAllTrans()) {
            JavaPairRDD rdd = null;
            List<SparkTran> parents = this.getParents(tran);
            if (parents.size() == 0) {
                Preconditions.checkArgument(tran instanceof MapInput, "AssertionError: tran must be an instance of MapInput");
                rdd = tran.transform(null);
            } else {
                for (SparkTran parent : parents) {
                    JavaPairRDD prevRDD = (JavaPairRDD)tranToOutputRDDMap.get(parent);
                    if (rdd == null) {
                        rdd = prevRDD;
                        continue;
                    }
                    rdd = rdd.union(prevRDD);
                }
                rdd = tran.transform(rdd);
            }
            tranToOutputRDDMap.put(tran, rdd);
        }
        this.logSparkPlan();
        JavaPairRDD finalRDD = null;
        for (SparkTran leafTran : this.leafTrans) {
            JavaPairRDD rdd = (JavaPairRDD)tranToOutputRDDMap.get(leafTran);
            if (finalRDD == null) {
                finalRDD = rdd;
                continue;
            }
            finalRDD = finalRDD.union(rdd);
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "SparkBuildRDDGraph");
        if (LOG.isDebugEnabled()) {
            LOG.info("print generated spark rdd graph:\n" + SparkUtilities.rddGraphToString(finalRDD));
        }
        return finalRDD;
    }

    private void addNumberToTrans() {
        int i = 1;
        String name = null;
        for (SparkTran leaf : this.leafTrans) {
            name = leaf.getName() + " " + i++;
            leaf.setName(name);
        }
        Set<SparkTran> sparkTrans = this.transGraph.keySet();
        for (SparkTran tran : sparkTrans) {
            name = tran.getName() + " " + i++;
            tran.setName(name);
        }
    }

    private void logSparkPlan() {
        this.addNumberToTrans();
        ArrayList<SparkTran> leafTran = new ArrayList<SparkTran>();
        leafTran.addAll(this.leafTrans);
        for (SparkTran leaf : this.leafTrans) {
            this.collectLeafTrans(leaf, leafTran);
        }
        StringBuilder sparkPlan = new StringBuilder("\n\t!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Spark Plan !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! \n\n");
        for (SparkTran leaf : leafTran) {
            sparkPlan.append(leaf.getName());
            this.getSparkPlan(leaf, sparkPlan);
            sparkPlan.append("\n");
        }
        sparkPlan.append(" \n\t!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Spark Plan !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! ");
        LOG.info(sparkPlan.toString());
    }

    private void collectLeafTrans(SparkTran leaf, List<SparkTran> reduceTrans) {
        List<SparkTran> parents = this.getParents(leaf);
        if (parents.size() > 0) {
            SparkTran nextLeaf = null;
            for (SparkTran leafTran : parents) {
                if (leafTran instanceof ReduceTran) {
                    reduceTrans.add(leafTran);
                    continue;
                }
                if (this.getParents(leafTran).size() <= 0) continue;
                nextLeaf = leafTran;
            }
            if (nextLeaf != null) {
                this.collectLeafTrans(nextLeaf, reduceTrans);
            }
        }
    }

    private void getSparkPlan(SparkTran tran, StringBuilder sparkPlan) {
        List<SparkTran> parents = this.getParents(tran);
        ArrayList<SparkTran> nextLeaf = new ArrayList<SparkTran>();
        if (parents.size() > 0) {
            sparkPlan.append(" <-- ");
            boolean isFirst = true;
            for (SparkTran leaf : parents) {
                if (isFirst) {
                    sparkPlan.append("( " + leaf.getName());
                    if (leaf instanceof ShuffleTran) {
                        this.logShuffleTranStatus((ShuffleTran)leaf, sparkPlan);
                    } else {
                        this.logCacheStatus(leaf, sparkPlan);
                    }
                    isFirst = false;
                } else {
                    sparkPlan.append("," + leaf.getName());
                    if (leaf instanceof ShuffleTran) {
                        this.logShuffleTranStatus((ShuffleTran)leaf, sparkPlan);
                    } else {
                        this.logCacheStatus(leaf, sparkPlan);
                    }
                }
                if (this.getParents(leaf).size() <= 0 || leaf instanceof ReduceTran) continue;
                nextLeaf.add(leaf);
            }
            sparkPlan.append(" ) ");
            if (nextLeaf.size() > 1) {
                this.logLeafTran(nextLeaf, sparkPlan);
            } else if (nextLeaf.size() != 0) {
                this.getSparkPlan((SparkTran)nextLeaf.get(0), sparkPlan);
            }
        }
    }

    private void logLeafTran(List<SparkTran> parent, StringBuilder sparkPlan) {
        sparkPlan.append(" <-- ");
        boolean isFirst = true;
        for (SparkTran sparkTran : parent) {
            List<SparkTran> parents = this.getParents(sparkTran);
            SparkTran leaf = parents.get(0);
            if (isFirst) {
                sparkPlan.append("( " + leaf.getName());
                if (leaf instanceof ShuffleTran) {
                    this.logShuffleTranStatus((ShuffleTran)leaf, sparkPlan);
                } else {
                    this.logCacheStatus(leaf, sparkPlan);
                }
                isFirst = false;
                continue;
            }
            sparkPlan.append("," + leaf.getName());
            if (leaf instanceof ShuffleTran) {
                this.logShuffleTranStatus((ShuffleTran)leaf, sparkPlan);
                continue;
            }
            this.logCacheStatus(leaf, sparkPlan);
        }
        sparkPlan.append(" ) ");
    }

    private void logShuffleTranStatus(ShuffleTran leaf, StringBuilder sparkPlan) {
        int noOfPartitions = leaf.getNoOfPartitions();
        sparkPlan.append(" ( Partitions " + noOfPartitions);
        SparkShuffler shuffler = leaf.getShuffler();
        sparkPlan.append(", " + shuffler.getName());
        if (leaf.isCacheEnable().booleanValue()) {
            sparkPlan.append(", Cache on");
        } else {
            sparkPlan.append(", Cache off");
        }
    }

    private void logCacheStatus(SparkTran sparkTran, StringBuilder sparkPlan) {
        if (sparkTran.isCacheEnable() != null) {
            if (sparkTran.isCacheEnable().booleanValue()) {
                sparkPlan.append(" (cache on) ");
            } else {
                sparkPlan.append(" (cache off) ");
            }
        }
    }

    public void addTran(SparkTran tran) {
        this.rootTrans.add(tran);
        this.leafTrans.add(tran);
    }

    public void addCachedRDDId(int rddId) {
        this.cachedRDDIds.add(rddId);
    }

    public Set<Integer> getCachedRDDIds() {
        return this.cachedRDDIds;
    }

    private List<SparkTran> getAllTrans() {
        LinkedList<SparkTran> result = new LinkedList<SparkTran>();
        HashSet<SparkTran> seen = new HashSet<SparkTran>();
        for (SparkTran leaf : this.leafTrans) {
            this.visit(leaf, seen, result);
        }
        return result;
    }

    private void visit(SparkTran child, Set<SparkTran> seen, List<SparkTran> result) {
        if (seen.contains(child)) {
            return;
        }
        seen.add(child);
        for (SparkTran parent : this.getParents(child)) {
            if (seen.contains(parent)) continue;
            this.visit(parent, seen, result);
        }
        result.add(child);
    }

    public void connect(SparkTran parent, SparkTran child) {
        this.rootTrans.remove(child);
        this.leafTrans.remove(parent);
        if (this.transGraph.get(parent) == null) {
            this.transGraph.put(parent, new LinkedList());
        }
        if (this.invertedTransGraph.get(child) == null) {
            this.invertedTransGraph.put(child, new LinkedList());
        }
        this.transGraph.get(parent).add(child);
        this.invertedTransGraph.get(child).add(parent);
    }

    public List<SparkTran> getParents(SparkTran tran) {
        if (!this.invertedTransGraph.containsKey(tran)) {
            return new ArrayList<SparkTran>();
        }
        return this.invertedTransGraph.get(tran);
    }

    public List<SparkTran> getChildren(SparkTran tran) {
        if (!this.transGraph.containsKey(tran)) {
            return new ArrayList<SparkTran>();
        }
        return this.transGraph.get(tran);
    }
}

