/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import hive.com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.llap.FieldDesc;
import org.apache.hadoop.hive.llap.Schema;
import org.apache.hadoop.hive.llap.TypeDesc;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class Row {
    private final Schema schema;
    private final Writable[] colValues;
    private final boolean[] nullIndicators;
    private Map<String, Integer> nameToIndexMapping;

    public Row(Schema schema) {
        this.schema = schema;
        this.colValues = new Writable[schema.getColumns().size()];
        this.nullIndicators = new boolean[schema.getColumns().size()];
        this.nameToIndexMapping = new HashMap<String, Integer>(schema.getColumns().size());
        List<FieldDesc> colDescs = schema.getColumns();
        for (int idx = 0; idx < colDescs.size(); ++idx) {
            FieldDesc colDesc = colDescs.get(idx);
            this.nameToIndexMapping.put(colDesc.getName(), idx);
            this.colValues[idx] = this.createWritableForType(colDesc.getTypeDesc());
        }
    }

    public Writable getValue(int colIndex) {
        if (this.nullIndicators[colIndex]) {
            return null;
        }
        return this.colValues[colIndex];
    }

    public Writable getValue(String colName) {
        Integer idx = this.nameToIndexMapping.get(colName);
        Preconditions.checkArgument(idx != null);
        return this.getValue(idx);
    }

    public Schema getSchema() {
        return this.schema;
    }

    void setValue(int colIdx, Writable value) {
        Preconditions.checkArgument(colIdx <= this.schema.getColumns().size());
        if (value == null) {
            this.nullIndicators[colIdx] = true;
        } else {
            this.nullIndicators[colIdx] = false;
            FieldDesc colDesc = this.schema.getColumns().get(colIdx);
            switch (colDesc.getTypeDesc().getType()) {
                case BOOLEAN: {
                    ((BooleanWritable)this.colValues[colIdx]).set(((BooleanWritable)value).get());
                    break;
                }
                case TINYINT: {
                    ((ByteWritable)this.colValues[colIdx]).set(((ByteWritable)value).get());
                    break;
                }
                case SMALLINT: {
                    ((ShortWritable)this.colValues[colIdx]).set(((ShortWritable)value).get());
                    break;
                }
                case INT: {
                    ((IntWritable)this.colValues[colIdx]).set(((IntWritable)value).get());
                    break;
                }
                case BIGINT: {
                    ((LongWritable)this.colValues[colIdx]).set(((LongWritable)value).get());
                    break;
                }
                case FLOAT: {
                    ((FloatWritable)this.colValues[colIdx]).set(((FloatWritable)value).get());
                    break;
                }
                case DOUBLE: {
                    ((DoubleWritable)this.colValues[colIdx]).set(((DoubleWritable)value).get());
                    break;
                }
                case STRING: 
                case CHAR: 
                case VARCHAR: {
                    ((Text)this.colValues[colIdx]).set((Text)value);
                    break;
                }
                case DATE: {
                    ((DateWritable)this.colValues[colIdx]).set((DateWritable)value);
                    break;
                }
                case TIMESTAMP: {
                    ((TimestampWritable)this.colValues[colIdx]).set((TimestampWritable)value);
                    break;
                }
                case BINARY: {
                    ((BytesWritable)this.colValues[colIdx]).set((BytesWritable)value);
                    break;
                }
                case DECIMAL: {
                    ((HiveDecimalWritable)this.colValues[colIdx]).set((HiveDecimalWritable)value);
                }
            }
        }
    }

    private Writable createWritableForType(TypeDesc typeDesc) {
        switch (typeDesc.getType()) {
            case BOOLEAN: {
                return new BooleanWritable();
            }
            case TINYINT: {
                return new ByteWritable();
            }
            case SMALLINT: {
                return new ShortWritable();
            }
            case INT: {
                return new IntWritable();
            }
            case BIGINT: {
                return new LongWritable();
            }
            case FLOAT: {
                return new FloatWritable();
            }
            case DOUBLE: {
                return new DoubleWritable();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new Text();
            }
            case DATE: {
                return new DateWritable();
            }
            case TIMESTAMP: {
                return new TimestampWritable();
            }
            case BINARY: {
                return new BytesWritable();
            }
            case DECIMAL: {
                return new HiveDecimalWritable();
            }
        }
        throw new RuntimeException("Cannot create writable for " + (Object)((Object)typeDesc.getType()));
    }
}

