/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import com.mapr.web.security.SslConfig;
import com.mapr.web.security.WebSecurityManager;

public final class MapRKeystoreReader {
    private static final String MAPR_SEC_ENABLED = "mapr_sec_enabled";

    private MapRKeystoreReader() {
    }

    public static String getClientKeystoreLocation() {
        try (SslConfig sslConfig = WebSecurityManager.getSslConfig((SslConfig.SslConfigScope)SslConfig.SslConfigScope.SCOPE_CLIENT_ONLY);){
            String string = sslConfig.getClientKeystoreLocation();
            return string;
        }
    }

    public static String getClientKeystorePassword() {
        try (SslConfig sslConfig = WebSecurityManager.getSslConfig((SslConfig.SslConfigScope)SslConfig.SslConfigScope.SCOPE_CLIENT_ONLY);){
            String string = new String(sslConfig.getClientKeystorePassword());
            return string;
        }
    }

    public static boolean isSecurityEnabled() {
        String mapRSecurityEnabled = System.getProperty(MAPR_SEC_ENABLED);
        if (!MapRKeystoreReader.isSecurityFlagSet()) {
            return false;
        }
        return "true".equalsIgnoreCase(mapRSecurityEnabled.trim());
    }

    public static boolean isSecurityFlagSet() {
        String mapRSecurityEnabled = System.getProperty(MAPR_SEC_ENABLED);
        return mapRSecurityEnabled != null && !mapRSecurityEnabled.isEmpty();
    }
}

