/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.io;

import hive.org.apache.parquet.Log;
import hive.org.apache.parquet.io.api.Binary;
import hive.org.apache.parquet.io.api.RecordConsumer;
import java.util.Arrays;

public class RecordConsumerLoggingWrapper
extends RecordConsumer {
    private static final Log logger = Log.getLog(RecordConsumerLoggingWrapper.class);
    private static final boolean DEBUG = Log.DEBUG;
    private final RecordConsumer delegate;
    int indent = 0;

    public RecordConsumerLoggingWrapper(RecordConsumer delegate) {
        this.delegate = delegate;
    }

    @Override
    public void startField(String field, int index) {
        if (DEBUG) {
            this.logOpen(field);
        }
        this.delegate.startField(field, index);
    }

    private void logOpen(String field) {
        this.log("<" + field + ">");
    }

    private String indent() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            result.append("  ");
        }
        return result.toString();
    }

    private void log(Object value) {
        logger.debug(this.indent() + value);
    }

    @Override
    public void startGroup() {
        if (DEBUG) {
            ++this.indent;
        }
        if (DEBUG) {
            this.log("<!-- start group -->");
        }
        this.delegate.startGroup();
    }

    @Override
    public void addInteger(int value) {
        if (DEBUG) {
            this.log(value);
        }
        this.delegate.addInteger(value);
    }

    @Override
    public void addLong(long value) {
        if (DEBUG) {
            this.log(value);
        }
        this.delegate.addLong(value);
    }

    @Override
    public void addBoolean(boolean value) {
        if (DEBUG) {
            this.log(value);
        }
        this.delegate.addBoolean(value);
    }

    @Override
    public void addBinary(Binary value) {
        if (DEBUG) {
            this.log(Arrays.toString(value.getBytesUnsafe()));
        }
        this.delegate.addBinary(value);
    }

    @Override
    public void addFloat(float value) {
        if (DEBUG) {
            this.log(Float.valueOf(value));
        }
        this.delegate.addFloat(value);
    }

    @Override
    public void addDouble(double value) {
        if (DEBUG) {
            this.log(value);
        }
        this.delegate.addDouble(value);
    }

    @Override
    public void endGroup() {
        if (DEBUG) {
            this.log("<!-- end group -->");
        }
        if (DEBUG) {
            --this.indent;
        }
        this.delegate.endGroup();
    }

    @Override
    public void endField(String field, int index) {
        if (DEBUG) {
            this.logClose(field);
        }
        this.delegate.endField(field, index);
    }

    private void logClose(String field) {
        this.log("</" + field + ">");
    }

    @Override
    public void startMessage() {
        if (DEBUG) {
            this.log("<!-- start message -->");
        }
        this.delegate.startMessage();
    }

    @Override
    public void endMessage() {
        this.delegate.endMessage();
        if (DEBUG) {
            this.log("<!-- end message -->");
        }
    }
}

