/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop.api;

import hive.org.apache.parquet.Preconditions;
import hive.org.apache.parquet.io.api.RecordConsumer;
import hive.org.apache.parquet.schema.MessageType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public abstract class WriteSupport<T> {
    public abstract WriteContext init(Configuration var1);

    public abstract void prepareForWrite(RecordConsumer var1);

    public abstract void write(T var1);

    public FinalizedWriteContext finalizeWrite() {
        return new FinalizedWriteContext(new HashMap<String, String>());
    }

    public static final class FinalizedWriteContext {
        private final Map<String, String> extraMetaData;

        public FinalizedWriteContext(Map<String, String> extraMetaData) {
            this.extraMetaData = Collections.unmodifiableMap(Preconditions.checkNotNull(extraMetaData, "extraMetaData"));
        }

        public Map<String, String> getExtraMetaData() {
            return this.extraMetaData;
        }
    }

    public static final class WriteContext {
        private final MessageType schema;
        private final Map<String, String> extraMetaData;

        public WriteContext(MessageType schema, Map<String, String> extraMetaData) {
            this.schema = Preconditions.checkNotNull(schema, "schema");
            this.extraMetaData = Collections.unmodifiableMap(Preconditions.checkNotNull(extraMetaData, "extraMetaData"));
        }

        public MessageType getSchema() {
            return this.schema;
        }

        public Map<String, String> getExtraMetaData() {
            return this.extraMetaData;
        }
    }
}

